#include "vector.h"

using namespace std;
using namespace nAPI;

long datatype = -1;

long __cdecl VectorCreate(long size) {
    return AddRCHandle(new vector<int>(size), datatype);
}

void __cdecl VectorDestroy(long id) {
    vector<int> *thevector = (vector<int>*)RecycleRCHandle(id, datatype);
	if(thevector == NULL) return;
	delete thevector;
}

void VectorClear(long id) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return;
	thevector->clear();
}

long VectorGetSize(long id) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return -1;
	return thevector->size();
}

void VectorSetSize(long id, long newsize) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return;
	thevector->resize(newsize);
}

long VectorGet(long id, long index) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return 0;
    if(index > thevector->size() - 1) return 0;
	return (*thevector)[index];
}

void VectorSet(long id, long index, long value) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return;
    if(index > thevector->size() - 1) return;
	(*thevector)[index] = value;
}
void VectorPushBack(long id, long value) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return;
	thevector->push_back(value);
}

void VectorPopBack(long id) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return;
	thevector->pop_back();
}

long VectorBack(long id) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return 0;
	return thevector->back();
}

long VectorEmpty(long id) {
    vector<int> *thevector = (vector<int>*)GetRCHandle(id, datatype);
	if(thevector == NULL) return false;
	return thevector->empty();
}

void __cdecl VectorDestructor(void* vector_to_destroy) {
    vector<int> *thevector = (vector<int>*)vector_to_destroy;
	if(thevector == NULL) return;
	delete thevector;
}

void InitRtCVector() {
    datatype = RegisterHandleDestructor(VectorDestructor);
}