#include "userinput.h"

using namespace nAPI;

#define EVENT_KEYUP 0
#define EVENT_KEYDOWN 1
#define EVENT_KEYTYPE 2

#define EVENT_LMOUSEUP 0
#define EVENT_LMOUSEDOWN 1
#define EVENT_RMOUSEUP 2
#define EVENT_RMOUSEDOWN 3
#define EVENT_MMOUSEUP 4
#define EVENT_MMOUSEDOWN 5
#define EVENT_MOUSEWHEEL 6

// global triggergroups
TriggerGroup KeyEventGroup[3];
TriggerGroup MouseEventGroup[7];
// for GetTriggerKey()
int LastKey = 0;

std::map<unsigned int, bool> KeyBlockMap;
bool MouseDisable[4];
unsigned short int TriggeringX, TriggeringY;
short int WheelDelta;

extern "C" int GameWNDParse_proc(unsigned long uMsg, unsigned long wParam, unsigned long lParam) {
	switch (uMsg) {
		case WM_KEYUP:
			if (KeyBlockMap[0] || KeyBlockMap[wParam]) return 0;
			if (KeyEventGroup[EVENT_KEYUP] != NULL) {
				LastKey = wParam;
				TriggerGroupRun(KeyEventGroup[EVENT_KEYUP]);
			}
			break;
		case WM_KEYDOWN:
			if (KeyBlockMap[0] || KeyBlockMap[wParam]) return 0;
			// only proceed if the 30th bit of lParam is 0 because that means the key wasn't down until now
			if ((((lParam>>30)&1) == 0) && (KeyEventGroup[EVENT_KEYDOWN] != NULL)) {
				LastKey = wParam;
				TriggerGroupRun(KeyEventGroup[EVENT_KEYDOWN]);
			}
			break;
		case WM_CHAR:
			if (KeyBlockMap[0] || KeyBlockMap[wParam]) return 0;
			if (KeyEventGroup[EVENT_KEYTYPE] != NULL) {
				TriggerGroupRun(KeyEventGroup[EVENT_KEYTYPE]);
			}
			break;
		case WM_LBUTTONUP:
			if (MouseDisable[0]) return 0;
			if (MouseEventGroup[0] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[0]);
			}
			break;
		case WM_LBUTTONDOWN:
			if (MouseDisable[0]) return 0;
			if (MouseEventGroup[1] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[1]);
			}
			break;
		case WM_RBUTTONUP:
			if (MouseDisable[1]) return 0;
			if (MouseEventGroup[2] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[2]);
			}
			break;
		case WM_RBUTTONDOWN:
			if (MouseDisable[1]) return 0;
			if (MouseEventGroup[3] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[3]);
			}
			break;
		case WM_MBUTTONUP:
			if (MouseDisable[2]) return 0;
			if (MouseEventGroup[4] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[4]);
			}
			break;
		case WM_MBUTTONDOWN:
			if (MouseDisable[2]) return 0;
			if (MouseEventGroup[5] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				TriggerGroupRun(MouseEventGroup[5]);
			}
			break;
		case WM_MOUSEWHEEL:
			if (MouseDisable[3]) return 0;
			if (MouseEventGroup[6] != NULL) {
				TriggeringX = LOWORD(lParam);
				TriggeringY = HIWORD(lParam);
				WheelDelta = GET_WHEEL_DELTA_WPARAM(wParam);
				TriggerGroupRun(MouseEventGroup[6]);
			}
			break;
	}
	return 1;
}

void __cdecl TriggerRegisterKeyEvent(Jass::trigger trigger, Jass::integer etype) {
	if ((etype<3) && (etype>-1)) {
		if (KeyEventGroup[etype] == NULL) { KeyEventGroup[etype] = CreateTriggerGroup(); }
		TriggerGroupAdd(KeyEventGroup[etype], trigger);
	}
}

void __cdecl TriggerRegisterMouseEvent(Jass::trigger trigger, Jass::integer etype) {
	if ((etype<7) && (etype>-1)) {
		if (MouseEventGroup[etype] == NULL) { MouseEventGroup[etype] = CreateTriggerGroup(); }
		TriggerGroupAdd(MouseEventGroup[etype], trigger);
	}
}

Jass::integer __cdecl GetTriggerKey(void) { return LastKey; }
void __cdecl SetKeyBlock(Jass::integer key, Jass::boolean doblock) { KeyBlockMap[(unsigned int)key] = doblock; }
void __cdecl SetMouseBlock(Jass::integer button, Jass::boolean doblock) { if ((button<4)&&(button>-1)) MouseDisable[button]=doblock; }
Jass::boolean __cdecl IsKeyDown(Jass::integer whichKey) {
	if (GetFocus() != GetWc3WindowHandle()) return 0;
	return (GetKeyState(whichKey) & 0x8000)!=0;
}
Jass::integer __cdecl GetTriggerWheelDelta(void) { return WheelDelta; }

Jass::real GetMouseTargetX() {
	if (MouseInfo) return RealMap(MouseInfo->MouseX);
	return 0;
}

Jass::real GetMouseTargetY() {
	if (MouseInfo) return RealMap(MouseInfo->MouseY);
	return 0;
}

Jass::real GetMouseTargetZ() {
	if (MouseInfo) return RealMap(MouseInfo->MouseZ);
	return 0;
}

Jass::real GetMouseScreenX() {
	if (MouseInfo) return RealMap(MouseInfo->MouseRelativeX);
	return 0;
}

Jass::real GetMouseScreenY() {
	if (MouseInfo) return RealMap(MouseInfo->MouseRelativeY);
	return 0;
}

Jass::boolean IsMouseOverUI() {
	if (MouseInfo) return MouseInfo->IsOverUI;
	return 0;
}

void CleanupUserInput() {
	int n;
	for (n=0; n<3; n++) if (KeyEventGroup[n]) DestroyTriggerGroup(KeyEventGroup[n]);
	for (n=0; n<7; n++) if (MouseEventGroup[n]) DestroyTriggerGroup(MouseEventGroup[n]);
	KeyBlockMap.clear();
	for (n=0; n<4; n++) MouseDisable[n] = false;
}

extern "C" void __cdecl MapStart_proc() {
	CleanupUserInput();
}

extern "C" void __cdecl MapEnd_proc() {
	CleanupUserInput();
}

Jass::integer __cdecl GetMouseX()
{
	POINT pt;
	GetCursorPos(&pt);
	return lround(pt.x);
}

Jass::integer __cdecl GetMouseY()
{
	POINT pt;
	GetCursorPos(&pt);
	return lround(pt.y);
}

void __cdecl SetMouseX(Jass::integer x)
{
	SetCursorPos(x, GetMouseY());
}

void __cdecl SetMouseY(Jass::integer y)
{
	SetCursorPos(GetMouseX(), y);
}

void __cdecl SetMousePos(Jass::integer x, Jass::integer y)
{
	SetCursorPos(x, y);
}

void __cdecl ForceKeyDown(long whichKey) {
	SendMessage(GetWc3WindowHandle(), WM_KEYDOWN, whichKey, 0);
}

void __cdecl ForceKeyUp(long whichKey) {
	SendMessage(GetWc3WindowHandle(), WM_KEYUP, whichKey, 0);
}

void __cdecl ForceKeyType(long whichKey) {
	SendMessage(GetWc3WindowHandle(), WM_CHAR, whichKey, 0);
}

