#include "misc.h"

//====================
// - String Manipulation Natives
//====================
Jass::integer StringPos(Jass::string j_input, Jass::string j_substr) {
	const char* input = nAPI::StringGet(j_input);
	const char* substr = nAPI::StringGet(j_substr);
	const char* pos = strstr(input, substr);
	if (pos == NULL) { return 0; }
	return pos-input+1;
}

Jass::integer StringRPos(Jass::string j_input, Jass::string j_substr) {
	const char* input = nAPI::StringGet(j_input);
	const char* substr = nAPI::StringGet(j_substr);
	size_t substr_size = strlen(substr);
	int n=strlen(input)-substr_size;
	if (n<0) return 0;
	for (; n>=0; n--) if (memcmp(substr, &input[n], substr_size)==0) return n+1;
	return 0;
}

Jass::string StringReplace(Jass::string j_input, Jass::string j_oldstr, Jass::string j_newstr) {
	const char* input = nAPI::StringGet(j_input);
	const char* oldstr = nAPI::StringGet(j_oldstr);
	const char* newstr = nAPI::StringGet(j_newstr);
	const char* oldpos = strstr(input, oldstr);
	if (oldpos == NULL) { return j_input; }
	char output[strlen(input)-strlen(oldstr)+strlen(newstr)+1];
	output[sizeof(output)-1] = '\0';
	memcpy(output, input, oldpos-input);
	memcpy(&output[oldpos-input], newstr, strlen(newstr));
	memcpy(&output[oldpos-input+strlen(newstr)], &oldpos[strlen(oldstr)], strlen(input)-(oldpos-input)-strlen(oldstr));
	return nAPI::StringMap(output);
}

//====================
// - BitAPI Natives
//====================
Jass::integer __cdecl BitAnd(Jass::integer a, Jass::integer b)
{
    return lround(a & b);
}

Jass::integer __cdecl BitOr(Jass::integer a, Jass::integer b)
{
    return lround(a | b);
}

Jass::integer __cdecl BitXor(Jass::integer a, Jass::integer b)
{
    return lround(a ^ b);
}

Jass::integer __cdecl BitBSL(Jass::integer a, Jass::integer b)
{
    return lround(a << b);
}

Jass::integer __cdecl BitBSR(Jass::integer a, Jass::integer b)
{
    return lround(a >> b);
}

Jass::integer __cdecl BitFlip(Jass::integer a)
{
    return lround(~a);
}

//====================
// - MoreMathAPI Natives
//====================

Jass::real __cdecl logNative(float *in) {
	float result = log10(*in);
	return nAPI::RealMap(result);
}

Jass::real __cdecl lnNative(float *in) {
	float result = log(*in);
	return nAPI::RealMap(result);
}
