unit nAPI;

{$IFDEF FPC}
  {$MODE DELPHI}
{$ENDIF}

interface

uses Windows, jass_types;

type
  TW3UNITINFO = record
    unk1: array[1..$14] of Byte;
    UnitId: Cardinal;    
    BuildTime: Cardinal;  
    RepairTime: Cardinal;  
    GoldCost: Cardinal;    
    LumberCost: Cardinal;  
    GoldRep: Cardinal;    
    LumberRep: Cardinal;  
    bountydice: Cardinal;
    bountysides: Cardinal;
    bountyplus: Cardinal;
    lumberbountydice: Cardinal;
    lumberbountysides: Cardinal;
    lumberbountyplus: Cardinal;
    stockMax: Cardinal;
    stockRegen: Single;
    stockStart: Single;
    canSleep: Cardinal;
    canFlee: Cardinal;
    fused: Cardinal;
    fmade: Cardinal;
    cargoSize: Cardinal;
    level: Cardinal;
    castpt: Single;
    castbsw: Single;
    death: Single;
    regenType: Cardinal;
    regenHP: Single;
    HP: Single;
    mana0: Single;
    manaN: Single;
    regenMana: Single;
    def: Single;
    defUp: Single;
    DefenseType: Cardinal;
    weapsOn: Cardinal;
    targs1: Cardinal;
    targs2: Cardinal;
    dmgUp1: Cardinal;
    dmgUp2: Cardinal;
    dice1: Cardinal;
    dice2: Cardinal;
    sides1: Cardinal;
    sides2: Cardinal;
    dmgplus1: Cardinal;
    dmgplus2: Cardinal;
    targCount1: Cardinal;
    targCount2: Cardinal;
    damageLoss1: Single;
    damageLoss2: Single;
    spillDist1: Single;
    spillDist2: Single;
    spillRadius1: Single;
    spillRadius2: Single;
    atkType1: Cardinal;  
    atkType2: Cardinal;
    weapType1: Cardinal;
    weapType2: Cardinal;
    weapTp1: Cardinal;
    weapTp2: Cardinal;
    rangeN1: Single;
    rangeN2: Single;
    RngBuff1: Single;
    RngBuff2: Single;
    cool1: Single;
    cool2: Single;
    dmgpt1: Single;
    dmgpt2: Single;
    backSw1: Single;
    backSw2: Single;
    splashTargs1: Cardinal;
    splashTargs2: Cardinal;
    Farea1: Single;
    Farea2: Single;
    Harea1: Single;
    Harea2: Single;
    Qarea1: Single;
    Qarea2: Single;
    Hfact1: Single;
    Hfact2: Single;
    Qfact1: Single;
    Qfact2: Single;
    unk2: array[1..$10] of Byte;
    showUI1: Cardinal;
    showUI2: Cardinal;
    STR: Cardinal;
    AGI: Cardinal;
    INT: Cardinal;
    unk3: array[1..$4] of Byte;
    STRplus: Single;
    AGIplus: Single;
    INTplus: Single;
    sight: Single;
    nsight: Single;
    acquire: Single;
    minRange: Single;
    collision: Single;
    fogRad: Single;
    unk4: array[1..$4] of Byte;
    movetp: Cardinal;
    unk5: array[1..$8] of Byte;
    targType: Cardinal;
    buffType: Cardinal;
    buffRadius: Single;
    unk6: array[1..$4] of Byte;
    deathType: Cardinal;
    unk7: array[1..$4] of Byte;
    prio: Single;
    points: Cardinal;
    spd: Single;
    minSpd: Single;
    maxSpd: Single;
    turnRate: Single;
    propWin: Single;
    orientInterp: Cardinal;
    formation: Cardinal;
    occH: Single;
    unk8: array[1..$4] of Byte;
    moveHeight: Single;
    moveFloor: Single;
    launchX: Single;
    launchY: Single;
    launchZ: Single;
    launchSwimZ: Single;
    impactZ: Single;
    impactSwimZ: Single;
    blend: Single;
    walk: Single;
    run: Single;
    repulse: Cardinal;
    repulseParam: Cardinal;
    repulseGroup: Cardinal;
    repulsePrio: Cardinal;
    unk9: array[1..$58] of Byte;
    isbldg: Cardinal;
  end;

  PW3UNITINFO = ^TW3UNITINFO;

  TW3ABILITYINFO = record
    unk1: array[1..$1C] of Byte;
    AbilityId: Cardinal;
    unk2: array[1..$8] of Byte;
    Buffart: PChar;
    Bulletart: PChar;
    Effectsound: PChar;
    Effectsoundlooped: PChar;
    Unart: PChar;
    Researchart: PChar;
    Placementmodel: PChar;
    Placementtexture: PChar;
    Globalmessage: PChar;
    Globalsound: PChar;
    ButtonposX: Cardinal;
    ButtonposY: Cardinal;
    UnbuttonposX: Cardinal;
    UnbuttonposY: Cardinal;
    ResearchbuttonposX: Cardinal;
    ResearchbuttonposY: Cardinal;
    Missilespeed: Single;
    Missilearc: Single;
    MissileHoming: Cardinal;
    Spelldetail: Cardinal;
    Scriptname: Pointer;
    Hotkey_count: Cardinal;
    Hotkey_exists: Cardinal;
    Hotkey: PCardinal;
    Unhotkey_count: Cardinal;
    Unhotkey_exists: Cardinal;
    Unhotkey: PCardinal;
    Researchhotkey_count: Cardinal;
    Researchhotkey_exists: Cardinal;
    Researchhotkey: PCardinal;
    Name_count: Cardinal;
    Name_exists: Cardinal;
    Name: PPChar;
    Art_count: Cardinal;
    Art_exists: Cardinal;
    Art: PPChar;
    TargetArt_count: Cardinal;
    TargetArt_exists: Cardinal;
    TargetArt: PPChar;
    CasterArt_count: Cardinal;
    CasterArt_exists: Cardinal;
    CasterArt: PPChar;
    EffectArt_count: Cardinal;
    EffectArt_exists: Cardinal;
    EffectArt: PPChar;
    Areaeffectart_count: Cardinal;
    Areaeffectart_exists: Cardinal;
    Areaeffectart: PPChar;
    Missileart_count: Cardinal;
    Missileart_exists: Cardinal;
    Missileart: PPChar;
    SpecialArt_count: Cardinal;
    SpecialArt_exists: Cardinal;
    SpecialArt: PPChar;
    LightningEffect_count: Cardinal;
    LightningEffect_exists: Cardinal;
    LightningEffect: PPChar;
    Bufftip_count: Cardinal;
    Bufftip_exists: Cardinal;
    Bufftip: PPChar;
    Buffubertip_count: Cardinal;
    Buffubertip_exists: Cardinal;
    Buffubertip: PPChar;
    Researchtip_count: Cardinal;
    Researchtip_exists: Cardinal;
    Researchtip: PPChar;
    Tip_count: Cardinal;
    Tip_exists: Cardinal;
    Tip: PPChar;
    Untip_count: Cardinal;
    Untip_exists: Cardinal;
    Untip: PPChar;
    Researchubertip_count: Cardinal;
    Researchubertip_exists: Cardinal;
    Researchubertip: PPChar;
    Ubertip_count: Cardinal;
    Ubertip_exists: Cardinal;
    Ubertip: PPChar;
    Unubertip_count: Cardinal;
    Unubertip_exists: Cardinal;
    Unubertip: PPChar;
    unk3: array[1..$8] of Byte;
    Animnames_count: PCardinal;
    unk4: array[1..$CC] of Byte;
  end;

  PW3ABILITYINFO = ^TW3ABILITYINFO;

  TAddNative = procedure(address: Pointer; name: PChar; params: PChar); cdecl;
  TStringMap = function(str: PChar): LongInt; cdecl;
  TStringGet = function(str: LongInt): PChar; cdecl;
  TGetUnitInfoStruct = function(unit_rawcode: LongInt): PW3UNITINFO; cdecl;
  TGetAbilityInfoStruct = function(ability_rawcode: LongInt): PW3ABILITYINFO; cdecl;

  THandleDestructor = procedure(handle: Pointer); cdecl;

  TAddRCHandle = function(input: Pointer; datatype: LongInt): LongInt; cdecl;
  TGetRCHandle = function(id, datatype: LongInt): Pointer; cdecl;
  TRecycleRCHandle = function(id, datatype: LongInt): Pointer; cdecl;
  TRegisterHandleDestructor = function(hdestructor: THandleDestructor): LongInt; cdecl;

  TGameDebugMessage = procedure(str: PChar); cdecl;

  TMouseInfoStruct = record
    MouseX, MouseY, MouseZ: Single;
    IsOverUI: LongBool;
    MouseRelativeX, MouseRelativeY: Single;
  end;

  PMouseInfoStruct = ^TMouseInfoStruct;

  TTriggerGroup = Pointer;
  TCreateTriggerGroup = function: TTriggerGroup; cdecl;
  TDestroyTriggerGroup = procedure(whichTG: TTriggerGroup); cdecl;
  TTriggerGroupAdd = procedure(whichTG: TTriggerGroup; trigger: Jass_trigger); cdecl;
  TTriggerGroupRun = procedure(whichTG: TTriggerGroup); cdecl;

  TGetWc3WindowHandle = function: HWND; cdecl;
  TGetMouseInfoStruct = function: PMouseInfoStruct; cdecl;
  TGetLastNativeNameAddr = function: PChar; cdecl;

var
  AddNative: TAddNative;
  StringMap: TStringMap;
  StringGet: TStringGet;
  GetUnitInfoStruct: TGetUnitInfoStruct;
  GetAbilityInfoStruct: TGetAbilityInfoStruct;
  AddRCHandle: TAddRCHandle;
  GetRCHandle: TGetRCHandle;
  RecycleRCHandle: TRecycleRCHandle;
  RegisterHandleDestructor: TRegisterHandleDestructor;
  GameDebugMessage: TGameDebugMessage;
  CreateTriggerGroup: TCreateTriggerGroup;
  DestroyTriggerGroup: TDestroyTriggerGroup;
  TriggerGroupAdd: TTriggerGroupAdd;
  TriggerGroupRun: TTriggerGroupRun;
  GetWc3WindowHandle: TGetWc3WindowHandle;

  MouseInfo: PMouseInfoStruct;
  LastNativeName: PChar;

function InitJAPI(m: HMODULE): Boolean;
function RealMap(invar: Single): LongInt;

implementation

function RealMap(invar: Single): LongInt;
begin
  Result := (PLongInt(@invar))^;
end;

function InitJAPI(m: HMODULE): Boolean;
var
  GetMouseInfoStruct: TGetMouseInfoStruct;
  GetLastNativeNameAddr: TGetLastNativeNameAddr;
begin
  Result := False;

  @AddNative := GetProcAddress(m, 'AddNative'); if (@AddNative = nil) then Exit;

  @StringMap := GetProcAddress(m, 'StringMap'); if (@StringMap = nil) then Exit;

  @StringGet := GetProcAddress(m, 'StringGet'); if (@StringGet = nil) then Exit;

  @GetUnitInfoStruct := GetProcAddress(m, 'GetUnitInfoStruct'); if (@GetUnitInfoStruct = nil) then Exit;

  @GetAbilityInfoStruct := GetProcAddress(m, 'GetAbilityInfoStruct'); if (@GetAbilityInfoStruct = nil) then Exit;

  @AddRCHandle := GetProcAddress(m, 'AddRCHandle'); if (@AddRCHandle = nil) then Exit;

  @GetRCHandle := GetProcAddress(m, 'GetRCHandle'); if (@GetRCHandle = nil) then Exit;

  @RecycleRCHandle := GetProcAddress(m, 'RecycleRCHandle'); if (@RecycleRCHandle = nil) then Exit;

  @RegisterHandleDestructor := GetProcAddress(m, 'RegisterHandleDestructor'); if (@RegisterHandleDestructor = nil) then Exit;

  @GameDebugMessage := GetProcAddress(m, 'GameDebugMessage'); if (@GameDebugMessage = nil) then Exit;

  @CreateTriggerGroup := GetProcAddress(m, 'CreateTriggerGroup'); if (@CreateTriggerGroup = nil) then Exit;

  @DestroyTriggerGroup := GetProcAddress(m, 'DestroyTriggerGroup'); if (@DestroyTriggerGroup = nil) then Exit;

  @TriggerGroupAdd := GetProcAddress(m, 'TriggerGroupAdd'); if (@TriggerGroupAdd = nil) then Exit;

  @TriggerGroupRun := GetProcAddress(m, 'TriggerGroupRun'); if (@TriggerGroupRun = nil) then Exit;

  @GetWc3WindowHandle := GetProcAddress(m, 'GetWc3WindowHandle'); if (@GetWc3WindowHandle = nil) then Exit;

  @GetMouseInfoStruct := GetProcAddress(m, 'GetMouseInfoStruct'); if (@GetMouseInfoStruct = nil) then Exit;

  @GetLastNativeNameAddr := GetProcAddress(m, 'GetLastNativeNameAddr'); if (@GetLastNativeNameAddr = nil) then Exit;

  MouseInfo := GetMouseInfoStruct;
  LastNativeName := GetLastNativeNameAddr;

  Result := True;
end;

end.

