library example;

uses
  SysUtils,
  Classes,
  Windows,
  Messages,
  jass_types,
  nAPI;

{$R *.res}

function SimpleNative(n: Jass_integer): Jass_integer; cdecl;
begin
  liResult := n+7;
end;

function StringNative(jass_str: LongInt): LongInt; cdecl;
var str: string;
begin
  // we need to convert jass_str, a handle Jass uses for a string, to something
  // we can use (PChar), we do this by using StringGet
  str := StringGet(jass_str);
	str := str+', but the cake is a lie!';
  // likewise, we need to make our string usable by Jass by using StringMap
  Result := StringMap(PChar(str));
end;

function RealNative(jass_real: PSingle): LongInt; cdecl;
var workreal: Single;
begin
  workreal := jass_real^;
  workreal := workreal+7.0;
  // we use RealMap when returing a real to Jass
	Result := RealMap(workreal);
end;

// callback for the when the map's main function is ran (AKA map init)
procedure MainFunction_proc; cdecl; export;
begin
	MessageBox(0, 'main function called', 'Game event', 0);
end;

// callback for when the map starts
procedure MapStart_proc; cdecl; export;
begin
	MessageBox(0, 'Map started', 'Game event', 0);
end;

// callback for when the map ends
procedure MapEnd_proc; cdecl; export;
begin
	MessageBox(0, 'Map ended', 'Game event', 0);
end;

// callback for when the game quits
procedure GameQuit_proc; cdecl; export;
begin
	MessageBox(0, 'Game quit', 'Game event', 0);
end;

// WND procedure callback
// see http://msdn.microsoft.com/en-us/library/ms633573.aspx for more info
// return value 0 means the message is blocked, anything else means it's passed to the game
function GameWNDParse_proc(uMsg, wParam, lParam: Cardinal): LongInt; cdecl; export;
begin
  Result := 1;
	// this prevents the game from registering when the mouse wheel moves
	if (uMsg = WM_MOUSEWHEEL) then Result := 0;
end;

function LoadNativePack(m: HMODULE): Boolean; cdecl; export;
begin
  Result := False;
	if (not InitJAPI(m)) then begin
    MessageBox(0, 'ERROR', 'ERROR', 0);
    Exit;
  end;
  // adding natives
  AddNative(@SimpleNative, 'SimpleNative', '(I)I');
  AddNative(@StringNative, 'StringNative', '(S)S');
  AddNative(@RealNative,   'RealNative',   '(R)R');
  Result := True;
end;

exports MainFunction_proc, MapStart_proc, MapEnd_proc, GameQuit_proc, GameWNDParse_proc, LoadNativePack;

begin

end.
