#pragma once

#include "jass_types.h"

namespace nAPI {

	struct W3UNITINFO {
		char unk1[0x14];
		unsigned long UnitId;		
		unsigned long BuildTime;	
		unsigned long RepairTime;	
		unsigned long GoldCost;		
		unsigned long LumberCost;	
		unsigned long GoldRep;		
		unsigned long LumberRep;	
		unsigned long bountydice;
		unsigned long bountysides;
		unsigned long bountyplus;
		unsigned long lumberbountydice;
		unsigned long lumberbountysides;
		unsigned long lumberbountyplus;
		unsigned long stockMax;
		float stockRegen;
		float stockStart;
		unsigned long canSleep;
		unsigned long canFlee;
		unsigned long fused;
		unsigned long fmade;
		unsigned long cargoSize;
		unsigned long level;
		float castpt;
		float castbsw;
		float death;
		unsigned long regenType;
		float regenHP;
		float HP;
		float mana0;
		float manaN;
		float regenMana;
		float def;
		float defUp;
		unsigned long DefenseType;
		unsigned long weapsOn;
		unsigned long targs1;
		unsigned long targs2;
		unsigned long dmgUp1;
		unsigned long dmgUp2;
		unsigned long dice1;
		unsigned long dice2;
		unsigned long sides1;
		unsigned long sides2;
		unsigned long dmgplus1;
		unsigned long dmgplus2;
		unsigned long targCount1;
		unsigned long targCount2;
		float damageLoss1;
		float damageLoss2;
		float spillDist1;
		float spillDist2;
		float spillRadius1;
		float spillRadius2;
		unsigned long atkType1;	
		unsigned long atkType2;
		unsigned long weapType1;
		unsigned long weapType2;
		unsigned long weapTp1;
		unsigned long weapTp2;
		float rangeN1;
		float rangeN2;
		float RngBuff1;
		float RngBuff2;
		float cool1;
		float cool2;
		float dmgpt1;
		float dmgpt2;
		float backSw1;
		float backSw2;
		unsigned long splashTargs1;
		unsigned long splashTargs2;
		float Farea1;
		float Farea2;
		float Harea1;
		float Harea2;
		float Qarea1;
		float Qarea2;
		float Hfact1;
		float Hfact2;
		float Qfact1;
		float Qfact2;
		char unk2[0x10];
		unsigned long showUI1;
		unsigned long showUI2;
		unsigned long STR;
		unsigned long AGI;
		unsigned long INT;
		char unk3[0x04];
		float STRplus;
		float AGIplus;
		float INTplus;
		float sight;
		float nsight;
		float acquire;
		float minRange;
		float collision;
		float fogRad;
		char unk4[0x04];
		unsigned long movetp;
		char unk5[0x08];
		unsigned long targType;
		unsigned long buffType;
		float buffRadius;
		char unk6[0x04];
		unsigned long deathType;
		char unk7[0x04];
		float prio;
		unsigned long points;
		float spd;
		float minSpd;
		float maxSpd;
		float turnRate;
		float propWin;
		unsigned long orientInterp;
		unsigned long formation;
		float occH;
		char unk8[0x04];
		float moveHeight;
		float moveFloor;
		float launchX;
		float launchY;
		float launchZ;
		float launchSwimZ;
		float impactZ;
		float impactSwimZ;
		float blend;
		float walk;
		float run;
		unsigned long repulse;
		unsigned long repulseParam;
		unsigned long repulseGroup;
		unsigned long repulsePrio;
		char unk9[0x58];
		unsigned long isbldg;
	};

	struct W3ABILITYINFO {
		char unk1[0x1C];
		unsigned long AbilityId;
		char unk2[0x08];
		char* Buffart;
		char* Bulletart;
		char* Effectsound;
		char* Effectsoundlooped;
		char* Unart;
		char* Researchart;
		char* Placementmodel;
		char* Placementtexture;
		char* Globalmessage;
		char* Globalsound;
		unsigned long ButtonposX;
		unsigned long ButtonposY;
		unsigned long UnbuttonposX;
		unsigned long UnbuttonposY;
		unsigned long ResearchbuttonposX;
		unsigned long ResearchbuttonposY;
		float Missilespeed;
		float Missilearc;
		unsigned long MissileHoming;
		unsigned long Spelldetail;
		void* Scriptname;
		unsigned long Hotkey_count;
		unsigned long Hotkey_exists;
		unsigned long* Hotkey;
		unsigned long Unhotkey_count;
		unsigned long Unhotkey_exists;
		unsigned long* Unhotkey;
		unsigned long Researchhotkey_count;
		unsigned long Researchhotkey_exists;
		unsigned long* Researchhotkey;
		unsigned long Name_count;
		unsigned long Name_exists;
		char** Name;
		unsigned long Art_count;
		unsigned long Art_exists;
		char** Art;
		unsigned long TargetArt_count;
		unsigned long TargetArt_exists;
		char** TargetArt;
		unsigned long CasterArt_count;
		unsigned long CasterArt_exists;
		char** CasterArt;
		unsigned long EffectArt_count;
		unsigned long EffectArt_exists;
		char** EffectArt;
		unsigned long Areaeffectart_count;
		unsigned long Areaeffectart_exists;
		char** Areaeffectart;
		unsigned long Missileart_count;
		unsigned long Missileart_exists;
		char** Missileart;
		unsigned long SpecialArt_count;
		unsigned long SpecialArt_exists;
		char** SpecialArt;
		unsigned long LightningEffect_count;
		unsigned long LightningEffect_exists;
		char** LightningEffect;
		unsigned long Bufftip_count;
		unsigned long Bufftip_exists;
		char** Bufftip;
		unsigned long Buffubertip_count;
		unsigned long Buffubertip_exists;
		char** Buffubertip;
		unsigned long Researchtip_count;
		unsigned long Researchtip_exists;
		char** Researchtip;
		unsigned long Tip_count;
		unsigned long Tip_exists;
		char** Tip;
		unsigned long Untip_count;
		unsigned long Untip_exists;
		char** Untip;
		unsigned long Researchubertip_count;
		unsigned long Researchubertip_exists;
		char** Researchubertip;
		unsigned long Ubertip_count;
		unsigned long Ubertip_exists;
		char** Ubertip;
		unsigned long Unubertip_count;
		unsigned long Unubertip_exists;
		char** Unubertip;
		char unk3[0x08];
		unsigned long* Animnames_count;
		char unk4[0xCC];
	};

	typedef void				(__cdecl *pAddNative)			(void *address, const char *name, const char *params);
	typedef long				(__cdecl *pStringMap)			(char *str);
	typedef const char*			(__cdecl *pStringGet)			(long str);
	typedef W3UNITINFO* 		(__cdecl *pGetUnitInfoStruct)	(long unit_rawcode);
	typedef W3ABILITYINFO* 		(__cdecl *pGetAbilityInfoStruct)(long ability_rawcode);
	extern pAddNative AddNative;
	extern pStringMap StringMap;
	extern pStringGet StringGet;
	extern pGetUnitInfoStruct GetUnitInfoStruct;
	extern pGetAbilityInfoStruct GetAbilityInfoStruct;
	
	
	typedef void (*HandleDestructor)(void*);
	
	typedef long 		(__cdecl *pAddRCHandle)					(void *input, long datatype);
	typedef void* 		(__cdecl *pGetRCHandle)					(long id, long datatype);
	typedef void* 		(__cdecl *pRecycleRCHandle)				(long id, long datatype);
	typedef long 		(__cdecl *pRegisterHandleDestructor)	(HandleDestructor destructor);
	extern pAddRCHandle AddRCHandle;
	extern pGetRCHandle GetRCHandle;
	extern pRecycleRCHandle RecycleRCHandle;
	extern pRegisterHandleDestructor RegisterHandleDestructor;
	
	typedef void 		(__cdecl *pGameDebugMessage)			(const char *str);
	extern pGameDebugMessage GameDebugMessage;
	
	struct MouseInfoStruct {
		float MouseX, MouseY, MouseZ;
		long IsOverUI;
		float MouseRelativeX, MouseRelativeY;
	};
	extern MouseInfoStruct *MouseInfo;
	
	
	typedef void* TriggerGroup;
	
	typedef TriggerGroup 	(__cdecl *pCreateTriggerGroup)();
	typedef void 			(__cdecl *pDestroyTriggerGroup)(TriggerGroup whichTG);
	typedef void 			(__cdecl *pTriggerGroupAdd)(TriggerGroup whichTG, Jass::trigger trigger);
	typedef void 			(__cdecl *pTriggerGroupRun)(TriggerGroup whichTG);
	extern pCreateTriggerGroup CreateTriggerGroup;
	extern pDestroyTriggerGroup DestroyTriggerGroup;
	extern pTriggerGroupAdd TriggerGroupAdd;
	extern pTriggerGroupRun TriggerGroupRun;
	
	typedef HWND 			(__cdecl *pGetWc3WindowHandle)();
	extern pGetWc3WindowHandle GetWc3WindowHandle;
	
	extern char *LastNativeName;
	
	long RealMap(float in);
	
}

bool InitJAPI(HMODULE m);
