#include <windows.h>
#include "nAPI.h"

Jass::integer __cdecl SimpleNative(Jass::integer n) {
	return n+7;
}

// Jass strings are passed as integer handles
long __cdecl StringNative(long jass_str) {
	// we need to convert jass_str, one of those handles, to something
	// we can use (char*), we do this by using StringGet
	const char *str = nAPI::StringGet(jass_str);
	char workstr[100];
	strcpy(workstr, str);
	strcat(workstr, ", but the cake is a lie!");
	// likewise, we need to make our string usable by Jass by converting it to a Jass handle using StringMap
	return nAPI::StringMap(workstr);
}

// Jass reals are passed as float pointers
long __cdecl RealNative(float *in) {
	float result = *in;
	result += 7.0;
	// we use RealMap when returing a real to Jass
	return nAPI::RealMap(result);
}

// callback for the when the map's main function is ran (AKA map init)
extern "C" void __cdecl MainFunction_proc() {
	MessageBox(0, "main function called", "Game event", 0);
}

// callback for when the map starts
extern "C" void __cdecl MapStart_proc() {
	MessageBox(0, "Map started", "Game event", 0);
}

// callback for when the map ends
extern "C" void __cdecl MapEnd_proc() {
	MessageBox(0, "Map ended", "Game event", 0);
}

// callback for when the game quits
extern "C" void __cdecl GameQuit_proc() {
	MessageBox(0, "Game quit", "Game event", 0);
}

// WND procedure callback
// see http://msdn.microsoft.com/en-us/library/ms633573.aspx for more info
// return value 0 means the message is blocked, anything else means it's passed to the game
extern "C" long __cdecl GameWNDParse_proc(unsigned long uMsg, unsigned long wParam, unsigned long lParam) {
	// this prevents the game from registering when the mouse wheel moves
	if (uMsg == WM_MOUSEWHEEL) return 0;
}

extern "C" long __cdecl LoadNativePack(HMODULE m) {
	if (!InitJAPI(m)) {
		MessageBox(0, "ERROR", "ERROR", 0);
		return false;
	}
	// adding natives
	nAPI::AddNative((void*)SimpleNative, 	"SimpleNative", "(I)I");
	nAPI::AddNative((void*)StringNative, 	"StringNative", "(S)S");
	nAPI::AddNative((void*)RealNative, 		"RealNative", 	"(R)R");
	return true;
}

// unused
extern "C" BOOL __stdcall DllMain(HINSTANCE module,DWORD reason, LPVOID reserved) {
	return true;
}
