//===========================================================================
// 
// Gravity Hook 2.0.0
// 
//   Warcraft III map script
//   Generated by the Warcraft III World Editor
//   Date: Fri Oct 30 17:05:38 2009
//   Map Author: Deaod
// 
//===========================================================================

//***************************************************************************
//*
//*  Global Variables
//*
//***************************************************************************

globals
    // Generated
    trigger                 gg_trg_Untitled_Trigger_001 = null
    trigger                 gg_trg_ARGB                = null
    trigger                 gg_trg_GetPlayerColored    = null
    trigger                 gg_trg_SimError            = null
    trigger                 gg_trg_Table               = null
    trigger                 gg_trg_TimedEventEx        = null
    trigger                 gg_trg_TimerUtils          = null
    trigger                 gg_trg_xebasic             = null
    trigger                 gg_trg_xefx                = null
    trigger                 gg_trg_FadingText          = null
    trigger                 gg_trg_FoodLib             = null
    trigger                 gg_trg_Game                = null
    trigger                 gg_trg_OnChat              = null
    trigger                 gg_trg_PlayerCam           = null
    trigger                 gg_trg_Typecasting         = null
    trigger                 gg_trg_RtCChat             = null
    trigger                 gg_trg_RtCDisplay          = null
    trigger                 gg_trg_RtCExternalIP       = null
    trigger                 gg_trg_RtCLobby            = null
    trigger                 gg_trg_RtCVector           = null
    trigger                 gg_trg_Init                = null
    trigger                 gg_trg_WarSocBuffer        = null
    trigger                 gg_trg_WarSocCore          = null
    trigger                 gg_trg_WarSocErrors        = null
    trigger                 gg_trg_WarSocFunctions     = null
    trigger                 gg_trg_WarSocMessages      = null
    trigger                 gg_trg_WarSocPlayers       = null
endglobals

function InitGlobals takes nothing returns nothing
endfunction

//***************************************************************************
//*
//*  Custom Script Code
//*
//***************************************************************************
//TESH.scrollpos=-1
//TESH.alwaysfold=0

//***************************************************************************
//*
//*  Triggers
//*
//***************************************************************************

//===========================================================================
// Trigger: Untitled Trigger 001
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library RtCNatives

    globals
        constant integer EVENT_LMOUSEUP = 0
        constant integer EVENT_LMOUSEDOWN = 1
        constant integer EVENT_RMOUSEUP = 2
        constant integer EVENT_RMOUSEDOWN = 3
        constant integer EVENT_MMOUSEUP = 4
        constant integer EVENT_MMOUSEDOWN = 5
        constant integer EVENT_MOUSEWHEEL = 6
    endglobals
    
    native StringPos			takes string input, string lookup								returns integer
    native StringReplace        takes string input, string oldstr, string newstr                returns string

    //native IsWindowInFocus 		takes nothing 													returns integer
    native Char			        takes integer i            									    returns string
    //native Log                  takes real r                                                    returns real
    //native Ln                   takes real r                                                    returns real

    //native BitAnd               takes integer a, integer b                                      returns integer
    //native BitOr                takes integer a, integer b                                      returns integer
    //native BitXor               takes integer a, integer b                                      returns integer
    //native BitBSL               takes integer val, integer shift                                returns integer
    //native BitBSR               takes integer val, integer shift                                returns integer
    //native BitFlip              takes integer val                                               returns integer

    //native GetTimestamp         takes nothing                               					returns integer
    native GetTimeSeconds       takes nothing                               					returns integer
    native GetTimeMinutes       takes nothing                               					returns integer
    native GetTimeHours         takes nothing                               					returns integer
    
    native TriggerRegisterMouseEvent takes trigger whichTrigger, integer eventtype 				returns nothing
    native GetMouseTargetX      takes nothing                                                   returns real
    native GetMouseTargetY      takes nothing                                                   returns real
    

    native GetTriggerParam_Integer takes integer id 											returns integer
    

    native SocTCPConnect		takes string ip, integer port, integer mode						returns integer
    native SocTCPListen			takes integer port, integer maxqueue, integer mode 				returns integer
    native SocTCPAccept			takes integer socket, integer mode								returns integer
    native SocTCPIP				takes integer socket											returns string
    native SocSetNagle			takes integer socket, boolean on								returns integer
    native SocTCPConnected		takes integer socket											returns boolean
    //native SocUDPConnect		takes integer port, integer mode								returns integer
    //native SocSendUDPMessage 	takes integer udpsocket, string ip, integer port, integer buffer returns integer
    native SocSendTCPMessage 	takes integer tcpsocket, integer buffer 						returns integer
    native SocReceiveMessage 	takes integer socket, integer length, integer buffer 			returns integer
    //native SocPeekMessage		takes integer socket, integer length, integer buffer 			returns integer
    native SocSetFormat			takes integer socket, integer mode, string delimiter			returns integer
    //native SocGetLastInIP		takes nothing													returns string
    //native SocGetLastInPort		takes nothing													returns integer
    //native SocSetSync			takes integer socket, integer mode								returns integer
    native SocCloseSocket		takes integer socket											returns boolean
    //native SocGetSocketLastError takes integer socket											returns integer
    //native SocGetMyHost			takes nothing													returns string
    //native SocCompareIp			takes string ip, string mask									returns boolean
    //native SocExit				takes nothing													returns boolean
    //native SocStart				takes nothing													returns boolean
    //native SocNetConnected		takes nothing													returns boolean

    native BufferWriteByte takes integer val, integer buffer									returns integer
    native BufferWriteShort takes integer val, integer buffer									returns integer
    native BufferWriteUShort takes integer val, integer buffer									returns integer
    native BufferWriteInt takes integer val, integer buffer										returns integer
    native BufferWriteUInt takes integer val, integer buffer									returns integer
    native BufferWriteFloat takes real val, integer buffer										returns integer
    native BufferWriteString takes string str, integer buffer									returns integer
    native BufferWriteChars takes string str, integer buffer									returns integer
    native BufferWriteOrderID takes integer val, integer buffer									returns integer
    native BufferReadByte takes integer buffer													returns integer
    native BufferReadShort takes integer buffer													returns integer
    native BufferReadUShort takes integer buffer												returns integer
    native BufferReadInt takes integer buffer													returns integer
    native BufferReadUInt takes integer buffer													returns integer
    native BufferReadFloat takes integer buffer													returns real
    native BufferReadString takes integer buffer												returns string
    native BufferReadChars takes integer buffer, integer length								    returns string
    native BufferReadOrderID takes integer buffer												returns integer
    native CreateBuffer	takes nothing															returns integer
    native DestroyBuffer takes integer buffer													returns nothing
    native BufferCopy	takes integer bufferdestination, integer buffersource					returns integer
    native BufferClear	takes integer buffer													returns boolean
    native BufferSize 	takes integer buffer													returns integer
    native BufferBytesLeft 	takes integer buffer												returns integer

    native CreateVector        	takes integer size                         						returns integer
    native DestroyVector       	takes integer id                             					returns nothing
    native VectorClear         	takes integer id                             					returns nothing
    native GetVectorSize       	takes integer id	                           					returns integer
    native SetVectorSize        takes integer id, integer newsize          						returns nothing
    native VectorGet           	takes integer id, integer index            						returns integer
    native VectorSet           	takes integer id, integer index, integer value					returns nothing
    native VectorPushBack		takes integer id, integer value            						returns integer
    native VectorPopBack		takes integer id            									returns nothing
    native VectorBack			takes integer id            									returns integer
    native VectorEmpty			takes integer id            									returns boolean

    //native CreateI64 	        takes integer baseHigh, integer baseLow                         returns integer
    //native DestroyI64 	        takes integer id	 		                                    returns nothing
    //native AddIntToI64 	        takes integer id, integer addme 	                            returns nothing
    //native SubIntFromI64 	    takes integer id, integer subme 	                            returns nothing
    //native AddI64ToI64 	        takes integer id, integer addid 	                            returns nothing
    //native SubI64FromI64 	    takes integer id, integer subid 	                            returns nothing
    //native MulI64 		        takes integer id, integer mul	 	                            returns nothing
    //native DivI64 		        takes integer id, integer div	 	                            returns nothing
    //native I64AsString	        takes integer id		 	                                    returns string
    //native I64AsIntHigh 	    takes integer id 			                                    returns integer
    //native I64AsIntLow 	        takes integer id 			                                    returns integer
    //native I64Compare 	        takes integer id1, integer id2		                            returns integer

    //native TriggerRegisterTooltipEvent takes trigger t                                          returns nothing
    //native TriggerReturnString  takes string s                                                  returns nothing
    //native GetTriggeringRawcode takes nothing                                                   returns integer
    //native GetTriggeringLevel   takes nothing                                                   returns integer

    //native CreateTriggerGroup   takes nothing                                                   returns integer
    //native DestroyTriggerGroup  takes integer triggergroup                                      returns nothing
    //native TriggerGroupAdd      takes integer triggergroup, trigger t                           returns boolean
    //native TriggerGroupRun      takes integer triggergroup                                      returns nothing
    
endlibrary//===========================================================================
// Trigger: ARGB
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library ARGB initializer init
//******************************************************************************
//*
//* ARGB 1.1
//* ====
//*  For your color needs.
//*  
//*  An ARGB object is a by-value struct, this means that assigning copies the
//* contents of the struct and that you don't have to use .destroy(), the
//* downside is that you cannot assign its members (can't do set c.r= 123 )
//*
//*  This library should have plenty of uses, for example, if your spell involves
//* some unit recoloring you can allow users to input the color in the config
//* section as 0xAARRGGBB and you can then use this to decode that stuff.
//*
//* You can also easily merge two colors and make fading effects using ARGB.mix
//*
//* There's ARGB.fromPlayer which gets an ARGB object containing the player's
//* color. Then you can use the previous utilities on it.
//*
//* The .str() instance method can recolor a string, and the recolorUnit method
//* will apply the ARGB on a unit
//*
//* For other uses, you can use the .red, .green, .blue and .alpha members to get
//* an ARGB object's color value (from 0 to 255).
//*
//* structs that have a recolor method that takes red,green,blue and alpha as 0.255
//* integers can implement the ARGBrecolor module to gain an ability to quickly
//* recolor using an ARGB object.
//*
//********************************************************************************

//=================================================================================
globals
    private string array i2cc
endglobals

//this double naming stuff is beginning to make me insane, if only TriggerEvaluate() wasn't so slow...
struct ARGB extends array
    static method create takes integer a, integer r, integer g, integer b returns ARGB
        return ARGB(b + g*0x100 + r*0x10000 + a*0x1000000)
    endmethod

    static method fromPlayer takes player p returns ARGB
     local playercolor pc=GetPlayerColor(p)
        if(pc==PLAYER_COLOR_RED) then
            return 0xFFFF0303
        elseif(pc==PLAYER_COLOR_BLUE) then
            return 0x000042FF
        elseif(pc==PLAYER_COLOR_CYAN) then
            return 0xFF1CB619
        elseif(pc==PLAYER_COLOR_PURPLE) then
            return 0xFF540081
        elseif(pc==PLAYER_COLOR_YELLOW) then
            return 0xFFFFFF01
        elseif(pc==PLAYER_COLOR_ORANGE) then
            return 0xFFFE8A0E
        elseif(pc==PLAYER_COLOR_GREEN) then
            return 0xFF20C000
        elseif(pc==PLAYER_COLOR_PINK) then
            return 0xFFE55BB0
        elseif(pc==PLAYER_COLOR_LIGHT_GRAY) then
            return 0xFF959697
        elseif(pc==PLAYER_COLOR_LIGHT_BLUE) then
            return 0xFF7EBFF1
        elseif(pc==PLAYER_COLOR_AQUA) then
            return 0xFF106246
        elseif(pc==PLAYER_COLOR_BROWN) then
            return 0xFF4E2A04
        endif
        
      return 0xFF111111
    endmethod

    method operator alpha takes nothing returns integer
        if( integer(this) <0) then
            return 0x80+(-(-integer(this)+0x80000000))/0x1000000
        else
            return (integer(this))/0x1000000
        endif
    endmethod
    method operator alpha= takes integer na returns ARGB
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       return ARGB(b + g*0x100 + r*0x10000 + na*0x1000000) 
    endmethod




    method operator red takes nothing returns integer
     local integer c=integer(this)*0x100
        if(c<0) then
            return 0x80+(-(-c+0x80000000))/0x1000000
        else
            return c/0x1000000
        endif
    endmethod
    method operator red= takes integer nr returns ARGB
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       return ARGB(b + g*0x100 + nr*0x10000 + a*0x1000000) 
    endmethod

    method operator green takes nothing returns integer
     local integer c=integer(this)*0x10000
        if(c<0) then
            return 0x80+(-(-c+0x80000000))/0x1000000
        else
            return c/0x1000000
        endif
    endmethod
    method operator green= takes integer ng returns ARGB
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       return ARGB(b + ng*0x100 + r*0x10000 + a*0x1000000) 
    endmethod

    //=======================================================
    //
    //
    method operator blue takes nothing returns integer
     local integer c=integer(this)*0x1000000
        if(c<0) then
            return 0x80+(-(-c+0x80000000))/0x1000000
        else
            return c/0x1000000
        endif
    endmethod
    method operator blue= takes integer nb returns ARGB
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       return ARGB(nb + g*0x100 + r*0x10000 + a*0x1000000) 
    endmethod

    //====================================================================
    // Mixes two colors, s would be a number 0<=s<=1 that determines
    // the weight given to color c2.
    //
    //  mix(c1,c2,0)   = c1
    //  mix(c1,c2,1)   = c2
    //  mix(c1,c2,0.5) = Mixing the colors c1 and c2 in equal proportions.
    //
    static method mix takes ARGB c1, ARGB c2, real s returns ARGB
      //widest function ever
      return ARGB( R2I(c2.blue*s+c1.blue*(1-s)+0.5) + R2I(c2.green*s+c1.green*(1-s)+0.5)*0x100 + R2I(c2.red*s+c1.red*(1-s)+0.5)*0x10000 + R2I(c2.alpha*s+c1.alpha*(1-s)+0.5)*0x1000000)
    endmethod

    method str takes string s returns string
       return "|c"+i2cc[.alpha]+i2cc[.red]+i2cc[.green]+i2cc[.blue]+s+"|r"
    endmethod

    method recolorUnit takes unit u returns nothing
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       call SetUnitVertexColor(u,r,g,b,a)
    endmethod

endstruct

module ARGBrecolor
    method ARGBrecolor takes ARGB color returns nothing
     local integer a
     local integer r
     local integer g
     local integer b
     local integer col=integer(this)

       if (col<0) then
           set col=-(-col+0x80000000)
           set a=0x80+col/0x1000000
           set col=col-(a-0x80)*0x1000000
       else
           set a=col/0x1000000
           set col=col-a*0x1000000
       endif
       set r=col/0x10000
       set col=col-r*0x10000
       set g=col/0x100
       set b=col-g*0x100
       
       call this.recolor(r, g , b, a)
    endmethod

endmodule

private function init takes nothing returns nothing
 local integer i=0

    // Don't run textmacros you don't own!
//textmacro instance: ARGB_CHAR( "0","0")
        set i=0
        loop
            exitwhen i==16
            set i2cc[0*16+i]="0"+i2cc[0*16+i]
            set i2cc[i*16+0]=i2cc[i*16+0]+"0"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "0","0")
//textmacro instance: ARGB_CHAR( "1","1")
        set i=0
        loop
            exitwhen i==16
            set i2cc[1*16+i]="1"+i2cc[1*16+i]
            set i2cc[i*16+1]=i2cc[i*16+1]+"1"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "1","1")
//textmacro instance: ARGB_CHAR( "2","2")
        set i=0
        loop
            exitwhen i==16
            set i2cc[2*16+i]="2"+i2cc[2*16+i]
            set i2cc[i*16+2]=i2cc[i*16+2]+"2"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "2","2")
//textmacro instance: ARGB_CHAR( "3","3")
        set i=0
        loop
            exitwhen i==16
            set i2cc[3*16+i]="3"+i2cc[3*16+i]
            set i2cc[i*16+3]=i2cc[i*16+3]+"3"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "3","3")
//textmacro instance: ARGB_CHAR( "4","4")
        set i=0
        loop
            exitwhen i==16
            set i2cc[4*16+i]="4"+i2cc[4*16+i]
            set i2cc[i*16+4]=i2cc[i*16+4]+"4"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "4","4")
//textmacro instance: ARGB_CHAR( "5","5")
        set i=0
        loop
            exitwhen i==16
            set i2cc[5*16+i]="5"+i2cc[5*16+i]
            set i2cc[i*16+5]=i2cc[i*16+5]+"5"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "5","5")
//textmacro instance: ARGB_CHAR( "6","6")
        set i=0
        loop
            exitwhen i==16
            set i2cc[6*16+i]="6"+i2cc[6*16+i]
            set i2cc[i*16+6]=i2cc[i*16+6]+"6"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "6","6")
//textmacro instance: ARGB_CHAR( "7","7")
        set i=0
        loop
            exitwhen i==16
            set i2cc[7*16+i]="7"+i2cc[7*16+i]
            set i2cc[i*16+7]=i2cc[i*16+7]+"7"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "7","7")
//textmacro instance: ARGB_CHAR( "8","8")
        set i=0
        loop
            exitwhen i==16
            set i2cc[8*16+i]="8"+i2cc[8*16+i]
            set i2cc[i*16+8]=i2cc[i*16+8]+"8"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "8","8")
//textmacro instance: ARGB_CHAR( "9","9")
        set i=0
        loop
            exitwhen i==16
            set i2cc[9*16+i]="9"+i2cc[9*16+i]
            set i2cc[i*16+9]=i2cc[i*16+9]+"9"
            set i=i+1
        endloop
//end of: ARGB_CHAR( "9","9")
//textmacro instance: ARGB_CHAR("10","A")
        set i=0
        loop
            exitwhen i==16
            set i2cc[10*16+i]="A"+i2cc[10*16+i]
            set i2cc[i*16+10]=i2cc[i*16+10]+"A"
            set i=i+1
        endloop
//end of: ARGB_CHAR("10","A")
//textmacro instance: ARGB_CHAR("11","B")
        set i=0
        loop
            exitwhen i==16
            set i2cc[11*16+i]="B"+i2cc[11*16+i]
            set i2cc[i*16+11]=i2cc[i*16+11]+"B"
            set i=i+1
        endloop
//end of: ARGB_CHAR("11","B")
//textmacro instance: ARGB_CHAR("12","C")
        set i=0
        loop
            exitwhen i==16
            set i2cc[12*16+i]="C"+i2cc[12*16+i]
            set i2cc[i*16+12]=i2cc[i*16+12]+"C"
            set i=i+1
        endloop
//end of: ARGB_CHAR("12","C")
//textmacro instance: ARGB_CHAR("13","D")
        set i=0
        loop
            exitwhen i==16
            set i2cc[13*16+i]="D"+i2cc[13*16+i]
            set i2cc[i*16+13]=i2cc[i*16+13]+"D"
            set i=i+1
        endloop
//end of: ARGB_CHAR("13","D")
//textmacro instance: ARGB_CHAR("14","E")
        set i=0
        loop
            exitwhen i==16
            set i2cc[14*16+i]="E"+i2cc[14*16+i]
            set i2cc[i*16+14]=i2cc[i*16+14]+"E"
            set i=i+1
        endloop
//end of: ARGB_CHAR("14","E")
//textmacro instance: ARGB_CHAR("15","F")
        set i=0
        loop
            exitwhen i==16
            set i2cc[15*16+i]="F"+i2cc[15*16+i]
            set i2cc[i*16+15]=i2cc[i*16+15]+"F"
            set i=i+1
        endloop
//end of: ARGB_CHAR("15","F")
endfunction

endlibrary

//===========================================================================
// Trigger: GetPlayerColored
//
// by Ammorth
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library GetPlayerColored initializer init uses Typecasting
// GetPlayerColored by Ammorth
// v1.1
// functions should be self-explanatory

globals
    private string array PlayerColor
    private integer array redhex
    private integer array greenhex
    private integer array bluehex
endglobals

function GetPlayerColorID takes player p returns integer
    return H2I(GetPlayerColor(p))
endfunction

function GetPlayerNameColored takes player p returns string // colored player name
    return PlayerColor[GetPlayerColorID(p)]+GetPlayerName(p)+"|r"
endfunction

function GetPlayerTextColor takes player p returns string // only textcode
    return PlayerColor[GetPlayerColorID(p)]
endfunction

function GetPlayerRedHex takes player p returns integer // integer value for red
    return redhex[GetPlayerColorID(p)]
endfunction

function GetPlayerGreenHex takes player p returns integer // integer value for green
    return greenhex[GetPlayerColorID(p)]
endfunction

function GetPlayerBlueHex takes player p returns integer // integer value for blue
    return bluehex[GetPlayerColorID(p)]
endfunction

private function init takes nothing returns nothing
    set PlayerColor[0] = "|CFFFF0303" // red
    set PlayerColor[1] = "|CFF0042FF" // blue
    set PlayerColor[2] = "|CFF1CE6B9" // teal
    set PlayerColor[3] = "|CFF540081" // purple
    set PlayerColor[4] = "|CFFFFFF01" // yellow
    set PlayerColor[5] = "|CFFFE8A0E" // orange
    set PlayerColor[6] = "|CFF20C000" // green
    set PlayerColor[7] = "|CFFE55BB0" // pink
    set PlayerColor[8] = "|CFF959697" // grey
    set PlayerColor[9] = "|CFF7EBFF1" // light blue
    set PlayerColor[10] = "|CFF106246" // dark green
    set PlayerColor[11] = "|CFF4E2A04" // brown
    set redhex[0] = 255
    set redhex[1] = 0
    set redhex[2] = 28
    set redhex[3] = 84
    set redhex[4] = 255
    set redhex[5] = 254
    set redhex[6] = 32
    set redhex[7] = 229
    set redhex[8] = 149
    set redhex[9] = 126
    set redhex[10] = 16
    set redhex[11] = 78
    set greenhex[0] = 3
    set greenhex[1] = 66
    set greenhex[2] = 230
    set greenhex[3] = 0
    set greenhex[4] = 255
    set greenhex[5] = 138
    set greenhex[6] = 192
    set greenhex[7] = 91
    set greenhex[8] = 150
    set greenhex[9] = 191
    set greenhex[10] = 98
    set greenhex[11] = 42
    set bluehex[0] = 3
    set bluehex[1] = 255
    set bluehex[2] = 185
    set bluehex[3] = 129
    set bluehex[4] = 1
    set bluehex[5] = 14
    set bluehex[6] = 0
    set bluehex[7] = 176
    set bluehex[8] = 151
    set bluehex[9] = 241
    set bluehex[10] = 70
    set bluehex[11] = 4
endfunction

endlibrary//===========================================================================
// Trigger: SimError
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library SimError initializer init
//**************************************************************************************************
//*
//*  SimError
//*
//*     Mimic an interface error message
//*       call SimError(ForPlayer, msg)
//*         ForPlayer : The player to show the error
//*         msg       : The error
//*    
//*     To implement this function, copy this trigger and paste it in your map.
//* Unless of course you are actually reading the library from wc3c's scripts section, then just
//* paste the contents into some custom text trigger in your map.
//*
//**************************************************************************************************

//==================================================================================================
    globals
        private sound error
    endglobals
    //====================================================================================================

    function SimError takes player ForPlayer, string msg, boolean DoSound returns nothing
        set msg="\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n|cffffcc00"+msg+"|r"
        if (GetLocalPlayer() == ForPlayer) then
            call ClearTextMessages()
            call DisplayTimedTextToPlayer( ForPlayer, 0.52, 0.96, 2.00, msg )
            if DoSound then
                call StartSound( error )
            endif
        endif
    endfunction

    private function init takes nothing returns nothing
         set error=CreateSoundFromLabel("InterfaceError",false,false,false,10,10)
         //call StartSound( error ) //apparently the bug in which you play a sound for the first time
                                    //and it doesn't work is not there anymore in patch 1.22
    endfunction

endlibrary
//===========================================================================
// Trigger: Table
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library Table
//***************************************************************
//* Table object 2.0
//* ------------
//*
//*   set t=Table.create() - instanceates a new table object
//*   call t.destroy()     - destroys it
//*   t[1234567]           - Get value for key 1234567
//*                          (zero if not assigned previously)
//*   set t[12341]=32      - Assigning it.
//*   call t.flush(12341)  - Flushes the stored value, so it
//*                          doesn't use any more memory
//*   t.exists(32)         - Was key 32 assigned? Notice
//*                          that flush() unassigns values.
//*   call t.reset()       - Flushes the whole contents of the
//*                          Table.
//*
//*   call t.destroy()     - Does reset() and also recycles the id.
//*
//*   If you use HandleTable instead of Table, it is the same
//* but it uses handles as keys, the same with StringTable.
//*
//*  You can use Table on structs' onInit  if the struct is
//* placed in a library that requires Table or outside a library.
//*
//*  You can also do 2D array syntax if you want to touch
//* mission keys directly, however, since this is shared space
//* you may want to prefix your mission keys accordingly:
//*
//*  set Table["thisstring"][ 7 ] = 2
//*  set Table["thisstring"][ 5 ] = Table["thisstring"][7]
//*
//***************************************************************

//=============================================================
    globals
        private constant integer MAX_INSTANCES=8100 //400000

    //=========================================================
        private gamecache gc
    endglobals

    private keyword hack

    private struct GTable[MAX_INSTANCES]
        readonly string sthis

        static method create takes nothing returns GTable
         local GTable this = GTable.allocate()
             set this.sthis = SCOPE_PRIVATE + I2S(this)
         return this
        endmethod

        method reset takes nothing returns nothing
            call FlushStoredMission(gc,  this.sthis  )
        endmethod

        private method onDestroy takes nothing returns nothing
            call FlushStoredMission(gc,  this.sthis  )
        endmethod

        static method hack takes string s returns nothing
             set GTable(0).sthis  = s
        endmethod

        //=============================================================
        // initialize it all.
        //
        private static method onInit takes nothing returns nothing
            call FlushGameCache(InitGameCache("libtable.gc"))
            set gc=InitGameCache("libtable.gc")
        endmethod

    endstruct

    //Hey: Don't instanciate other people's textmacros that you are not supposed to, thanks.

    private function H2I takes handle h returns integer
        return h
        return 0
    endfunction
    
//textmacro instance: Table__make("Table","integer","I2S(key)" )
    struct Table extends GTable

        method operator [] takes integer key returns integer
            return GetStoredInteger(gc,  this.sthis  ,I2S(key))
        endmethod

        method operator []= takes integer key, integer value returns nothing
            call StoreInteger(gc,  this.sthis  ,I2S(key), value)
        endmethod

        method flush takes integer key returns nothing
            call FlushStoredInteger(gc,  this.sthis  ,I2S(key))
        endmethod

        method exists takes integer key returns boolean
            return HaveStoredInteger(gc,  this.sthis  ,I2S(key))
        endmethod

        static method flush2D takes string firstkey returns nothing
            call GTable.hack(firstkey) //inline friendly, I hope
            call Table(0).reset()
        endmethod

        static method operator [] takes string firstkey returns Table
            call GTable.hack(firstkey) //inline friendly, I hope
            return Table(0)
        endmethod

    endstruct
//end of: Table__make("Table","integer","I2S(key)" )
//textmacro instance: Table__make("StringTable","string","key" )
    struct StringTable extends GTable

        method operator [] takes string key returns integer
            return GetStoredInteger(gc,  this.sthis  ,key)
        endmethod

        method operator []= takes string key, integer value returns nothing
            call StoreInteger(gc,  this.sthis  ,key, value)
        endmethod

        method flush takes string key returns nothing
            call FlushStoredInteger(gc,  this.sthis  ,key)
        endmethod

        method exists takes string key returns boolean
            return HaveStoredInteger(gc,  this.sthis  ,key)
        endmethod

        static method flush2D takes string firstkey returns nothing
            call GTable.hack(firstkey) //inline friendly, I hope
            call StringTable(0).reset()
        endmethod

        static method operator [] takes string firstkey returns StringTable
            call GTable.hack(firstkey) //inline friendly, I hope
            return StringTable(0)
        endmethod

    endstruct
//end of: Table__make("StringTable","string","key" )
//textmacro instance: Table__make("HandleTable","handle","I2S(H2I(key))" )
    struct HandleTable extends GTable

        method operator [] takes handle key returns integer
            return GetStoredInteger(gc,  this.sthis  ,I2S(H2I(key)))
        endmethod

        method operator []= takes handle key, integer value returns nothing
            call StoreInteger(gc,  this.sthis  ,I2S(H2I(key)), value)
        endmethod

        method flush takes handle key returns nothing
            call FlushStoredInteger(gc,  this.sthis  ,I2S(H2I(key)))
        endmethod

        method exists takes handle key returns boolean
            return HaveStoredInteger(gc,  this.sthis  ,I2S(H2I(key)))
        endmethod

        static method flush2D takes string firstkey returns nothing
            call GTable.hack(firstkey) //inline friendly, I hope
            call HandleTable(0).reset()
        endmethod

        static method operator [] takes string firstkey returns HandleTable
            call GTable.hack(firstkey) //inline friendly, I hope
            return HandleTable(0)
        endmethod

    endstruct
//end of: Table__make("HandleTable","handle","I2S(H2I(key))" )

endlibrary
//===========================================================================
// Trigger: TimedEventEx
//
// by MindWorX
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library TimedEventEx initializer Init uses Typecasting
    //==============================
    // This is a new version of TimedEvent by grim001 that instead of returning a boolean to
    // repeat or not repeat, you return a real that indicates how long till next callback run.
    // Returning a negative value will stop the timer.
    // Another change is that the callback will pass the last timeout aswell as the tag.
    //==============================
    
    globals
        //***   Configuration   ***
            private integer NumberOfTimers = 256
        //*** End Configuration ***
        
        private integer array I
        private real array D
        private CallbackEx array C
        private timer array T
        private integer N = 0
    endglobals

    //===========================================================================
    function interface CallbackEx takes integer tag, real timeout returns real

    //===========================================================================
    private function TimedEventExpires takes nothing returns nothing
     local timer t = GetExpiredTimer()
     local integer i = H2I(t)-0x100000
     local real delay = C[i].evaluate(I[i],D[i])
        if (delay < 0.00) then
            call PauseTimer(t)
            set N = N + 1
            set T[N] = t
        else
            set D[i] = delay
            call TimerStart(t, delay, false, function TimedEventExpires)
        endif
    endfunction

    //===========================================================================
    function TimedEventEx takes real delay, integer tag, CallbackEx callback returns timer
     local timer t
     local integer i
        if (N <= 0) then
            call BJDebugMsg("TimedEvent Error: Maximum numbers of timers ("+I2S(NumberOfTimers)+") exceeded")
            return null
        else
            set t = T[N]
            set N = N-1
        endif
        set i = H2I(t)-0x100000
        set I[i] = tag
        set C[i] = callback
        set D[i] = delay
        call TimerStart(t, delay, false, function TimedEventExpires)
         return t
    endfunction

    //===========================================================================
    private function Init takes nothing returns nothing
        loop
            exitwhen (N == NumberOfTimers)
            set T[N] = CreateTimer()
            set N = N + 1
        endloop
        set N=N-1
    endfunction
endlibrary
//===========================================================================
// Trigger: TimerUtils
//
// by Vexorian
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library_once TimerUtils initializer redInit uses Typecasting
//*********************************************************************
//* TimerUtils (Red flavor)
//* ----------
//*
//*  To implement it , create a custom text trigger called TimerUtils
//* and paste the contents of this script there.
//*
//*  To copy from a map to another, copy the trigger holding this
//* library to your map.
//*
//* (requires vJass)   More scripts: htt://www.wc3campaigns.net
//*
//* For your timer needs:
//*  * Attaching
//*  * Recycling (with double-free protection)
//*
//* set t=NewTimer()      : Get a timer (alternative to CreateTimer)
//* ReleaseTimer(t)       : Relese a timer (alt to DestroyTimer)
//* SetTimerData(t,2)     : Attach value 2 to timer
//* GetTimerData(t)       : Get the timer's value.
//*                         You can assume a timer's value is 0
//*                         after NewTimer.
//*
//* Red flavor: Fastest, method in existence for timer attaching,
//*             only takes an array lookup, H2I and subtraction. 
//*             However, all the code in your map requires extra care
//*             not to forget to call ReleaseTimer. It also requires
//*             to preload a lot of timers at map init, they use
//*             memory and handle ids.
//*
//*             I recommend you run your map in debug mode the first
//* time after adding it, make sure you can see map init messages
//* if nothing appears, all is done, if an error appears, it might
//* suggest you a value with OFFSET, in that case, update that value
//* if it still does not work after updating (rare), try a bigger
//* OFFSET by 1000 for example. (Sounds hard? Then use blue or purple
//* timerutils that are friendlier though not as fast)
//*
//********************************************************************

//================================================================
    globals
        private constant integer OFFSET     = 0x100000
        private constant integer QUANTITY   = 256
        private constant integer ARRAY_SIZE = 8191 //changing this to a higher value would effectively
                                                   //cripple the performance making this thing irrelevant

    endglobals

    //==================================================================================================
    globals
        private integer array data[ARRAY_SIZE]
    endglobals

    //It is dependent on jasshelper's recent inlining optimization in order to perform correctly.
    function SetTimerData takes timer t, integer value returns nothing
        debug if(H2I(t)-OFFSET<0) then
        debug     call BJDebugMsg("SetTimerData: Wrong handle id, only use SetTimerData on timers created by NewTimer")
        debug endif
        set data[H2I(t)-OFFSET]=value
    endfunction

    function GetTimerData takes timer t returns integer
        debug if(H2I(t)-OFFSET<0) then
        debug     call BJDebugMsg("GetTimerData: Wrong handle id, only use GetTimerData on timers created by NewTimer")
        debug endif

        return data[H2I(t)-OFFSET]
    endfunction

    //==========================================================================================
    globals
        private timer array tT
        private integer tN = 0
        private constant integer HELD=0x28829022
        //use a totally random number here, the more improbable someone uses it, the better.
    endglobals

    //==========================================================================================
    function NewTimer takes nothing returns timer
        if (tN==0) then
            //If this happens then the QUANTITY rule has already been broken, try to fix the
            // issue, else fail.
            debug call BJDebugMsg("NewTimer: Warning, Exceeding TimerUtils_QUANTITY, please increase it for your map, fix your map's timer leaks or switch to blue flavor when applicable")
            set tT[0]=CreateTimer()
            if (H2I(tT[0])-OFFSET<0) or (H2I(tT[0])-OFFSET>=ARRAY_SIZE) then
                //all right, couldn't fix it
                debug call BJDebugMsg("NewTimer: Unable to allocate a timer, you should probably switch to the blue flavor or fix timer leaks.")
                return null
            endif
        else
            set tN=tN-1
        endif
        call SetTimerData(tT[tN],0)
     return tT[tN]
    endfunction

    //==========================================================================================
    function ReleaseTimer takes timer t returns nothing
        if(t==null) then
            debug call BJDebugMsg("Warning: attempt to release a null timer")
            return
        endif
        if (tN==8191) then
            debug call BJDebugMsg("Warning: Timer stack is full, destroying timer!!")

            //stack is full, the map already has much more troubles than the chance of bug
            call DestroyTimer(t)
        else
            call PauseTimer(t)
            if(GetTimerData(t)==HELD) then
                debug call BJDebugMsg("Warning: ReleaseTimer: Double free!")
                return
            endif
            call SetTimerData(t,HELD)
            set tT[tN]=t
            set tN=tN+1
        endif    
    endfunction

    private function redInit takes nothing returns nothing
     local integer i=0
     local integer bestoffset=-1

        loop
            exitwhen (i==QUANTITY)
            set tT[i] = CreateTimer()
            if(i==0) then
                set bestoffset=H2I(tT[i])
            endif
            if (H2I(tT[i])-OFFSET>=ARRAY_SIZE) then
                debug call BJDebugMsg("TimerUtils_redInit: Failed a initializing attempt")
                debug call BJDebugMsg("The timer limit is "+I2S(i))
                debug call BJDebugMsg("This is a rare ocurrence, if the timer limit is too low, to change OFFSET to "+I2S(bestoffset) )
                exitwhen true
            endif
            if (H2I(tT[i])-OFFSET>=0)  then
                set i=i+1
            endif
        endloop

        set tN=i
    endfunction

endlibrary
//===========================================================================
// Trigger: xebasic
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library xebasic
//**************************************************************************
//
// xebasic 0.4
// =======
// XE_DUMMY_UNITID : Rawcode of the dummy unit in your map. It should
//                   use the dummy.mdx model, so remember to import it as
//                   well, just use copy&paste to copy the dummy from the
//                   xe map to yours, then change the rawcode.
//
// XE_HEIGHT_ENABLER: Medivh's raven form ability, you may need to change
//                    this rawcode to another spell that morphs into a flier
//                    in case you modified medivh's spell in your map.
//
// XE_TREE_RECOGNITION: The ancients' Eat tree ability, same as with medivh
//                      raven form, you might have to change it.
//
// XE_ANIMATION_PERIOD: The global period of animation used by whatever
//                      timer that depends on it, if you put a low value
//                      the movement will look good but it may hurt your
//                      performance, if instead you use a high value it
//                      will not lag but will be fast.
//
// XE_MAX_COLLISION_SIZE: The maximum unit collision size in your map, if
//                        you got a unit bigger than 197.0 it would be
//                        a good idea to update this constant, since some
//                        enums will not find it. Likewise, if none of
//                        your units can go bellow X and X is much smaller
//                        than 197.0, it would be a good idea to update
//                        as well, since it will improve the performance
//                        those enums.
//
// Notice you probably don't have to update this library, unless I specify
// there are new constants which would be unlikely. 
//
//**************************************************************************

//===========================================================================
globals
   constant integer XE_DUMMY_UNITID       = 'dumm'
   constant integer XE_HEIGHT_ENABLER     = 'Amrf'
   constant integer XE_TREE_RECOGNITION   = 'Aeat'
   constant real    XE_ANIMATION_PERIOD   =  0.025
   constant real    XE_MAX_COLLISION_SIZE =  197.0
endglobals

endlibrary




//===========================================================================
// Trigger: xefx
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library xefx initializer init requires xebasic
//**************************************************
// xefx 0.6
// --------
//  Recommended: ARGB (adds ARGBrecolor method)
//  For your movable fx needs
//
//**************************************************

//==================================================
 globals
    private constant integer MAX_INSTANCES = 8190 //change accordingly.
    private constant real    RECYCLE_DELAY = 4.0

    //recycling, in order to show the effect correctly, must wait some time before
    //removing the unit.
    private timer    recycler
    private timer    NOW

 endglobals

   private struct recyclebin extends array
       unit u
       real schedule
       static recyclebin end=0
       static recyclebin begin=0

       static method Recycle takes nothing returns nothing
            call RemoveUnit(.begin.u) //this unit is private, systems shouldn't mess with it.
            set .begin.u=null
            set .begin=recyclebin(integer(.begin)+1)
            if(.begin==.end) then
                set .begin=0
                set .end=0
            else
                call TimerStart(recycler, .begin.schedule-TimerGetElapsed(NOW), false, function recyclebin.Recycle)
            endif
       endmethod
   endstruct

   private function init takes nothing returns nothing
       set recycler=CreateTimer()
       set NOW=CreateTimer()
       call TimerStart(NOW,43200,true,null)
   endfunction

   struct xefx[MAX_INSTANCES]
       public integer tag=0
       private unit   dummy
       private effect fx=null
       private real   zang=0.0
       private integer r=255
       private integer g=255
       private integer b=255
       private integer a=255

       private integer abil=0

       static method create takes real x, real y, real facing returns xefx
        local xefx this=xefx.allocate()
           set this.dummy= CreateUnit(Player(15), XE_DUMMY_UNITID, x,y, facing*bj_RADTODEG)
           call UnitAddAbility(this.dummy,XE_HEIGHT_ENABLER)
           call UnitAddAbility(this.dummy,'Aloc')
           call UnitRemoveAbility(this.dummy,XE_HEIGHT_ENABLER)
           call SetUnitX(this.dummy,x)
           call SetUnitY(this.dummy,y)
        return this
       endmethod

       method operator owner takes nothing returns player
           return GetOwningPlayer(this.dummy)
       endmethod

       method operator owner= takes player p returns nothing
           call SetUnitOwner(this.dummy,p,false)
       endmethod

       method operator teamcolor= takes playercolor c returns nothing
           call SetUnitColor(this.dummy,c)
       endmethod

       method operator scale= takes real value returns nothing
           call SetUnitScale(this.dummy,value,value,value)
       endmethod

//textmacro instance: XEFX_colorstuff("red","r")
       method operator red takes nothing returns integer
           return this.r
       endmethod
       method operator red= takes integer value returns nothing
           set this.r=value
           call SetUnitVertexColor(this.dummy,this.r,this.g,this.b,this.a)
       endmethod
//end of: XEFX_colorstuff("red","r")
//textmacro instance: XEFX_colorstuff("green","g")
       method operator green takes nothing returns integer
           return this.g
       endmethod
       method operator green= takes integer value returns nothing
           set this.g=value
           call SetUnitVertexColor(this.dummy,this.r,this.g,this.b,this.a)
       endmethod
//end of: XEFX_colorstuff("green","g")
//textmacro instance: XEFX_colorstuff("blue","b")
       method operator blue takes nothing returns integer
           return this.b
       endmethod
       method operator blue= takes integer value returns nothing
           set this.b=value
           call SetUnitVertexColor(this.dummy,this.r,this.g,this.b,this.a)
       endmethod
//end of: XEFX_colorstuff("blue","b")
//textmacro instance: XEFX_colorstuff("alpha","a")
       method operator alpha takes nothing returns integer
           return this.a
       endmethod
       method operator alpha= takes integer value returns nothing
           set this.a=value
           call SetUnitVertexColor(this.dummy,this.r,this.g,this.b,this.a)
       endmethod
//end of: XEFX_colorstuff("alpha","a")

       method recolor takes integer r, integer g , integer b, integer a returns nothing
           set this.r=r
           set this.g=g
           set this.b=b
           set this.a=a
           call SetUnitVertexColor(this.dummy,this.r,this.g,this.b,this.a)
       endmethod

       implement optional ARGBrecolor

       method operator abilityid takes nothing returns integer
           return this.abil
       endmethod

       method operator abilityid= takes integer a returns nothing
           if(this.abil!=0) then
               call UnitRemoveAbility(this.dummy,this.abil)
           endif

           if(a!=0) then
               call UnitAddAbility(this.dummy,a)
           endif
           set this.abil=a
       endmethod

       method flash takes string fx returns nothing
           call DestroyEffect(AddSpecialEffectTarget(fx,this.dummy,"origin"))
       endmethod

       method operator xyangle takes nothing returns real
           return GetUnitFacing(this.dummy)*bj_DEGTORAD
       endmethod
       method operator xyangle= takes real value returns nothing
           call SetUnitFacing(this.dummy,value*bj_RADTODEG)
       endmethod

       method operator zangle takes nothing returns real
           return this.zang
       endmethod

       method operator zangle= takes real value returns nothing
        local integer i=R2I(value*bj_RADTODEG+90.5)
           set this.zang=value
           if(i>=180) then
               set i=179
           elseif(i<0) then
               set i=0
           endif
               
           call SetUnitAnimationByIndex(this.dummy, i  )
       endmethod


       method operator x takes nothing returns real
           return GetUnitX(this.dummy)
       endmethod
       method operator y takes nothing returns real
           return GetUnitY(this.dummy)
       endmethod
       method operator z takes nothing returns real
           return GetUnitFlyHeight(this.dummy)
       endmethod

       method operator z= takes real value returns nothing
           call SetUnitFlyHeight(this.dummy,value,0)
       endmethod

       method operator x= takes real value returns nothing
           call SetUnitX(this.dummy,value)
       endmethod

       method operator y= takes real value returns nothing
           call SetUnitY(this.dummy,value)
       endmethod

       method operator fxpath= takes string newpath returns nothing
           if (this.fx!=null) then
               call DestroyEffect(this.fx)
           endif
           if (newpath=="") then
               set this.fx=null
           else
               set this.fx=AddSpecialEffectTarget(newpath,this.dummy,"origin")
           endif

       endmethod
 
       private method onDestroy takes nothing returns nothing
           if(this.abil!=0) then
               call UnitRemoveAbility(this.dummy,this.abil)
           endif
           if(this.fx!=null) then
               call DestroyEffect(this.fx)
               set this.fx=null
           endif

           if (recyclebin.end==MAX_INSTANCES) then
               call TimerStart(recycler,0,false,function recyclebin.Recycle)
               call ExplodeUnitBJ(this.dummy)
           else
               set recyclebin.end.u=this.dummy
               set recyclebin.end.schedule=TimerGetElapsed(NOW)+RECYCLE_DELAY
               set recyclebin.end= recyclebin( integer(recyclebin.end)+1)
               if( recyclebin.end==1) then
                   call TimerStart(recycler, RECYCLE_DELAY, false, function recyclebin.Recycle)
               endif
               call SetUnitOwner(this.dummy,Player(15),false)
           endif
           set this.dummy=null
       endmethod

   endstruct
   


endlibrary





//===========================================================================
// Trigger: FadingText
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library FadingText uses ARGB

    function CreateFadingText takes string text, real size, real x, real y, real z, ARGB color, real time returns nothing
    local texttag tt=CreateTextTag()
        call SetTextTagText(tt, text, size*0.0023)
        call SetTextTagPos(tt, x,y,z)
        call SetTextTagPermanent(tt, false)
        call SetTextTagColor(tt, color.red, color.green, color.blue, color.alpha)
        call SetTextTagFadepoint(tt, 0)
        call SetTextTagLifespan(tt, time)
        set tt=null
    endfunction
    
endlibrary//===========================================================================
// Trigger: FoodLib
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library FoodLib

    function SetFoodUsed takes integer amount returns nothing
        call SetPlayerState(USER, PLAYER_STATE_RESOURCE_FOOD_USED, amount)
    endfunction
    
endlibrary//===========================================================================
// Trigger: Game
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library_once Game initializer Init uses TimerUtils, PlayerCamLib, WarSocMessages, WarSocCore, FoodLib, xefx
    
    // NOTES:
    // 
    
    globals
        private constant    real                    SHIP_COLLSIZE           = 24.
        private constant    real                    MINE_COLLSIZE           = 24.
        private constant    integer                 SHIP_TAG                = 'SHIP'
        private constant    integer                 MINE_TAG                = 'MINE'
        
        private constant    real                    RELATIVE_UNIT           = 2048./80.
        private constant    real                    COLL_ABSORB             = 0.65 // 1 - 0.35 
        private constant    real                    STOP_THRESHOLD          = 0.05 // in RELATIVE_UNITS
        private constant    real                    GRAVITY                 = 70. // in RELATIVE_UNITS
        private constant    real                    HOOK_PULL               = 70. // in RELATIVE_UNITS // Acceleration towards mine at ROPE_LENGTH distance
        private constant    real                    ROPE_LENGTH             = 900.
        private constant    real                    AIR_FRICTION            = 0.994 // 1 - 0.006
        private constant    real                    MINE_PULL_VEL           = 3 // in RELATIVE_UNITS
        
        private             real                    SERVER_TICK             = 1./32
        private             real                    CLIENT_TICK             = 1./64
        
                constant    integer                 SAFE_X                  = -3072
                constant    integer                 SAFE_Y                  = 0
        
                constant    real                    GAME_MIN_X              = -2048
                constant    real                    GAME_MAX_X              =  2048
                constant    real                    GAME_MIN_Y              = -1024
                constant    real                    GAME_MAX_Y              =  1024
        
        private             integer                 GAME_WAIT_TIME          = 20 // in seconds // delay after you start hosting for the first round to begin
        private             integer                 NEWROUND_WAIT_TIME      = 5 // in seconds // delay after all players died for the nect round to begin
        
        private             integer                 MINES_SPAWN_BUFFER      = 3 // in seconds // generate a new playing field this many seconds before the countdown ends
        
        private constant    real                    BREAK_HEIGHT_FACTOR     = 0.55 // break after 55%
        private constant    real                    INITIAL_GROUND_FACTOR   = 0.15 // Ground at 15%
        
        private constant    string                  MINE_MODEL              = "units\\creeps\\GoblinLandMine\\GoblinLandMine.mdl"
        private constant    real                    MINE_SCALE              = 2.00
        
        private constant    real                    MINE_MIN_DIST           = 120.
        private constant    real                    MINE_MAX_H_DIST         = 625.
        private constant    real                    MINE_MAX_DIST           = 1400.
        private constant    real                    MINE_START_H            = 450.
        private constant    real                    MINE_PRELOAD_DIST       = 512.
        
        private constant    integer                 INITIAL_SPAWN_GRANULATION = 8
        private constant    integer                 DYNAMIC_SPAWN_GRANULATION = 1
        
        private constant    string                  SHIP_MODEL              = "Abilities\\Spells\\Other\\ImmolationRed\\ImmolationRedTarget.mdl"
        private constant    string                  SHIP_OWN_MODEL          = "Abilities\\Spells\\NightElf\\Immolation\\ImmolationTarget.mdl"
        private constant    real                    SHIP_SCALE              = 0.60
        
        private constant    string                  DEATH_FX                = "Abilities\\Spells\\Other\\Doom\\DoomDeath.mdl"
        
        private constant    string                  GLOW_FX                 = "war3mapImported\\HeroGlow_Origin.mdx"
        
        private constant    string                  LIGHTNING_TYPE          = "CLEA" // custom one inserted via SLK editing
        
        private constant    real                    LIGHTNING_TO_SHIP_ALPHA = 1
        private constant    real                    LIGHTNING_TO_SHIP_RED   = 1
        private constant    real                    LIGHTNING_TO_SHIP_GREEN = 1
        private constant    real                    LIGHTNING_TO_SHIP_BLUE  = 1
        
        private constant    real                    LIGHTNING_TO_MOUSE_ALPHA = 1
        private constant    real                    LIGHTNING_TO_MOUSE_RED  = 1
        private constant    real                    LIGHTNING_TO_MOUSE_GREEN = 0
        private constant    real                    LIGHTNING_TO_MOUSE_BLUE = 0
        
        private constant    real                    COUNTDOWN_TEXT_SIZE     = 13
        private constant    real                    COUNTDOWN_TEXT_MEAN_WIDTH_PER_CHAR = 14
        private constant    real                    COUNTDOWN_TEXT_X        = 0
        private constant    real                    COUNTDOWN_TEXT_Y        = 640
        private constant    real                    COUNTDOWN_TEXT_Z        = 0
        private             ARGB                    COUNTDOWN_TEXT_COLOR    = 0xFFFFCC00
        private constant    real                    COUNTDOWN_TEXT_FADE_TIME = 0.8
        
        
        private             boolean                 DISCONNECT_FLAG         = false
        private             boolean                 COUNTDOWN_FLAG          = false
        
        
                            messageid               MSG_ID_LMOUSEDOWN
                            messageid               MSG_ID_LMOUSEUP
                            messageid               MSG_ID_RMOUSEDOWN
                            messageid               MSG_ID_RMOUSEUP
        
                            messageid               MSG_ID_NEWMINE
                            messageid               MSG_ID_NEWMINEXY
                            messageid               MSG_ID_RECYCLEMINE
        
                            messageid               MSG_ID_NEWSHIPXY
                            messageid               MSG_ID_DEATH
        
                            messageid               MSG_ID_MOVEOBJECTS
        
                            messageid               MSG_ID_PLAYERJOIN
                            messageid               MSG_ID_PLAYERLEAVE
        
                            messageid               MSG_ID_COUNTDOWN
                            messageid               MSG_ID_NEWROUND
        
                            messageid               MSG_ID_NEWPLAYERBEST
        
                            messageid               MSG_ID_SPECTATE
        
        
        private constant    integer                 VERSION_MAIN        = 2
        private constant    integer                 VERSION_SUB         = 0
        private constant    integer                 VERSION_PATCH       = 0
    endglobals
    
    private keyword object
    private keyword mine
    private keyword ship
    
    globals
        private             integer                 BaseY = 0
        private             integer                 BreakY = 0
        private             integer                 LastMineY = 0
        
        private             boolean         array   PlayerActive
        private             boolean         array   PlayerPlaying
        private             boolean         array   PlayerSpectating
        private             integer                 PlayersPlaying=0
        
        private             ship            array   Ship
        private             integer         array   Best
        private             integer                 ATBest=0
        private             integer                 CBest =0
        private             integer                 PBBest=0
        
        private             mine            array   Mine
        private             integer         array   MineTable
        private             integer                 MCnt = 0
        
        private             trigger                 LMD = CreateTrigger()
        private             trigger                 LMU = CreateTrigger()
        private             trigger                 RMD = CreateTrigger()
        private             trigger                 RMU = CreateTrigger()
        private             trigger                 MW  = CreateTrigger()
        
        private             timer                   CLIENT_TIMER = CreateTimer()
        private             lightning               MouseLightning
        private             lightning               GroundLightning
        private             xefx                    HookLight
        
        private             timer                   SERVER_TIMER = CreateTimer()
        
        private             string          array   DeathMessages
        private             integer                 DeathMessagesCount = 0
    endglobals
    
    private keyword EndRound
    
    function GetTriggerWheelData takes nothing returns integer
        return GetTriggerParam_Integer(0)
    endfunction
    
    private struct object
        public delegate xefx u
        public real cs // collision size
        
        private integer i
        
        private static thistype array Structs
        private static integer Count=0
        
        static method create takes nothing returns thistype
        local thistype s=thistype.allocate()
            set thistype.Structs[thistype.Count]=s
            set s.i=thistype.Count
            set thistype.Count=thistype.Count+1
            return s
        endmethod
        
        method onDestroy takes nothing returns nothing
            set thistype.Count=thistype.Count-1
            set thistype.Structs[.i]=thistype.Structs[thistype.Count]
            set thistype.Structs[.i].i=.i
        endmethod
        
        method getNearest takes integer tx, integer ty returns thistype
        local integer i=thistype.Count-1
        local integer d = 0x7FFFFFF0
        local integer t
        local integer x
        local integer y
        local thistype s=0
            loop
                exitwhen i<0
                if thistype.Structs[i]!=this then
                    set x=R2I(thistype.Structs[i].x)-tx
                    set y=R2I(thistype.Structs[i].y)-ty
                    set t=(x*x + y*y)
                    if t<d then
                        set d=t
                        set s=thistype.Structs[i]
                    endif
                endif
                set i=i-1
            endloop
            return s
        endmethod
        
        static method moveDown takes real d returns nothing
        local integer i=thistype.Count-1
            loop
                exitwhen i<0
                set thistype.Structs[i].y=thistype.Structs[i].y-d
                set i=i-1
            endloop
        endmethod
    endstruct
    
    private struct mine extends object
        private static integer N=0
        private static xefx array D
        
        static method create takes real x, real y returns thistype
        local thistype s=thistype.allocate()
            if thistype.N==0 then
                set s.u=xefx.create(x,y,0)
                set s.u.fxpath=MINE_MODEL
                set s.u.scale=MINE_SCALE
                set s.u.tag=MINE_TAG
            else
                set thistype.N=thistype.N-1
                set s.u=thistype.D[thistype.N]
                set s.x=x
                set s.y=y
            endif
            set s.cs=MINE_COLLSIZE
            return s
        endmethod
        
        method onDestroy takes nothing returns nothing
            set .x=SAFE_X
            set .y=SAFE_Y
            set thistype.D[thistype.N]=.u
            set thistype.N=thistype.N+1
        endmethod
    endstruct
    
    private function NewMinePos takes integer mid, integer x, integer y returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(mid)
            call WarSocCore.bufferSend.writeShort(x)
            call WarSocCore.bufferSend.writeShort(y)
            call WarSocMessages_sendBufferToAll(MSG_ID_NEWMINEXY, WarSocCore.bufferSend)
            set Mine[mid].x=x
            set Mine[mid].y=y
        endif
    endfunction
    
    private function NewMine takes integer x, integer y returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(x)
            call WarSocCore.bufferSend.writeShort(y)
            call WarSocMessages_sendBufferToAll(MSG_ID_NEWMINE, WarSocCore.bufferSend)
            set Mine[MCnt]=mine.create(x,y)
            set MineTable[Mine[MCnt]]=MCnt
            set MCnt=MCnt+1
        endif
    endfunction
    
    private function ReleaseMine takes integer mid returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(mid)
            call WarSocMessages_sendBufferToAll(MSG_ID_RECYCLEMINE, WarSocCore.bufferSend)
            set MCnt=MCnt-1
            call Mine[mid].destroy()
            set Mine[mid]=Mine[MCnt]
            set MineTable[Mine[mid]]=mid
        endif
    endfunction
    
    private struct ship extends object
        private lightning hl
        
        public real speedx
        public real speedy
        
        public object hook
        public boolean hooked
        
        private integer i
        
        private static thistype array Structs
        private static integer Count=0
        private static timer T=CreateTimer()
        
        static method Callback takes nothing returns nothing
        local integer i=thistype.Count-1
        local thistype s
            loop
                exitwhen i<0
                set s=thistype.Structs[i]
                if s.hooked then
                    call MoveLightning(s.hl, false, s.x, s.y, s.hook.x, s.hook.y)
                endif
                set i=i-1
            endloop
        endmethod
        
        static method create takes player p returns thistype
        local thistype s=thistype.allocate()
            set s.u=xefx.create(SAFE_X, SAFE_Y, 0)
            if p==USER then
                set s.u.fxpath=SHIP_OWN_MODEL
            else
                set s.u.fxpath=SHIP_MODEL
            endif
            set s.u.scale=SHIP_SCALE
            set s.cs=SHIP_COLLSIZE
            set s.u.tag=SHIP_TAG
            set s.hl=AddLightning(LIGHTNING_TYPE, false, 0,0,0,0)
            call SetLightningColor(s.hl, 0,0,0,0)
            
            return s
        endmethod
        
        method Hook takes integer x, integer y returns nothing
            if not .hooked then
                set .hook=.getNearest(x,y)
                set .hooked=true
                call MoveLightning(.hl, false, .x, .y, .hook.x, .hook.y)
                call SetLightningColor(.hl, LIGHTNING_TO_SHIP_RED, LIGHTNING_TO_SHIP_GREEN, LIGHTNING_TO_SHIP_BLUE, LIGHTNING_TO_SHIP_ALPHA)
                
                set thistype.Structs[thistype.Count]=this
                set .i=thistype.Count
                if thistype.Count==0 then
                    call TimerStart(thistype.T, CLIENT_TICK, true, function thistype.Callback)
                endif
                set thistype.Count=thistype.Count+1
            endif
        endmethod
        
        method Release takes nothing returns nothing
            if .hooked then
                call SetLightningColor(.hl, 0,0,0,0)
                set .hooked=false
                set thistype.Count=thistype.Count-1
                set thistype.Structs[.i]=thistype.Structs[thistype.Count]
                set thistype.Structs[.i].i=.i
                if thistype.Count==0 then
                    call PauseTimer(thistype.T)
                endif
            endif
        endmethod
        
        method onDestroy takes nothing returns nothing
            call .Release()
            call .u.destroy()
            call DestroyLightning(.hl)
            set .hl=null
        endmethod
    endstruct
    
    private function NewShipPos takes integer pid, integer x, integer y returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeByte(pid)
            call WarSocCore.bufferSend.writeShort(x)
            call WarSocCore.bufferSend.writeShort(y)
            call WarSocMessages_sendBufferToAll(MSG_ID_NEWSHIPXY, WarSocCore.bufferSend)
            
            set Ship[pid].x=x
            set Ship[pid].y=y
        endif
    endfunction
    
    //=================================================
    
    private function DoLMouseDown takes integer pid, integer x, integer y returns nothing
        if WarSocCore.ready then
            call Ship[pid].Hook(x,y)
            call SetLightningColor(MouseLightning, 0,0,0,0)
        endif
    endfunction
    
    private function OnLMouseDown takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
    local integer x
    local integer y
        if client then
            set pid=buffer.readByte()
            set x=buffer.readShort()
            set y=buffer.readShort()
        else // we're host
            set pid=sender
            set x=buffer.readShort()
            set y=buffer.readShort()
            call WarSocCore.bufferSend.writeByte(pid)
            call WarSocCore.bufferSend.writeShort(x)
            call WarSocCore.bufferSend.writeShort(y)
            call WarSocMessages_sendBufferToAll(MSG_ID_LMOUSEDOWN, WarSocCore.bufferSend)
        endif
        debug call BJDebugMsg("MLD: "+I2S(pid)+" "+I2S(x)+" "+I2S(y))
        call DoLMouseDown(pid,x,y)
    endfunction
    
    private function LMouseDown takes nothing returns nothing
    local integer x=R2I(GetMouseTargetX())
    local integer y=R2I(GetMouseTargetY())
        if WarSocCore.ready then
            if WarSocCore.hosting then
                call WarSocCore.bufferSend.writeByte(WarSocCore.myId)
                call WarSocCore.bufferSend.writeShort(x)
                call WarSocCore.bufferSend.writeShort(y)
                call WarSocMessages_sendBufferToAll(MSG_ID_LMOUSEDOWN, WarSocCore.bufferSend)
                debug call BJDebugMsg("MLD: "+I2S(WarSocCore.myId)+" "+I2S(x)+" "+I2S(y))
                call DoLMouseDown(WarSocCore.myId, x,y)
            else
                call WarSocCore.bufferSend.writeShort(x)
                call WarSocCore.bufferSend.writeShort(y)
                call WarSocMessages_sendBufferToPlayer(1, MSG_ID_LMOUSEDOWN, WarSocCore.bufferSend)
            endif
        endif
    endfunction
    
    //=================================================
    
    private function DoLMouseUp takes integer pid returns nothing
    local object s
        if WarSocCore.ready then
            call Ship[pid].Release()
            set HookLight.x=SAFE_X
            set HookLight.y=SAFE_Y
            set s=Ship[pid].getNearest(R2I(GetMouseTargetX()), R2I(GetMouseTargetY()))
            call SetLightningColor(MouseLightning, LIGHTNING_TO_MOUSE_RED, LIGHTNING_TO_MOUSE_GREEN, LIGHTNING_TO_MOUSE_BLUE, LIGHTNING_TO_MOUSE_ALPHA)
            call MoveLightning(MouseLightning, false, s.x, s.y, GetMouseTargetX(), GetMouseTargetY())
        endif
    endfunction
    
    private function OnLMouseUp takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
        if WarSocCore.ready then
            if client then
                set pid=buffer.readByte()
            else // we're host
                set pid=sender
                call WarSocCore.bufferSend.writeByte(pid)
                call WarSocMessages_sendBufferToAll(MSG_ID_LMOUSEUP, WarSocCore.bufferSend)
            endif
            debug call BJDebugMsg("MLU: "+I2S(pid))
            call DoLMouseUp(pid)
        endif
    endfunction
    
    private function LMouseUp takes nothing returns nothing
        if WarSocCore.ready then
            if WarSocCore.hosting then
                call WarSocCore.bufferSend.writeByte(WarSocCore.myId)
                call WarSocMessages_sendBufferToAll(MSG_ID_LMOUSEUP, WarSocCore.bufferSend)
                debug call BJDebugMsg("MLU: "+I2S(WarSocCore.myId))
                call DoLMouseUp(WarSocCore.myId)
            else
                call WarSocMessages_sendBufferToPlayer(1, MSG_ID_LMOUSEUP, WarSocCore.bufferSend)
            endif
        endif
    endfunction
    
    //=================================================
    
    private function OnRMouseDown takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
    local integer x
    local integer y
        if client then
            set pid=buffer.readByte()
            set x=buffer.readShort()
            set y=buffer.readShort()
        else // we're host
            set pid=sender
            set x=buffer.readShort()
            set y=buffer.readShort()
            call WarSocCore.bufferSend.writeByte(pid)
            call WarSocCore.bufferSend.writeShort(x)
            call WarSocCore.bufferSend.writeShort(y)
            call WarSocMessages_sendBufferToAll(MSG_ID_RMOUSEDOWN, WarSocCore.bufferSend)
        endif
        debug call BJDebugMsg("MRD: "+I2S(pid)+" "+I2S(x)+" "+I2S(y))
        //call Game.DoRMouseDown(pid,x,y)
    endfunction
    
    private function RMouseDown takes nothing returns nothing
    local integer x=R2I(GetMouseTargetX())
    local integer y=R2I(GetMouseTargetY())
        if WarSocCore.ready then
            if WarSocCore.hosting then
                call WarSocCore.bufferSend.writeByte(WarSocCore.myId)
                call WarSocCore.bufferSend.writeShort(x)
                call WarSocCore.bufferSend.writeShort(y)
                call WarSocMessages_sendBufferToAll(MSG_ID_RMOUSEDOWN, WarSocCore.bufferSend)
                debug call BJDebugMsg("MRD: "+I2S(WarSocCore.myId)+" "+I2S(x)+" "+I2S(y))
                //call Game.DoRMouseDown(WarSocCore.myId, x,y)
            else
                call WarSocCore.bufferSend.writeShort(x)
                call WarSocCore.bufferSend.writeShort(y)
                call WarSocMessages_sendBufferToPlayer(1, MSG_ID_RMOUSEDOWN, WarSocCore.bufferSend)
            endif
        endif
    endfunction
    
    //=================================================
    
    private function OnRMouseUp takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
        if WarSocCore.ready then
            if client then
                set pid=buffer.readByte()
            else // we're host
                set pid=sender
                call WarSocCore.bufferSend.writeByte(pid)
                call WarSocMessages_sendBufferToAll(MSG_ID_RMOUSEUP, WarSocCore.bufferSend)
            endif
            debug call BJDebugMsg("MRU: "+I2S(pid))
            //call Game.DoRMouseUp(pid)
        endif
    endfunction
    
    private function RMouseUp takes nothing returns nothing
        if WarSocCore.ready then
            if WarSocCore.hosting then
                call WarSocCore.bufferSend.writeByte(WarSocCore.myId)
                call WarSocMessages_sendBufferToAll(MSG_ID_RMOUSEUP, WarSocCore.bufferSend)
                debug call BJDebugMsg("MRU: "+I2S(WarSocCore.myId))
                //call Game.DoRMouseUp(WarSocCore.myId)
            else
                call WarSocMessages_sendBufferToPlayer(1, MSG_ID_RMOUSEUP, WarSocCore.bufferSend)
            endif
        endif
    endfunction
    
    //=================================================
    
    private function MouseWheel takes nothing returns nothing
        if WarSocCore.ready then
            debug call BJDebugMsg("MW: "+StringTertiaryOp(GetTriggerWheelData()>0, "+", "")+I2S(GetTriggerWheelData()))
        endif
    endfunction
    
    //=================================================
    
    private function OnNewMine takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        if WarSocCore.ready and client then
            set Mine[MCnt]=mine.create(buffer.readShort(), buffer.readShort())
            set MCnt=MCnt+1
        endif
    endfunction
    
    //=================================================
    
    private function OnNewMinePos takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer mid
        if WarSocCore.ready and client then
            set mid=buffer.readShort()
            set Mine[mid].x=buffer.readShort()
            set Mine[mid].y=buffer.readShort()
        endif
    endfunction
    
    //=================================================
    
    private function OnRecycleMine takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer mid
        if WarSocCore.ready and client then
            set mid=buffer.readShort()
            call Mine[mid].destroy()
            set MCnt=MCnt-1
            set Mine[mid]=Mine[MCnt]
        endif
    endfunction
    
    //=================================================
    
    private function OnNewShipPos takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
        if WarSocCore.ready and client then
            set pid=buffer.readByte()
            set Ship[pid].x=buffer.readShort()
            set Ship[pid].y=buffer.readShort()
        endif
    endfunction
    
    //=================================================
    
    private function GetRandomDeathMsg takes nothing returns string
        return DeathMessages[GetRandomInt(0, DeathMessagesCount-1)]
    endfunction
    
    private function DoDeath takes integer pid returns nothing
        call Ship[pid].Release()
        call DestroyEffect(AddSpecialEffect(DEATH_FX, Ship[pid].x, Ship[pid].y))
        set Ship[pid].x=SAFE_X
        set Ship[pid].y=SAFE_Y
        set Ship[pid].speedx=0
        set Ship[pid].speedy=0
        set PlayerPlaying[pid]=false
        set PlayersPlaying=PlayersPlaying-1
        if pid==WarSocCore.myId then
            call DisableTrigger(LMD)
            call DisableTrigger(LMU)
            //call DisableTrigger(RMD)
            //call DisableTrigger(RMU)
            //call DisableTrigger(MW)
            call SetLightningColor(MouseLightning, 0,0,0,0)
            set HookLight.x=SAFE_X
            set HookLight.y=SAFE_Y
        endif
        call GameMsg("Player "+I2S(pid)+" "+GetRandomDeathMsg())
    endfunction
    
    private function OnDeath takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        if WarSocCore.ready and client then
            call DoDeath(buffer.readShort())
        endif
    endfunction
    
    private function Death takes integer pid returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(pid)
            call WarSocMessages_sendBufferToAll(MSG_ID_DEATH, WarSocCore.bufferSend)
            call DoDeath(pid)
        endif
    endfunction
    
    //=================================================
    
    private function DoMoveObjects takes integer d returns nothing
        call object.moveDown(d)
        set BaseY=BaseY+d
        if BaseY<=0 then
            call MoveLightning(GroundLightning, false, GAME_MIN_X, GAME_MIN_Y-BaseY-SHIP_COLLSIZE, GAME_MAX_X, GAME_MIN_Y-BaseY-SHIP_COLLSIZE)
        else
            call MoveLightning(GroundLightning, false, SAFE_X,SAFE_Y,SAFE_X,SAFE_Y)
        endif
    endfunction
    
    private function OnMoveObjects takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer d
        if WarSocCore.ready and client then
            set d=buffer.readShort()
            call DoMoveObjects(d)
        endif
    endfunction
    
    private function MoveObjectsDown takes integer d returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(d)
            call WarSocMessages_sendBufferToAll(MSG_ID_MOVEOBJECTS, WarSocCore.bufferSend)
            call DoMoveObjects(d)
        endif
    endfunction
    
    //=================================================
    
    private function DoPlayerLeave takes integer pid returns nothing
        if WarSocCore.ready then
            set PlayerActive[pid]=false
            set PlayerPlaying[pid]=false
            
            call Ship[pid].destroy()
        endif
    endfunction
    
    private function OnPlayerLeave takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        if WarSocCore.ready and client then
            call DoPlayerLeave(buffer.readByte())
        endif
    endfunction
    
    private function PlayerLeave takes integer pid, string ip returns nothing
        call WarSocCore.bufferSend.writeByte(pid)
        call WarSocMessages_sendBufferToAll(MSG_ID_PLAYERLEAVE, WarSocCore.bufferSend)
        call DoPlayerLeave(pid)
    endfunction
    
    //=================================================
    
    private function DoNewRound takes nothing returns nothing
    local integer i=0
        set CBest=0
        call SetPlayerState(USER, PLAYER_STATE_RESOURCE_GOLD, CBest)
        set PBBest=0
        call SetPlayerState(USER, PLAYER_STATE_RESOURCE_LUMBER, PBBest)
        call EnableTrigger(LMD)
        call EnableTrigger(LMU)
        //call EnableTrigger(RMD)
        //call EnableTrigger(RMU)
        //call EnableTrigger(MW)
        call SetLightningColor(MouseLightning, LIGHTNING_TO_MOUSE_RED, LIGHTNING_TO_MOUSE_GREEN, LIGHTNING_TO_MOUSE_BLUE, LIGHTNING_TO_MOUSE_ALPHA)
        set PlayersPlaying=0
        loop
            exitwhen i>MAX_PLAYERS
            if PlayerActive[i] and (not PlayerSpectating[i]) then
                set Best[i]=0
                set PlayerPlaying[i]=true
                set PlayersPlaying=PlayersPlaying+1
            endif
            set i=i+1
        endloop
        call MoveLightning(GroundLightning, false, GAME_MIN_X, GAME_MIN_Y-BaseY-SHIP_COLLSIZE, GAME_MAX_X, GAME_MIN_Y-BaseY-SHIP_COLLSIZE)
    endfunction
    
    private function OnNewRound takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        if WarSocCore.ready and client then
            set BaseY=R2I(-INITIAL_GROUND_FACTOR*(GAME_MAX_Y-GAME_MIN_Y))
            call DoNewRound()
        endif
    endfunction
    
    private function SpawnMinesOverDistance takes integer OverDist, integer granulation returns nothing
    local integer i=R2I(BaseY+MINE_PRELOAD_DIST+GAME_MAX_Y-GAME_MIN_Y-OverDist+0.5)
    local integer j
    local integer x
    local integer y
    local real mx
    local real my
    local boolean b
        loop
            exitwhen i>=BaseY+MINE_PRELOAD_DIST+GAME_MAX_Y-GAME_MIN_Y
            if GetRandomReal(0,1)<granulation/(SquareRoot(i)+1.) and i>MINE_START_H then // chance to spawn a new mine
                set y=R2I(i-BaseY+GAME_MIN_Y)
                set x=GetRandomInt(R2I(GAME_MIN_X), R2I(GAME_MAX_X))
                set j=0
                set b=true
                loop // enforce a minimum distance
                    exitwhen j>=MCnt
                    set mx=Mine[j].x
                    set my=Mine[j].y
                    if ((my-y)*(my-y))+((mx-x)*(mx-x))<MINE_MIN_DIST*MINE_MIN_DIST then
                        set b=false
                        exitwhen true
                    endif
                    set j=j+1
                endloop
                if b then
                    // if distance is ok, spawn the mine
                    set LastMineY=i
                    call NewMine(x,y)
                endif
            elseif i-LastMineY>MINE_MAX_H_DIST then // if the last mine is far enough away, force the spawning of a new one
                set y=R2I(i-BaseY+GAME_MIN_Y)
                set x=GetRandomInt(R2I(GAME_MIN_X), R2I(GAME_MAX_X))
                set mx=Mine[MCnt-1].x
                // keep the distance in check, we dont want to create impossible scenarios
                if (mx-x)*(mx-x)>(MINE_MAX_DIST*MINE_MAX_DIST)+(MINE_MAX_H_DIST*MINE_MAX_H_DIST) then
                    if mx>x then
                        set x=R2I(mx-SquareRoot((MINE_MAX_DIST*MINE_MAX_DIST)-(MINE_MAX_H_DIST*MINE_MAX_H_DIST)))
                    elseif mx<x then
                        set x=R2I(mx+SquareRoot((MINE_MAX_DIST*MINE_MAX_DIST)-(MINE_MAX_H_DIST*MINE_MAX_H_DIST)))
                    endif
                endif
                set LastMineY=i
                call NewMine(x,y)
            endif
            set i=i+granulation
        endloop
    endfunction
    
    private function SpawnInitialMines takes nothing returns nothing
    local integer i=WarSocPlayers.GetNextPlayer(0)
    local integer j=0
    local integer array a
    local integer d
        set BaseY=R2I(0.5-INITIAL_GROUND_FACTOR*(GAME_MAX_Y-GAME_MIN_Y))
        set LastMineY=0
        loop
            exitwhen i==-1
            if PlayerActive[i] then
                set a[j]=i
                set j=j+1
            endif
            set i=WarSocPlayers.GetNextPlayer(i)
        endloop
        set i=j-1
        set d=R2I((GAME_MAX_X-GAME_MIN_X)/(j+1))
        loop
            exitwhen i<0
            call NewShipPos(a[i], R2I(GAME_MIN_X+((i+1)*d)), R2I(GAME_MIN_Y-BaseY))
            call NewMine(R2I(GAME_MAX_X-((i+1)*d)+GetRandomInt(R2I(-SHIP_COLLSIZE/2), R2I(SHIP_COLLSIZE/2))), R2I(GAME_MIN_Y-BaseY+MINE_START_H))
            set i=i-1
        endloop
        
        call SpawnMinesOverDistance(R2I(GAME_MAX_Y-GAME_MIN_Y+BaseY+MINE_PRELOAD_DIST), INITIAL_SPAWN_GRANULATION)
    endfunction
    
    //=================================================
    
    private function OnCountdown takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local string str
        if WarSocCore.ready and client then
            set str=I2S(buffer.readByte())+"..."
            call CreateFadingText(str, COUNTDOWN_TEXT_SIZE, COUNTDOWN_TEXT_X-(StringLength(str)*COUNTDOWN_TEXT_MEAN_WIDTH_PER_CHAR/2), COUNTDOWN_TEXT_Y, COUNTDOWN_TEXT_Z, COUNTDOWN_TEXT_COLOR, COUNTDOWN_TEXT_FADE_TIME)
        endif
    endfunction
    
    //=================================================
    
    private function DoNewBest takes integer pid, integer newbest returns nothing
        set Best[pid]=newbest
        if pid==WarSocCore.myId and Best[pid]>ATBest then
            set ATBest=Best[pid]
            call SetFoodUsed(Best[pid])
        endif
        if pid==WarSocCore.myId and Best[pid]>PBBest then
            set PBBest=Best[pid]
            call SetPlayerState(USER, PLAYER_STATE_RESOURCE_LUMBER, PBBest)
        endif
        if Best[pid]>CBest then
            set CBest=Best[pid]
            call SetPlayerState(USER, PLAYER_STATE_RESOURCE_GOLD, CBest)
        endif
    endfunction
    
    private function OnNewPlayerBest takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
        if WarSocCore.ready and client then
            call DoNewBest(buffer.readShort(), buffer.readInt())
        endif
    endfunction
    
    private function NewBest takes integer pid, integer newbest returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocCore.bufferSend.writeShort(pid)
            call WarSocCore.bufferSend.writeInt(newbest)
            call WarSocMessages_sendBufferToAll(MSG_ID_NEWPLAYERBEST, WarSocCore.bufferSend)
            call DoNewBest(pid, newbest)
        endif
    endfunction
    
    //=================================================
    
    private function ClientCallback takes nothing returns nothing
    local object s
        if PlayerPlaying[WarSocCore.myId] then
            if not Ship[WarSocCore.myId].hooked then
                set s=Ship[WarSocCore.myId].getNearest(R2I(GetMouseTargetX()), R2I(GetMouseTargetY()))
                call MoveLightning(MouseLightning, false, s.x, s.y, R2I(GetMouseTargetX()), R2I(GetMouseTargetY()))
            else
                set HookLight.x=Ship[WarSocCore.myId].hook.x
                set HookLight.y=Ship[WarSocCore.myId].hook.y
            endif
        endif
    endfunction
    
    private function EndRoundProxy takes nothing returns nothing
        call EndRound.evaluate()
    endfunction
    
//    private function GetPart takes real x, real y, real vx, real vy, real mx, real my, real r returns real
//    local real dx=mx-x
//    local real dy=my-y
//    local real a=vx*vx-vy*vy
//    local real b=2*dy*sy-2*dx*sx
//    local real c=dx*dx-dy*dy-r*r
//        return (-b-SquareRoot(b*b-4*a*c))/(2*a)
//    endfunction
    
    private function HostCallback takes nothing returns nothing
    local integer i
    local integer j
    local real x
    local real y
    local real cx
    local real cy
    local real hx
    local real hy
    local real d
    local real a
        if WarSocCore.ready and WarSocCore.hosting then
            set i=WarSocPlayers.GetNextPlayer(0)
            loop
                exitwhen i==-1
                if PlayerPlaying[i] then
                    set hx=Ship[i].hook.x
                    set hy=Ship[i].hook.y
                    set cx=Ship[i].x
                    set cy=Ship[i].y
                    set y=cy+Ship[i].speedy*SERVER_TICK
                    if BaseY<=0 and y<=GAME_MIN_Y-BaseY then // collision with the ground
                        set Ship[i].speedy=-COLL_ABSORB*Ship[i].speedy
                        if Ship[i].speedy<=STOP_THRESHOLD then
                            set Ship[i].speedy=0
                            set y=GAME_MIN_Y-BaseY
                        else
                            set y=((1-((GAME_MIN_Y-BaseY-cy)/(y-cy)))*Ship[i].speedy*SERVER_TICK)+GAME_MIN_Y-BaseY
                        endif
                    elseif y>BreakY then
                        // move all mines a bit down, recycle invisible mines, spawn new ones, keep ship on s.breaky
                        set d=R2I(y-BreakY)
                        call MoveObjectsDown(R2I(d+0.5))
                        set j=MCnt-1
                        loop
                            exitwhen j<0
                            if Mine[j].y<GAME_MIN_Y then
                                call ReleaseMine(j)
                            endif
                            set j=j-1
                        endloop
                        call SpawnMinesOverDistance(R2I(d+0.5), DYNAMIC_SPAWN_GRANULATION)
                        set y=y-d
                    elseif y<GAME_MIN_Y and Ship[i].speedy<0 then
                        call Death(i)
                        if PlayersPlaying<=0 then
                            call EndRoundProxy()
                        endif
                    endif
                    
                    if PlayerPlaying[i] then
                        set x=cx+Ship[i].speedx*SERVER_TICK
                        if x>GAME_MAX_X then
                            set Ship[i].speedx=-COLL_ABSORB*Ship[i].speedx
                            set x=((1-((GAME_MAX_X-cx)/(x-cx)))*Ship[i].speedx*SERVER_TICK)+GAME_MAX_X
                        elseif x<GAME_MIN_X then
                            set Ship[i].speedx=-COLL_ABSORB*Ship[i].speedx
                            set x=((1-((GAME_MIN_X-cx)/(x-cx)))*Ship[i].speedx*SERVER_TICK)+GAME_MIN_X
                        endif
                        if Ship[i].hook.tag==MINE_TAG and Ship[i].hooked and ((hx-x)*(hx-x))+((hy-y)*(hy-y))<=(SHIP_COLLSIZE+MINE_COLLSIZE)*(SHIP_COLLSIZE+MINE_COLLSIZE) then
                            call Death(i)
                            call ReleaseMine(MineTable[Ship[i].hook])
                            if PlayersPlaying<=0 then
                                call EndRoundProxy()
                            endif
                        elseif Ship[i].hook.tag==SHIP_TAG and Ship[i].hooked and ((hx-x)*(hx-x))+((hy-y)*(hy-y))<=4*SHIP_COLLSIZE*SHIP_COLLSIZE then
                            // bounce
                            // for now, dont do anything, maybe ill add this later
                            //set t=GetPart(cx, cy, Ship[i].speedx*SERVER_TICK, Ship[i].speedy*SERVER_TICK, hx, hy, 2*SHIP_COLLSIZE)
                            //set x=cx+t*Ship[i].speedx*SERVER_TICK
                            //set y=cy+t*Ship[i].speedy*SERVER_TICK
                        endif
                        if PlayerPlaying[i] then
                            set d=R2I((BaseY+y-GAME_MIN_Y)/RELATIVE_UNIT)
                            if d>Best[i] then
                                call NewBest(i, R2I(d))
                            endif
                            
                            // update speeds
                            if y!=GAME_MIN_Y-BaseY or Ship[i].speedy!=0 then
                                set Ship[i].speedy=Ship[i].speedy-(GRAVITY*RELATIVE_UNIT*SERVER_TICK)
                            endif
                            if Ship[i].hooked and ((hx-x)*(hx-x)+(hy-y)*(hy-y))>(Ship[i].hook.cs+Ship[i].cs)*(Ship[i].hook.cs+Ship[i].cs) then
                                set a=Atan2(hy-y, hx-x)
                                if Ship[i].hook.tag==MINE_TAG then
                                    set d=HOOK_PULL*RELATIVE_UNIT*(ROPE_LENGTH / SquareRoot(((x-hx)*(x-hx))+((y-hy)*(y-hy))))
                                    set Ship[i].speedx=Ship[i].speedx+Cos(a)*d*SERVER_TICK
                                    set Ship[i].speedy=Ship[i].speedy+Sin(a)*d*SERVER_TICK
                                    call NewMinePos(MineTable[Ship[i].hook], R2I(Ship[i].hook.x-MINE_PULL_VEL*SERVER_TICK*RELATIVE_UNIT*Cos(a)), R2I(Ship[i].hook.y-MINE_PULL_VEL*SERVER_TICK*RELATIVE_UNIT*Sin(a)))
                                elseif Ship[i].hook.tag==SHIP_TAG then
                                    set d=0.5*HOOK_PULL*RELATIVE_UNIT*ROPE_LENGTH/SquareRoot(((x-hx)*(x-hx))+((y-hy)*(y-hy)))
                                    set Ship[i].speedx=Ship[i].speedx+Cos(a)*d*SERVER_TICK
                                    set Ship[i].speedy=Ship[i].speedy+Sin(a)*d*SERVER_TICK
                                    set ship(Ship[i].hook).speedx=ship(Ship[i].hook).speedx-Cos(a)*d*SERVER_TICK
                                    set ship(Ship[i].hook).speedy=ship(Ship[i].hook).speedy-Sin(a)*d*SERVER_TICK
                                endif
                            endif
                            
                            set Ship[i].speedx=Ship[i].speedx*AIR_FRICTION
                            set Ship[i].speedy=Ship[i].speedy*AIR_FRICTION
                            
                            call NewShipPos(i, R2I(x), R2I(y))
                        endif
                    endif
                endif
                set i=WarSocPlayers.GetNextPlayer(i)
            endloop
        endif
    endfunction
    
    //function interface MessageHandler takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    
    private function Error takes integer error returns nothing
        call ErrorMsg(WarSocErrors_getErrorDescription(error))
    endfunction
    
    //=================================================
    
    private function PlayerFilter takes integer socket, string ip returns boolean
        return true
    endfunction
    
    //=================================================
    
    private function ServerClose takes nothing returns nothing
        call GameMsg("Server shut down.")
    endfunction
    
    //=================================================
    
    private function NewRound takes nothing returns nothing
        if WarSocCore.ready and WarSocCore.hosting then
            call WarSocMessages_sendBufferToAll(MSG_ID_NEWROUND, WarSocCore.bufferSend)
            call DoNewRound()
            call TimerStart(SERVER_TIMER, SERVER_TICK, true, function HostCallback)
        endif
    endfunction
    
    private function CountdownCallback takes nothing returns nothing
    local timer t = GetExpiredTimer()
    local integer i = GetTimerData(t)
    local string str
    local integer j=WarSocPlayers.GetNextPlayer(0)
    local integer k=0
        if DISCONNECT_FLAG then // disc in progress
            set COUNTDOWN_FLAG=false
            set DISCONNECT_FLAG=false
            call ReleaseTimer(t)
            return
        endif
        // check if there are any players left willing to play
        loop
            exitwhen j==-1
            if PlayerActive[j] and (not PlayerSpectating[j]) then
                set k=k+1
            endif
            set j=WarSocPlayers.GetNextPlayer(j)
        endloop
        if k==0 then // obviously not, oh well
            call ReleaseTimer(t)
            return
        endif
        
        if i==MINES_SPAWN_BUFFER then
            call SpawnInitialMines()
        endif
        set i=i-1
        if i>0 then
            call WarSocCore.bufferSend.writeByte(i)
            call WarSocMessages_sendBufferToAll(MSG_ID_COUNTDOWN, WarSocCore.bufferSend)
            call SetTimerData(t, i)
            set str=I2S(i)+"..."
            call CreateFadingText(str, COUNTDOWN_TEXT_SIZE, COUNTDOWN_TEXT_X-(StringLength(str)*COUNTDOWN_TEXT_MEAN_WIDTH_PER_CHAR/2), COUNTDOWN_TEXT_Y, COUNTDOWN_TEXT_Z, COUNTDOWN_TEXT_COLOR, COUNTDOWN_TEXT_FADE_TIME)
        else
            call ReleaseTimer(t)
            call NewRound()
            set COUNTDOWN_FLAG=false
        endif
    endfunction
    
    private function EndRound takes nothing returns nothing
    local timer t
    local integer i=WarSocPlayers.GetNextPlayer(0)
    local integer j=0
        loop
            exitwhen i==-1
            if PlayerActive[i] and (not PlayerSpectating[i]) then
                set j=j+1
            endif
            set i=WarSocPlayers.GetNextPlayer(i)
        endloop
        if j>0 then
            set t=NewTimer()
            call PauseTimer(SERVER_TIMER)
            call SetTimerData(t, NEWROUND_WAIT_TIME)
            call TimerStart(t, 1., true, function CountdownCallback)
            set COUNTDOWN_FLAG=true
        endif
        set i=MCnt-1
        loop
            exitwhen i<0
            call ReleaseMine(i)
            set i=i-1
        endloop
    endfunction
    
    //=================================================
    
    private function DoPlayerJoin takes integer pid, boolean playing, boolean speccing returns nothing
        if WarSocCore.ready then
            set PlayerActive[pid]=true
            set PlayerPlaying[pid]=playing
            set PlayerSpectating[pid]=speccing
            
            if pid==WarSocCore.myId then
                set Ship[pid]=ship.create(USER)
                call TimerStart(CLIENT_TIMER, CLIENT_TICK, true, function ClientCallback)
            else
                set Ship[pid]=ship.create(ALLIES)
            endif
        endif
    endfunction
    
    private function OnPlayerJoin takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer pid
    local integer i
    local boolean playing
    local boolean speccing
        if WarSocCore.ready and client then 
            set pid=buffer.readByte()
            set i=buffer.readByte()
            set playing=i-(i/2)*2==1 // read first bit (i mod 2)
            set i=i-(i-(i/2)*2) // switch to the next bit (i=i-(i mod 2))
            set i=i/2 // i shr 1
            set speccing=i==1 // read it
            call DoPlayerJoin(pid, playing, speccing)
        endif
    endfunction
    
    private function PlayerJoin takes integer pid returns nothing
    local integer i
    local integer j
    local timer t
        call WarSocCore.bufferSend.writeByte(pid)
        call WarSocCore.bufferSend.writeByte(0)
        call WarSocMessages_sendBufferToAll(MSG_ID_PLAYERJOIN, WarSocCore.bufferSend)
        call DoPlayerJoin(pid, false, false)
        
        set Ship[pid].x=SAFE_X
        set Ship[pid].y=SAFE_Y
        
        set i=WarSocPlayers.GetNextPlayer(0)
        set j=0
        loop
            exitwhen i==-1
            if PlayerActive[i] and (not PlayerSpectating[i]) then
                set j=j+1
            endif
            set i=WarSocPlayers.GetNextPlayer(i)
        endloop
        
        if j==1 then
            set t=NewTimer()
            call SetTimerData(t, NEWROUND_WAIT_TIME)
            call TimerStart(t, 1., true, function CountdownCallback)
        endif
        
        // sync him up; mines first
        // then players.
        set i=0
        loop
            exitwhen i==MCnt
            call WarSocCore.bufferSend.writeShort(R2I(Mine[i].x))
            call WarSocCore.bufferSend.writeShort(R2I(Mine[i].y))
            call WarSocMessages_sendBufferToPlayer(pid, MSG_ID_NEWMINE, WarSocCore.bufferSend)
            set i=i+1
        endloop
        set i=WarSocPlayers.GetNextPlayer(0)
        loop
            exitwhen i==-1
            call WarSocCore.bufferSend.writeByte(i)
            set j=0
            if PlayerPlaying[i] then
                set j=j+1
            endif
            if PlayerSpectating[i] then
                set j=j+2
            endif
            call WarSocCore.bufferSend.writeByte(j)
            call WarSocMessages_sendBufferToPlayer(pid, MSG_ID_PLAYERJOIN, WarSocCore.bufferSend)
            // sync the positions
            call WarSocCore.bufferSend.writeByte(i)
            call WarSocCore.bufferSend.writeShort(R2I(Ship[i].x))
            call WarSocCore.bufferSend.writeShort(R2I(Ship[i].y))
            call WarSocMessages_sendBufferToPlayer(pid, MSG_ID_NEWSHIPXY, WarSocCore.bufferSend)
            if Ship[i].hooked then
                call WarSocCore.bufferSend.writeByte(i)
                call WarSocCore.bufferSend.writeShort(R2I(Ship[i].hook.x))
                call WarSocCore.bufferSend.writeShort(R2I(Ship[i].hook.y))
                call WarSocMessages_sendBufferToPlayer(pid, MSG_ID_LMOUSEDOWN, WarSocCore.bufferSend)
            endif
            set i=WarSocPlayers.GetNextPlayer(i)
        endloop
    endfunction
    
    //=================================================
    
    public function host takes integer port, string name returns boolean
    local timer t
    local boolean b
    local string str
        if DISCONNECT_FLAG then
            call ErrorMsg("Disconnect still in process, please wait a bit.")
            set b=false
        else
            set b=WarSocCore.Host(port, name, PlayerFilter, PlayerJoin, PlayerLeave, Error)
            if b then
                call DoPlayerJoin(WarSocCore.myId, false, false)
                set t=NewTimer()
                call TimerStart(t, 1., true, function CountdownCallback)
                call SetTimerData(t, GAME_WAIT_TIME)
                set COUNTDOWN_FLAG=true
                
                call WarSocCore.bufferSend.writeByte(GAME_WAIT_TIME)
                call WarSocMessages_sendBufferToAll(MSG_ID_COUNTDOWN, WarSocCore.bufferSend)
                set str=I2S(GAME_WAIT_TIME)+"..."
                call CreateFadingText(str, COUNTDOWN_TEXT_SIZE, COUNTDOWN_TEXT_X-(StringLength(str)*COUNTDOWN_TEXT_MEAN_WIDTH_PER_CHAR*0.5), COUNTDOWN_TEXT_Y, COUNTDOWN_TEXT_Z, COUNTDOWN_TEXT_COLOR, COUNTDOWN_TEXT_FADE_TIME)
                call GameMsg("Server successfully started!")
            endif
        endif
        return b
    endfunction
    
    //=================================================
    
    public function join takes string ip, integer port returns boolean
        call GameMsg("Connecting to "+ip+":"+I2S(port))
        return WarSocCore.Join(ip, port, Error, ServerClose)
    endfunction
    
    //=================================================
    
    public function disconnect takes nothing returns nothing
    local integer i
        if WarSocCore.ready then
            set i=0
            loop
                exitwhen i==MCnt
                call Mine[i].destroy() // free any remaining mines
                set i=i+1
            endloop
            set MCnt=0
            set i=0
            loop
                exitwhen i==MAX_PLAYERS
                if PlayerActive[i] then
                    call Ship[i].destroy()
                    set PlayerPlaying[i]=false
                    set PlayerActive[i]=false
                    set PlayerSpectating[i]=false
                endif
                set i=i+1
            endloop
            if COUNTDOWN_FLAG then
                set DISCONNECT_FLAG=true
            endif
            // random stuff
            set HookLight.x=SAFE_X
            set HookLight.y=SAFE_Y
            call MoveLightning(MouseLightning, false, SAFE_X, SAFE_Y, SAFE_X, SAFE_Y) // Move it!
            call SetLightningColor(GroundLightning, 0,0,0,0) // make it invisible
            // pause running timers
            if WarSocCore.hosting then
                call PauseTimer(SERVER_TIMER)
            endif
            call PauseTimer(CLIENT_TIMER)
            // disable active triggers
            call DisableTrigger(LMD)
            call DisableTrigger(LMU)
            //call DisableTrigger(RMD)
            //call DisableTrigger(RMU)
            //call DisableTrigger(MW)
            // and finally disconnect
            if WarSocCore.Disconnect() then
                call GameMsg("Successfully disconnected!")
            else
                call ErrorMsg("Internal error in library WarSocCore while disconnecting!")
            endif
        endif
    endfunction
    
    //=================================================
    
    public function Fix_Triggers takes nothing returns nothing
        call TriggerRegisterMouseEvent(LMD, EVENT_LMOUSEDOWN)
        call TriggerRegisterMouseEvent(LMU, EVENT_LMOUSEUP)
        call TriggerRegisterMouseEvent(RMD, EVENT_RMOUSEDOWN)
        call TriggerRegisterMouseEvent(RMU, EVENT_RMOUSEUP)
        call TriggerRegisterMouseEvent(MW,  EVENT_MOUSEWHEEL)
    endfunction
    
    //=================================================
    
    private function DoSpectate takes integer pid returns nothing
    local timer t
        if WarSocCore.ready then
            set PlayerSpectating[pid]=not PlayerSpectating[pid]
            if PlayerSpectating[pid] then
                call GameMsg("Player "+I2S(pid)+" became an observer.")
            else
                call GameMsg("Player "+I2S(pid)+" no longer spectates.")
            endif
            if WarSocCore.hosting then
                set t=NewTimer()
                call PauseTimer(SERVER_TIMER)
                call SetTimerData(t, NEWROUND_WAIT_TIME)
                call TimerStart(t, 1., true, function CountdownCallback)
                set COUNTDOWN_FLAG=true
            endif
        endif
    endfunction
    
    private function OnSpectate takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        if WarSocCore.ready then
            if client then
                call DoSpectate(buffer.readShort())
            else
                call WarSocCore.bufferSend.writeShort(sender)
                call WarSocMessages_sendBufferToAll(MSG_ID_SPECTATE, WarSocCore.bufferSend)
                call DoSpectate(sender)
                if PlayerPlaying[sender] then
                    call Death(sender)
                    if PlayersPlaying==0 then
                        call EndRound()
                    endif
                endif
            endif
        endif
    endfunction
    
    public function spectateToggle takes nothing returns nothing
        if WarSocCore.ready then
            if not WarSocCore.hosting then
                call WarSocMessages_sendBufferToPlayer(1, MSG_ID_SPECTATE, WarSocCore.bufferSend)
            else
                call WarSocCore.bufferSend.writeShort(WarSocCore.myId)
                call WarSocMessages_sendBufferToAll(MSG_ID_SPECTATE, WarSocCore.bufferSend)
                call DoSpectate(WarSocCore.myId)
                if PlayerPlaying[WarSocCore.myId] then
                    call Death(WarSocCore.myId)
                    if PlayersPlaying==0 then
                        call EndRound()
                    endif
                endif
            endif
        endif
    endfunction
    
    //=================================================
    
    public function Is_Player_Spectating takes integer pid returns boolean
        return PlayerSpectating[pid]
    endfunction
    
    //=================================================
    
    private function Init takes nothing returns nothing
        set MSG_ID_LMOUSEDOWN   = messageid.create()
        set MSG_ID_LMOUSEUP     = messageid.create()
        set MSG_ID_RMOUSEDOWN   = messageid.create()
        set MSG_ID_RMOUSEUP     = messageid.create()
        
        set MSG_ID_NEWMINE      = messageid.create()
        set MSG_ID_NEWMINEXY    = messageid.create()
        set MSG_ID_RECYCLEMINE  = messageid.create()
        
        set MSG_ID_NEWSHIPXY    = messageid.create()
        set MSG_ID_DEATH        = messageid.create()
        
        set MSG_ID_MOVEOBJECTS  = messageid.create()
        
        set MSG_ID_PLAYERJOIN   = messageid.create()
        set MSG_ID_PLAYERLEAVE  = messageid.create()
        
        set MSG_ID_COUNTDOWN    = messageid.create()
        set MSG_ID_NEWROUND     = messageid.create()
        
        set MSG_ID_NEWPLAYERBEST= messageid.create()
        
        set MSG_ID_SPECTATE     = messageid.create()
        
        
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnLMouseDown, MSG_ID_LMOUSEDOWN)
        call WarSocMessages_RegisterHandler(MessageHandler.OnLMouseUp, MSG_ID_LMOUSEUP)
        call WarSocMessages_RegisterHandler(MessageHandler.OnRMouseDown, MSG_ID_RMOUSEDOWN)
        call WarSocMessages_RegisterHandler(MessageHandler.OnRMouseUp, MSG_ID_RMOUSEUP)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnNewMine, MSG_ID_NEWMINE)
        call WarSocMessages_RegisterHandler(MessageHandler.OnNewMinePos, MSG_ID_NEWMINEXY)
        call WarSocMessages_RegisterHandler(MessageHandler.OnRecycleMine, MSG_ID_RECYCLEMINE)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnNewShipPos, MSG_ID_NEWSHIPXY)
        call WarSocMessages_RegisterHandler(MessageHandler.OnDeath, MSG_ID_DEATH)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnMoveObjects, MSG_ID_MOVEOBJECTS)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnPlayerJoin, MSG_ID_PLAYERJOIN)
        call WarSocMessages_RegisterHandler(MessageHandler.OnPlayerLeave, MSG_ID_PLAYERLEAVE)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnCountdown, MSG_ID_COUNTDOWN)
        call WarSocMessages_RegisterHandler(MessageHandler.OnNewRound, MSG_ID_NEWROUND)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnNewPlayerBest, MSG_ID_NEWPLAYERBEST)
        
        call WarSocMessages_RegisterHandler(MessageHandler.OnSpectate, MSG_ID_SPECTATE)
        
        
        
        call TriggerRegisterMouseEvent(LMD, EVENT_LMOUSEDOWN)
        call TriggerAddAction(LMD, function LMouseDown)
        call DisableTrigger(LMD)
        call TriggerRegisterMouseEvent(LMU, EVENT_LMOUSEUP)
        call TriggerAddAction(LMU, function LMouseUp)
        call DisableTrigger(LMU)
        call TriggerRegisterMouseEvent(RMD, EVENT_RMOUSEDOWN)
        call TriggerAddAction(RMD, function RMouseDown)
        call DisableTrigger(RMD)
        call TriggerRegisterMouseEvent(RMU, EVENT_RMOUSEUP)
        call TriggerAddAction(RMU, function RMouseUp)
        call DisableTrigger(RMU)
        call TriggerRegisterMouseEvent(MW,  EVENT_MOUSEWHEEL)
        call TriggerAddAction(MW,  function MouseWheel)
        call DisableTrigger(MW)
        
        set MouseLightning=AddLightning(LIGHTNING_TYPE, false, 0,0,0,0)
        set GroundLightning=AddLightning(LIGHTNING_TYPE, false, SAFE_X,SAFE_Y,SAFE_X,SAFE_Y)
        call SetLightningColor(MouseLightning, LIGHTNING_TO_MOUSE_RED, LIGHTNING_TO_MOUSE_GREEN, LIGHTNING_TO_MOUSE_BLUE, LIGHTNING_TO_MOUSE_ALPHA)
        set HookLight=xefx.create(SAFE_X, SAFE_Y, 0)
        set HookLight.fxpath=GLOW_FX
        set BreakY=R2I(GAME_MIN_Y+BREAK_HEIGHT_FACTOR*(GAME_MAX_Y-GAME_MIN_Y))
        
        // SetUp Death Messages
        set DeathMessages[0]="crashed."
        set DeathMessages[1]="had an accident."
        set DeathMessages[2]="met Death."
        set DeathMessages[3]="was blown up."
        set DeathMessages[4]="died."
        set DeathMessagesCount=5
    endfunction
    
endlibrary//===========================================================================
// Trigger: OnChat
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// Name: OnChat - Parses Chat
// Type: Function Interface
// Requires: Display, RtCChat
// Last updated: 02-04-09
// Description: Trigger for parsing entered chat messages.
// ************************************************************
library OnChat uses RtCChat, RtCDisplay, Game, WarSocMessages

    globals
        messageid MSG_CHAT
    endglobals
    
    private function onMSG_CHAT takes WarSocBuffer buffer, boolean client, integer sender returns nothing
        call ChatMsg(I2S(sender) + ":" + buffer.readString(), buffer.readString(), ALLIES)
    endfunction
    
    private function ChatEvent takes string message returns nothing
        call ChatMsg(I2S(WarSocCore.myId) + ":" + GetPlayerName(USER), message, USER)
        call WarSocCore.bufferSend.writeString(GetPlayerName(USER))
        call WarSocCore.bufferSend.writeString(message)
        call WarSocMessages_sendBufferToAll(MSG_CHAT, WarSocCore.bufferSend)
    endfunction
    
    private function CommandClear takes string command returns nothing
        call ClearTextMessages()
    endfunction

    private function CommandWhisper takes string command returns nothing
        //call BJDebugMsg("Whispering to " + RtCChat_GetParam(0) + ": " + RtCChat_GetRestParams(1))
    endfunction

    private function CommandNick takes string command returns nothing
        call SetPlayerName(USER, RtCChat_GetParam(0))
    endfunction
    
    private function CommandConnect takes string command returns nothing
    local string source=RtCChat_GetParam(0)
    local string ip
    local integer port
        if (not WarSocCore.ready) and (not WarSocCore.hosting) then
            if StringPos(source, ":")>0 then
                set ip=SubString(source, 0, StringPos(source, ":")-1)
                set port=S2I(SubString(source, StringPos(source, ":"), StringLength(source)))
                if port<1024 or port>65535 then
                    call ErrorMsg("Invalid Port. Ports have to range from 1024 to 65535. Defaulted to port "+I2S(WarSocCore.port)+".")
                    set port=WarSocCore.port
                endif
            else
                set ip=SubString(source, 0, StringLength(source))
                set port=WarSocCore.port
            endif
            call Game_join(ip, port)
        endif
    endfunction
    
    private function CommandHost takes string command returns nothing
    local integer port=S2I(RtCChat_GetParam(0))
        if port==0 then
            set port=WarSocCore.port
        elseif port<1024 or port>65535 then
            call ErrorMsg("Invalid Port. Ports have to range from 1024 to 65535. Defaulted to port "+I2S(WarSocCore.port)+".")
            set port=WarSocCore.port
        endif
        call Game_host(port, RtCChat_GetParam(1))
    endfunction
    
    private function CommandDisconnect takes string command returns nothing
        if StringPos(" ", command)<=0 then
            call ErrorMsg("Unknown command!")
        else
            call Game_disconnect()
        endif
    endfunction
    
    private function FixTriggers takes string command returns nothing
        call Game_Fix_Triggers()
    endfunction
    
    private function SpectateOn takes string command returns nothing
        if WarSocCore.ready and (not Game_Is_Player_Spectating(WarSocCore.myId)) then
            call Game_spectateToggle()
        endif
    endfunction
    
    private function SpectateOff takes string command returns nothing
        if WarSocCore.ready and Game_Is_Player_Spectating(WarSocCore.myId) then
            call Game_spectateToggle()
        endif
    endfunction
    
    //===========================================================================
    public function Init takes nothing returns nothing
        set MSG_CHAT=messageid.create()
        call RtCChat_Init(USER, OnChatEvent.ChatEvent)
        
        call RtCChat_RegisterCommand("clear", CommandClear)
        call RtCChat_RegisterCommand("whisper", CommandWhisper)
        call RtCChat_RegisterCommand("w", CommandWhisper)
        call RtCChat_RegisterCommand("nick", CommandNick)
        call RtCChat_RegisterCommand("n", CommandNick)
        call RtCChat_RegisterCommand("connect", CommandConnect)
        call RtCChat_RegisterCommand("host", CommandHost)
        call RtCChat_RegisterCommand("disconnect", CommandDisconnect)
        call RtCChat_RegisterCommand("fix", FixTriggers)
        call RtCChat_RegisterCommand("spectate", SpectateOn)
        call RtCChat_RegisterCommand("join", SpectateOff)
        call WarSocMessages_RegisterHandler(MessageHandler.onMSG_CHAT, MSG_CHAT)
    endfunction
    
endlibrary
//===========================================================================
// Trigger: PlayerCam
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library PlayerCamLib uses TimerUtils
    
    globals
        private constant    real                        TICK                        = 1./64
    endglobals

    struct PlayerCam
        private static timer t=CreateTimer()
        private static real x
        private static real y
        private static real tdist
        
        private static method Center takes nothing returns nothing
            call PanCameraToTimed(PlayerCam.x, PlayerCam.y, 0)
            // whatever those things do, IT WORKS
            call SetCameraField(CAMERA_FIELD_ANGLE_OF_ATTACK, 270, 0)
            call SetCameraField(CAMERA_FIELD_ROLL, 0, 0)
            call SetCameraField(CAMERA_FIELD_ROTATION, 90, 0)
            // distance from point focused
            call SetCameraField(CAMERA_FIELD_TARGET_DISTANCE, PlayerCam.tdist, 0)
        endmethod
        
        static method Start takes real x, real y, real tdist returns nothing
            set PlayerCam.x=x
            set PlayerCam.y=y
            set PlayerCam.tdist=tdist
            call TimerStart(PlayerCam.t, TICK, true, function PlayerCam.Center)
        endmethod
        
        static method Stop takes nothing returns nothing
            call PauseTimer(PlayerCam.t)
        endmethod
    endstruct
    
endlibrary//===========================================================================
// Trigger: Typecasting
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library Typecasting
    
    function H2I takes handle h returns integer
        return h
        return 0
    endfunction
    
endlibrary//===========================================================================
// Trigger: RtCChat
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// ************************************************************
// Name: OnChat - Parses Chat
// Type: Trigger
// Requires: RtCVector
// Last updated: 02-04-09
// Description: Library for parsing chat messages.
// ************************************************************
// Function Interfaces
// - function interface OnChatEvent takes string message returns nothing
// - function interface RtCChatCommand takes string command returns nothing
//
// Public Functions
// - function GetRestParams takes integer start returns string
// - function GetParam takes integer index returns string
// - function RegisterCommand takes string command, RtCChatCommand CommandFunction returns nothing
//

library RtCChat requires RtCVector, Table
    globals
        private OnChatEvent chatEvent
        private StringTable commands
        private string array param
    endglobals
    
    function interface OnChatEvent takes string message returns nothing
    function interface RtCChatCommand takes string command returns nothing

    public function GetRestParams takes integer start returns string
     local string s = ""
     local integer i = start
        loop
            exitwhen param[i] == ""
            set s = s + param[i] + " "
            set i = i + 1
        endloop
        return s
    endfunction

    public function GetParam takes integer index returns string
        return param[index]
    endfunction

    public function RegisterCommand takes string command, RtCChatCommand CommandFunction returns nothing
        set commands[command] = CommandFunction
    endfunction

    private function ParseCommand takes string message returns nothing
     local integer i            = 0
     local boolean b            = false
     local boolean singleWord   = false
     local integer spacepos     = 0
     local string command       = ""
     local string params        = ""
     local RtCChatCommand CommandFunction
     
        set spacepos = StringPos(message, " ")
        if(spacepos > 0) then
            set command = SubString(message, 1, spacepos-1)
            set params = SubString(message, spacepos, StringLength(message))
            loop
                set spacepos = StringPos(params, " ")
                if(spacepos > 0) then
                    set param[i] = SubString(params, 0, spacepos-1)
                    set params = SubString(params, spacepos, StringLength(params))
                else
                    set param[i] = SubString(params, spacepos, StringLength(params))
                    exitwhen true
                endif
                exitwhen param[i] == ""
                set i = i + 1
            endloop
        else
            set command = SubString(message, 1, StringLength(message))
            set singleWord = true
        endif
        
        set CommandFunction = commands[command]
        if(CommandFunction != 0) then
            call CommandFunction.evaluate(command)
        endif
        
        set i = 0
        loop
            exitwhen i > 255
            set param[i] = ""
            set i = i + 1
        endloop
    endfunction

    private function Actions takes nothing returns nothing
     local string sender = GetPlayerName(GetTriggerPlayer())
     local string message = GetEventPlayerChatString()
        if (StringPos(message, "/") == 1) then
            call ParseCommand(message)
        else
            call chatEvent.evaluate(message)
        endif
    endfunction

    //===========================================================================
    public function Init takes player p, OnChatEvent ChatEvent returns nothing
     local trigger trig = CreateTrigger()
     local integer i    = 0
     
        set chatEvent = ChatEvent
        set commands = StringTable.create()
        
        call TriggerRegisterPlayerChatEvent(trig, p, "", false)
        call TriggerAddAction(trig, function Actions)
        
        set i = 0
        loop
            exitwhen i > 255
            set param[i] = ""
            set i = i + 1
        endloop
    endfunction
endlibrary
//===========================================================================
// Trigger: RtCDisplay
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library RtCDisplay requires GetPlayerColored
    function T2S takes integer time returns string
        if (time < 10) then
            return "0" + I2S(time)
        endif
        return I2S(time)
    endfunction

    function GameMsg takes string message returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r] " + message)
    endfunction

    function DebugMsg takes string message returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r - |cffff0000DEBUG|r] " + message)
    endfunction

    function ErrorMsg takes string message returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r - |cffff0000ERROR|r] " + message)
    endfunction

    function WarningMsg takes string message returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r - |cffffcc00WARNING|r] " + message)
    endfunction
    
    function ChatMsg takes string name, string message, player controller returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r] " + GetPlayerTextColor(controller)+name+"|r"+ ": " + message)
    endfunction
    
    function AnnouncementMsg takes string message returns nothing
        local string timestr = T2S(GetTimeHours()) + ":" + T2S(GetTimeMinutes()) + ":" + T2S(GetTimeSeconds())
        call DisplayTextToPlayer(GetLocalPlayer(), 0., 0., "[|cff87ceeb" + timestr + "|r - |cffffcc00ANNOUNCEMENT|r] " + message)
    endfunction
endlibrary
//===========================================================================
// Trigger: RtCExternalIP
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library RtCExternalIP initializer Init uses TimedEventEx
    globals
        public string IP        = "EXTERNAL_IP NOT READY"
        public boolean READY    = false
        private integer socket
        private integer buffer
    endglobals
    
    private function Actions takes nothing returns nothing
     local string s
     local integer i
        call SocSetFormat(socket, 1, Char(13) + Char(10))
        set i = SocReceiveMessage(socket, 0, buffer)
        if(i > 0) then
            loop
                exitwhen i <= 0
                set i = SocReceiveMessage(socket, 0, buffer)
            endloop
        else
            return
        endif
        
        call SocSetFormat(socket, 0, " ")
        set i = SocReceiveMessage(socket, 8192, buffer)
        if(i > 0) then
            loop
                exitwhen i <= 0
                set s = ""
                loop
                    exitwhen BufferBytesLeft(buffer) <= 0
                    set i = BufferReadByte(buffer)
                    if(i < 32) then
                        set s = s + "(" + I2S(i) + ")"
                    else
                        set s = s + Char(i)
                    endif
                endloop
                set IP = s
                set i = SocReceiveMessage(socket, 0, buffer)
            endloop
        else
            return
        endif
        set READY = true
        call DestroyBuffer(buffer)
        call SocCloseSocket(socket)
        call DisableTrigger(GetTriggeringTrigger())
    endfunction
    
    private function Init takes nothing returns nothing
     local trigger trig = CreateTrigger()
        call TriggerAddAction(trig, function Actions)
        call TriggerRegisterTimerEvent(trig, 0.01, true)
        set socket = SocTCPConnect("www.whatismyip.com", 80, 1)
        set buffer = CreateBuffer()
        call SocSetFormat(socket, 1, Char(13) + Char(10))
        call BufferWriteChars("GET /automation/n09230945.asp HTTP/1.1" + Char(13) + Char(10), buffer)
        call BufferWriteChars("Host: www.whatismyip.com" + Char(13) + Char(10), buffer)
        call BufferWriteChars("User-Agent: Warcraft III" + Char(13) + Char(10), buffer)
        call BufferWriteChars("Accept: text/html" + Char(13) + Char(10), buffer)
        call BufferWriteChars("Accept-Language: en-us" + Char(13) + Char(10), buffer)
        call SocSendTCPMessage(socket, buffer)
        call BufferClear(buffer)
    endfunction
endlibrary
//===========================================================================
// Trigger: RtCLobby
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library RtCLobby requires RtCExternalIP
    globals
        private             string              QUIT_MESSAGE        = "Can't touch it!"
        
        //Private
        private integer socket
        private integer buffer
        private trigger trig=null
        private string nick
    endglobals
    
    private function Actions takes nothing returns nothing
     local integer i
     local string s
        loop
            set i = SocReceiveMessage(socket, 0, buffer)
            exitwhen i <= 0
            set s = BufferReadChars(buffer, i - 2)
            if(StringPos(s, "MODE " + nick + " +x") > 0) then
                call BufferClear(buffer)
                call BufferWriteChars("JOIN #RtCLobby", buffer)
                call SocSendTCPMessage(socket, buffer)
            endif
            if(StringPos(s, "End of /NAMES list.") > 0) then
                call BufferClear(buffer)
                call BufferWriteChars("PRIVMSG #RtCLobby :INFOGAMENAME: " + WarSocCore.gamename, buffer)
                call SocSendTCPMessage(socket, buffer)
            endif
            if(StringPos(s, "PRIVMSG") > 0 and StringPos(s, ":REFRESH:") > 0 ) then
                call BufferClear(buffer)
                call BufferWriteChars("PRIVMSG #RtCLobby :INFOGAMENAME: " + WarSocCore.gamename, buffer)
                call SocSendTCPMessage(socket, buffer)
            endif
            if StringPos(s, "PING") > 0 then
                call BufferClear(buffer)
                call BufferWriteChars("PONG "+RtCExternalIP_IP, buffer)
                call SocSendTCPMessage(socket, buffer)
            endif
        endloop
    endfunction
    
    private function Waiting takes nothing returns nothing
        loop
            exitwhen RtCExternalIP_READY
            call TriggerSleepAction(0)
        endloop
        set nick = "ip" + RtCExternalIP_IP
        set nick = StringReplace(nick, ".", "_")
        set nick = StringReplace(nick, ".", "_")
        set nick = StringReplace(nick, ".", "_")
        set nick = nick + "_" + I2S(GetRandomInt(0, 20000))
        set socket = SocTCPConnect("66.103.20.109", 6667, 1)
        set buffer = CreateBuffer()
        call SocSetFormat(socket, 1, Char(10))
        call BufferWriteChars("NICK " + nick + "\n", buffer)
        call BufferWriteChars("USER " + nick + " * * :"+GetPlayerName(USER), buffer)
        call SocSendTCPMessage(socket, buffer)
        call BufferClear(buffer)
    endfunction
    
    public function Init takes nothing returns nothing
        if trig==null then
            call Waiting.execute()
            
            set trig = CreateTrigger()
            call TriggerAddAction(trig, function Actions)
            call TriggerRegisterTimerEvent(trig, 1.00, true)
        elseif not IsTriggerEnabled(trig) then
            call EnableTrigger(trig)
            // connect to the IRC server
            set socket=SocTCPConnect("66.103.20.109", 6667, 1)
            call SocSetFormat(socket, 1, Char(10))
            call BufferClear(buffer)
            call BufferWriteChars("NICK " + nick + "\n", buffer)
            call BufferWriteChars("USER " + nick + " * * :"+GetPlayerName(USER), buffer)
            call SocSendTCPMessage(socket, buffer)
            call BufferClear(buffer)
        endif
    endfunction
    
    public function Disconnect takes nothing returns nothing
        if trig!=null and IsTriggerEnabled(trig) then
            call DisableTrigger(trig)
            // disconnect from the IRC server
            call BufferClear(buffer)
            call BufferWriteChars("QUIT :"+QUIT_MESSAGE, buffer) // send the quit message
            call SocSendTCPMessage(socket, buffer)
            call BufferClear(buffer)
            // close the connection
            call SocCloseSocket(socket)
        endif
    endfunction
    
endlibrary
//===========================================================================
// Trigger: RtCVector
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library RtCVector
    struct vector extends array
        static method create takes integer size returns vector
            return CreateVector(size)
        endmethod
        
        method copy takes nothing returns vector
         local vector iv = vector.create(this.size)
         local integer i = 0
            loop
                exitwhen i >= this.size
                set iv[i] = this[i]
                set i = i + 1
            endloop
            return iv
        endmethod
		
        method free takes nothing returns nothing
            call DestroyVector(this)
        endmethod
		
        method clear takes nothing returns nothing
            call VectorClear(this)
        endmethod
        
        method operator size takes nothing returns integer
            return GetVectorSize(this)
        endmethod
        
        method operator size= takes integer newsize returns nothing
            call SetVectorSize(this, newsize)
        endmethod
        
        method operator [] takes integer index returns integer
            if(index >= this.size) then
          debug call BJDebugMsg("|cffff0000" + SCOPE_PREFIX + "Error: Reading out of bounds!|r")
                return 0
            endif
            return VectorGet(this, index)
        endmethod
        
        method operator []= takes integer index, integer value returns nothing
            if(index >= this.size) then
                set this.size = index + 1
            endif
            call VectorSet(this, index, value)
        endmethod
		
        method push takes integer value returns nothing
            call VectorPushBack(this, value)
        endmethod
		
        method pop takes nothing returns nothing
            call VectorPopBack(this)
        endmethod
		
        method peek takes nothing returns integer
            return VectorBack(this)
        endmethod
		
        method empty takes nothing returns boolean
            return VectorEmpty(this)
        endmethod
    endstruct
endlibrary
//===========================================================================
// Trigger: Init
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library Init initializer Init uses Game, TimerUtils, PlayerCamLib, OnChat
    
    globals
                constant    real                TARGET_DISTANCE = 4000
                
                            player              USER            = Player(1)
                            player              ALLIES          = Player(2)
                            player              ENEMIES         = Player(0)
                            player              ADMIN           = Player(4)
    endglobals
    
    private function Messages4 takes nothing returns nothing
        call ClearTextMessages()
        call ReleaseTimer(GetExpiredTimer())
        call PlayerCam.Start((GAME_MIN_X+GAME_MAX_X)/2,(GAME_MIN_Y+GAME_MAX_Y)/2, TARGET_DISTANCE)
        call EnableUserControl(true)
        call EnablePreSelect(false, false)
        call EnableSelect(false, false)
        call EnableDragSelect(false, false)
        call OnChat_Init()
    endfunction
    
    private function Messages3 takes nothing returns nothing
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "                           HOW TO PLAY")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "Hold down your left mouse button to hook to a mine. You will")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "be accelerated towards that mine. But be careful! If you")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "collide with the mine you're currently hooked to, you die.")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "The goal of this game is to get as high as possible.")
        call TimerStart(GetExpiredTimer(), 6., false, function Messages4)
    endfunction
    
    private function Messages2 takes nothing returns nothing
        call ClearTextMessages()
        call TimerStart(GetExpiredTimer(), 0.5, false, function Messages3)
    endfunction
    
    private function Messages1 takes nothing returns nothing
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "                          GRAVITY HOOK")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "A proof-of-concept minigame for Reinventing the Craft")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "THANKS TO:")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "Firstly, i'd like to thank |cffffcc00MindWorX|r and |cffffcc00SFilip|r for making")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "this map possible with their RtC project.")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "Secondly, I'd like to thank the original creators of")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "Gravity Hook: |cffffcc00Adam Atomic|r and |cffffcc00Danny Baranowsky|r")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "  ")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "See |cffffcc00http://www.adamatomic.com/|r for more information about")
        call DisplayTimedTextToPlayer(GetLocalPlayer(), 0.6,0, 15, "the original Gravity Hook")
        call TimerStart(GetExpiredTimer(), 6., false, function Messages2)
    endfunction
    
    private function Init takes nothing returns nothing
        call PlayerCam.Start(GetStartLocationX(GetPlayerStartLocation(USER)), GetStartLocationY(GetPlayerStartLocation(USER)), 400)
        call CreateQuestBJ(bj_QUESTTYPE_OPT_DISCOVERED, "Credits", " - |cffffcc00MindWorX|r and |cffffcc00SFilip|r for their RtC project.\n - |cffffcc00Adam Atomic|r and |cffffcc00Danny Baranowsky|r for the original game.\n - |cffffcc00Vexorian|r for JassHelper, his Optimizer, TimerUtils, Table, ARGB, xe and his dummy model.\n - |cffffcc00grim001|r for his TimedEvent library and for fixing up the physics in this map.\n - |cffffcc00Ammorth|r for his GetPlayerColored library.", "ReplaceableTextures\\CommandButtons\\BTNBansheeAdept.blp")
        call CreateQuestBJ(bj_QUESTTYPE_OPT_DISCOVERED, "Changelog", "|cffffcc00Version 1.1.0|r\n - Improved the gameplay by changing the way the acceleration towards the hooked mine is calculated.\n - Improved efficiency by implementing simple unit recycling.\n - Other minor performance related changes.\n\n|cffffcc00Version 1.1.1|r\n - Hopefully fixed most problems related to starting this map.\n - Added a command to fix problems related to viewing the quest log.\n\n|cffffcc00Version 2.0.0|r\n - Rewrote the game's core to enable multiplayer.", "ReplaceableTextures\\CommandButtons\\BTNBansheeMaster.blp")
        call CreateQuestBJ(bj_QUESTTYPE_REQ_DISCOVERED, "Commands", "|cffffcc00/connect <ip[:port]>|r:\nConnects to the given IP address on the specified port. The port defaults to \"6112\".\n\n|cffffcc00/host [port] [gamename]|r:\nStarts a server for Gravity Hook. If no port is given, it defaults to \"6112\"; If no gamename is given, it defaults to \"Gravity Hook 2 Server\"\n\n|cffffcc00/spectate|r:\nTurns you into a spectator. Only works when currently playing.\n\n|cffffcc00/join|r:\nJoins the game withe the start of the next round. Only works when currently spectating.\n\n|cffffcc00/fix|r:\nSometimes, after reading the Quest-Log, the mouse triggers malfunction. This command recreates those triggers.\n\n|cffffcc00/nick|r or |cffffcc00/n|r:\nChanges your own nick in-game.\n\n|cffffcc00/clear|r:\nClears the screen of game messages.", "ReplaceableTextures\\CommandButtons\\BTNScrollOfProtection.blp")
        call EnableUserControl(false)
        call EnableUserUI(false)
        call FogEnable(false)
        call FogMaskEnable(false)
        call SetFloatGameState(GAME_STATE_TIME_OF_DAY, 12)
        call SuspendTimeOfDay(true)
        call TimerStart(NewTimer(), 0, false, function Messages1)
    endfunction
    
endlibrary

//===========================================================================
// Trigger: WarSocBuffer
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library WarSocBuffer
    struct WarSocBuffer extends array
        static method create takes nothing returns WarSocBuffer
            return CreateBuffer()
        endmethod
        
        method free takes nothing returns nothing
            call DestroyBuffer(this)
        endmethod
        
        method clear takes nothing returns nothing
            call BufferClear(this)
        endmethod
        
        method size takes nothing returns integer
            return BufferSize(this)
        endmethod
        
        method bytesLeft takes nothing returns integer
            return BufferBytesLeft(this)
        endmethod
        
        method copyTo takes integer val returns integer
            return BufferCopy(val, this)
        endmethod
        
       
//textmacro instance: WarSocBuffer_ReadWrite("Byte",      "integer")
        method writeByte takes integer val returns integer
            return BufferWriteByte(val, this)
        endmethod
        
        method readByte takes nothing returns integer
            return BufferReadByte(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("Byte",      "integer")
//textmacro instance: WarSocBuffer_ReadWrite("Short",     "integer")
        method writeShort takes integer val returns integer
            return BufferWriteShort(val, this)
        endmethod
        
        method readShort takes nothing returns integer
            return BufferReadShort(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("Short",     "integer")
//textmacro instance: WarSocBuffer_ReadWrite("UShort",    "integer")
        method writeUShort takes integer val returns integer
            return BufferWriteUShort(val, this)
        endmethod
        
        method readUShort takes nothing returns integer
            return BufferReadUShort(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("UShort",    "integer")
//textmacro instance: WarSocBuffer_ReadWrite("Int",       "integer")
        method writeInt takes integer val returns integer
            return BufferWriteInt(val, this)
        endmethod
        
        method readInt takes nothing returns integer
            return BufferReadInt(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("Int",       "integer")
//textmacro instance: WarSocBuffer_ReadWrite("UInt",      "integer")
        method writeUInt takes integer val returns integer
            return BufferWriteUInt(val, this)
        endmethod
        
        method readUInt takes nothing returns integer
            return BufferReadUInt(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("UInt",      "integer")
//textmacro instance: WarSocBuffer_ReadWrite("Float",     "real")
        method writeFloat takes real val returns integer
            return BufferWriteFloat(val, this)
        endmethod
        
        method readFloat takes nothing returns real
            return BufferReadFloat(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("Float",     "real")
//textmacro instance: WarSocBuffer_ReadWrite("String",    "string")
        method writeString takes string val returns integer
            return BufferWriteString(val, this)
        endmethod
        
        method readString takes nothing returns string
            return BufferReadString(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("String",    "string")
//textmacro instance: WarSocBuffer_ReadWrite("OrderID",   "integer")
        method writeOrderID takes integer val returns integer
            return BufferWriteOrderID(val, this)
        endmethod
        
        method readOrderID takes nothing returns integer
            return BufferReadOrderID(this)
        endmethod
//end of: WarSocBuffer_ReadWrite("OrderID",   "integer")
       
        method writeChars takes string val returns integer
            return BufferWriteChars(val, this)
        endmethod
        
        method readChars takes integer length returns string
            return BufferReadChars(this, length)
        endmethod
    endstruct
endlibrary
//===========================================================================
// Trigger: WarSocCore
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// **********************************************************
// Name: WarSocCore
// Type: Class
// Last Updated: 06-15-09
// Event: TimerEvent
// Description: The core of the WarSoc vJassAPI, required by all WarSoc Modules
// **********************************************************
library WarSocCore requires WarSocPlayers, WarSocMessages, TimedEventEx, RtCDisplay, RtCLobby, WarSocBuffer

    function interface OnError          takes integer i                         returns nothing
    function interface OnPlayerJoin     takes integer player_id,                returns nothing
    function interface OnPlayerLeave    takes integer player_id, string ip      returns nothing
    function interface OnServerClose    takes nothing                           returns nothing
    function interface PlayerFilter     takes integer socket, string ip         returns boolean
    
    
    globals
        // Settings
                    messageid MSG_SHORT_INFO                    //A unique message id.
        
                    integer MAX_PLAYERS                 = 127   //Max is 8190
                    boolean USE_NAGLE                   = false //concatenate short messages to reduce bandwidth usage
        
        // Private
        constant integer MSG_SHORT_INFO_PID         = 1
        constant integer MSG_SHORT_INFO_REFUSED     = 2
    endglobals
    
    private function Error takes integer error returns boolean
        call WarSocCore.onError.execute(error)
        return true
    endfunction
    
    private function ListenFunction takes integer tag, real timeout returns real
    local integer socket   = tag
    local integer newsoc   = 0
    local integer recv     = 0
    local integer i
        
        if(WarSocCore.ready) then
            if(WarSocCore.hosting) then
                set newsoc = SocTCPAccept(socket, 1) //We check for new incoming connections.
                loop //We use a loop to process all players in the queue.
                    exitwhen (newsoc <= 0)
                    if(WarSocCore.playerFilter.evaluate(newsoc, SocTCPIP(newsoc)))==true then
                        set i                           = WarSocPlayers.Add(newsoc)
                        set WarSocCore.sockets[i]       = newsoc
                        set WarSocCore.socketsInUse[i]  = true
                        call SocSetNagle(newsoc, USE_NAGLE)
                        
                        call WarSocCore.bufferSend.writeByte(MSG_SHORT_INFO_PID)
                        call WarSocCore.bufferSend.writeShort(i)
                        call WarSocCore.bufferSend.writeShort(WarSocCore.count)
                        call WarSocMessages_sendBufferToPlayer(i, MSG_SHORT_INFO, WarSocCore.bufferSend)
                        
                        call WarSocCore.onPlayerJoin.execute(i)
                    else
                        call WarSocCore.bufferSend.writeByte(MSG_SHORT_INFO_REFUSED)
                        call WarSocMessages_sendBufferToSocket(newsoc, MSG_SHORT_INFO, WarSocCore.bufferSend)
                        
                        call SocCloseSocket(newsoc)
                    endif
                    set newsoc = SocTCPAccept(socket, 1)
                endloop
                //We loop through all socket that are in use, and check for incoming traffic.
                set i = WarSocPlayers.GetNextPlayer(0)
                loop //We use a loop to check all messages in the queue.
                    exitwhen i == -1
                    if i!=WarSocCore.myId then
                        if(SocTCPConnected(WarSocCore.sockets[i])) then
                            loop
                                set recv = SocReceiveMessage(WarSocCore.sockets[i], 0, WarSocCore.bufferRecv)
                                if(recv == 0) then //Client was closed.
                                    call WarSocCore.onPlayerLeave.execute(i, SocTCPIP(WarSocCore.sockets[i]))
                                    set WarSocCore.socketsInUse[i] = false
                                    set WarSocCore.sockets[i]      = 0
                                    call WarSocPlayers.Remove(i)
                                    exitwhen true
                                endif
                                exitwhen recv == -87 //No new messages.
                                exitwhen recv <  0 and Error(recv) //Unknown error, send it to the Error function.
                                call WarSocMessages_RunHandler(WarSocCore.bufferRecv, false)
                            endloop
                        else
                            call WarSocCore.onPlayerLeave.execute(i, SocTCPIP(WarSocCore.sockets[i]))
                            set WarSocCore.socketsInUse[i] = false
                            set WarSocCore.sockets[i]      = 0
                            call WarSocPlayers.Remove(i)
                        endif
                    endif
                    set i = WarSocPlayers.GetNextPlayer(i)
                endloop
            else //not hosting.
                if(SocTCPConnected(WarSocCore.clientSocket)) then
                    loop
                        set recv = SocReceiveMessage(WarSocCore.clientSocket, 0, WarSocCore.bufferRecv)
                        if(recv == 0) then //Server was closed.
                            call WarSocCore.onServerClose.execute()
                            call SocCloseSocket(WarSocCore.clientSocket)
                            set WarSocCore.ready = false
                            return -1.00
                        endif
                        exitwhen recv == -87 //No new messages.
                        exitwhen recv <  0 and Error(recv) //Unknown error, send it to the Error function.
                        call WarSocMessages_RunHandler(WarSocCore.bufferRecv, true)
                    endloop
                else
                    call WarSocCore.onServerClose.execute()
                    call SocCloseSocket(WarSocCore.clientSocket)
                    set WarSocCore.ready = false
                    return -1.00
                endif
            endif
        endif
        return 0.01
    endfunction
    
    private function onShortInfo takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer sub_msg
        if(client) then
            set sub_msg = buffer.readByte()
            
            if(sub_msg == MSG_SHORT_INFO_PID) then
                set WarSocCore.myId = buffer.readUShort()
                set WarSocCore.count = buffer.readUShort()
                call GameMsg("There "+StringTertiaryOp((WarSocCore.count == 2), "is", "are")+" currently " + I2S(WarSocCore.count - 1) + " other " + StringTertiaryOp((WarSocCore.count == 2), "player", "players") + ".")
            endif
            if(sub_msg == MSG_SHORT_INFO_REFUSED) then
                call DebugMsg("|cffff0000Connection refused!|r")
            endif
        endif
        call BufferClear(buffer)
    endfunction
    
    struct WarSocCore
        static boolean hosting              = false
        static boolean ready                = false
        static integer myId                 = 0
        static integer port                 = 6112
        static string hostname              = ""
        static integer count                = 0 // Counts active players
        static string gamename              = "Gravity Hook 2 Server"
        
        static WarSocBuffer bufferRecv      //Initialized in method onInit.
        static WarSocBuffer bufferSend      //Initialized in method onInit.
        static integer array sockets        //Initialized in method onInit.
        static boolean array socketsInUse   //Initialized in method onInit.
        
        // Private stuff
        static OnPlayerJoin onPlayerJoin    //Initialized in method Host.
        static OnPlayerLeave onPlayerLeave  //Initialized in method Host.
        static PlayerFilter playerFilter    //Initialized in method Host.
        static OnError onError              //Initialized in method Host or method Client.
        static OnServerClose onServerClose  //Initialized in method Client.
        static integer listenSocket         //Initialized in method Host.
        static integer clientSocket         //Initialized in method Join.
        
        static method Reconnect takes nothing returns boolean
            set WarSocCore.clientSocket     = SocTCPConnect(WarSocCore.hostname, WarSocCore.port, 1)
            
            if(WarSocCore.clientSocket > 0) then
                call TimedEventEx(0.00, WarSocCore.clientSocket, CallbackEx.ListenFunction)
                set WarSocCore.hosting      = false
                set WarSocCore.ready        = true
                call SocSetNagle(WarSocCore.clientSocket, USE_NAGLE)
                return true
            endif
            
            return false
        endmethod
        
        static method Disconnect takes nothing returns boolean
        local integer i
            if WarSocCore.ready then
                set WarSocCore.ready=false
                if WarSocCore.hosting then
                    call RtCLobby_Disconnect()
                    set i=WarSocPlayers.GetNextPlayer(0)
                    loop
                        exitwhen i==-1
                        call SocCloseSocket(WarSocCore.sockets[i])
                        set WarSocCore.socketsInUse[i]=false
                        call WarSocPlayers.Remove(i)
                        set i=WarSocPlayers.GetNextPlayer(i)
                    endloop
                    set WarSocCore.hosting=false
                    set WarSocCore.myId=0
                else
                    call SocCloseSocket(WarSocCore.clientSocket)
                endif
            endif
            return true
        endmethod
        
        static method Join takes string hostname, integer port, OnError onError, OnServerClose onServerClose returns boolean
            set WarSocCore.clientSocket     = SocTCPConnect(hostname, port, 1)
            set WarSocCore.onError          = onError
            set WarSocCore.onServerClose    = onServerClose
            set WarSocCore.port             = port
            set WarSocCore.hostname         = hostname
            
            if(WarSocCore.clientSocket > 0) then
                call TimedEventEx(0.00, WarSocCore.clientSocket, CallbackEx.ListenFunction)
                set WarSocCore.hosting      = false
                set WarSocCore.ready        = true
                call SocSetNagle(WarSocCore.clientSocket, USE_NAGLE)
                return true
            endif
            
            return false
        endmethod
        
        static method Host takes integer port, string gamename, PlayerFilter playerFilter, OnPlayerJoin onPlayerJoin, OnPlayerLeave onPlayerLeave, OnError onError returns boolean
            set WarSocCore.onPlayerJoin     = onPlayerJoin
            set WarSocCore.onPlayerLeave    = onPlayerLeave
            set WarSocCore.playerFilter     = playerFilter
            set WarSocCore.onError          = onError
            set WarSocCore.listenSocket     = SocTCPListen(port, 256, 1)
            set WarSocCore.port             = port
            if gamename!="" and gamename!=null then
                set WarSocCore.gamename     = gamename
            endif
            
            if(WarSocCore.listenSocket > 0) then
                call TimedEventEx(0.00, WarSocCore.listenSocket, CallbackEx.ListenFunction)
                set WarSocCore.myId         = WarSocPlayers.Add(WarSocCore.listenSocket)
                set WarSocCore.hosting      = true
                set WarSocCore.ready        = true
                set WarSocCore.sockets[WarSocCore.myId] = WarSocCore.listenSocket
                set WarSocCore.socketsInUse[WarSocCore.myId] = true
                call RtCLobby_Init()
                return true
            endif
            
            return false
        endmethod
        
        private static method onInit takes nothing returns nothing
            set WarSocCore.bufferRecv           = WarSocBuffer.create()
            set WarSocCore.bufferSend           = WarSocBuffer.create()
            set MSG_SHORT_INFO                  = messageid.create()
            
            call WarSocMessages_RegisterHandler(MessageHandler.onShortInfo, MSG_SHORT_INFO)
        endmethod
    endstruct
endlibrary
//===========================================================================
// Trigger: WarSocErrors
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// **********************************************************
// Name: WarSocErrors
// Type: Library
// Event: N/A
// Description: A library to allow better description of errors occurring in WarSoc.
// **********************************************************
library WarSocErrors initializer Init
    
    globals
        private string array Error[16380]
    endglobals
    
    public function getErrorDescription takes integer errorcode returns string
    local string s=Error[errorcode]
        if s=="" or s==null then
            set s="Unknown error."
        endif
        set s=s+" (Code: "+I2S(errorcode)+")"
        return s
    endfunction
    
    private function Init takes nothing returns nothing
        set Error[10004]="Interrupted function call."
        set Error[10013]="Permission denied."
        set Error[10014]="Bad address."
        set Error[10022]="Invalid argument."
        set Error[10024]="Too many open sockets."
        set Error[10035]="Resource temporarily unavailable."
        set Error[10036]="Operation now in progress. A blocking operation is in progress."
        set Error[10037]="Operation already in progress."
        set Error[10038]="Socket operation on non-socket."
        set Error[10039]="Destination address required."
        set Error[10040]="Message too long."
        set Error[10041]="Protocol wrong type for socket."
        set Error[10042]="Bad protocol option."
        set Error[10043]="Protocol not supported."
        set Error[10044]="Socket type not supported."
        set Error[10045]="Operation not supported."
        set Error[10046]="Protocol family not supported."
        set Error[10047]="Address family not supported by protocol family."
        set Error[10048]="Port is already in use."
        set Error[10049]="Cannot assign requested address."
        set Error[10050]="Network is down."
        set Error[10051]="Network is unreachable."
        set Error[10052]="Network dropped connection on reset."
        set Error[10053]="Software caused the connection to abort. A connection that has been made was aborted, usually due to connection or protocol error."
        set Error[10054]="Remote computer terminated connection."
        set Error[10055]="No buffer space available."
        set Error[10056]="Socket is already connected."
        set Error[10057]="Socket is not connected."
        set Error[10058]="Cannot send after socket shutdown."
        set Error[10060]="Connection timed out."
        set Error[10061]="Connection refused."
        set Error[10064]="Host is down."
        set Error[10065]="No route to host."
        set Error[10067]="Too many processes."
        set Error[10091]="Network subsystem is unavailable."
        set Error[10092]="Unsupported version of WINSOCK.DLL."
        set Error[10093]="Successful WSAStartup not yet performed. TCP networking has not been initialized on your computer."
        set Error[10094]="Graceful shutdown in progress."
        set Error[11001]="Host not found (DNS error)."
        set Error[11002]="Non-authoritative host not found. Temporary DNS error."
        set Error[11003]="Non-recoverable error (DNS error)."
        set Error[11004]="Valid name, no data record of requested type (DNS error)."
    endfunction
    
endlibrary
//===========================================================================
// Trigger: WarSocFunctions
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// **********************************************************
// Name: WarSocFunctions
// Type: Library
// Event: N/A
// Description: A set of functions/structs used by various WarSoc libraries
// **********************************************************
library WarSocFunctions

    //Author: AIAndy 
    //Description:  Returns base^expo as an exact integer value.
    function IntExp takes integer base, integer expo returns integer
        if expo == 0 then
            return 1
        elseif (expo / 2) * 2 == expo then
            return IntExp(base * base, expo / 2)
        else
            return base * IntExp(base, expo - 1)
        endif
    endfunction

    //Author: AIAndy
    //Description:  Decodes the bit with the number bit_num (starting with 0) from the integer bf.
    //              That allows to use an integer as an array of booleans.
    function DecodeInt takes integer bf, integer bit_num returns boolean
     local integer l_bf = bf / R2I(Pow(2, bit_num))
        return (l_bf / 2) * 2 != l_bf
    endfunction
    
    //Author: AIAndy
    //Description:  Encodes val in the integer bf at position bit_num.
    //              Uses DecodeInt and IntExp.
    function EncodeInt takes integer bf, integer bit_num, boolean val returns integer
        if DecodeInt(bf, bit_num) != val then
            if val then
                return bf + IntExp(2, bit_num)
            else
                return bf - IntExp(2, bit_num)
            endif
        endif
        return bf
    endfunction
    
    
    //Author: MindWorX
    //Description:  Uses AIAndys integer encoding functions, just wrapped in a struct.
    struct bitarray
        integer byte
        
        static method create takes integer byte returns bitarray
         local bitarray ba = bitarray.allocate()
            set ba.byte = byte
            return ba
        endmethod
        
        method operator [] takes integer index returns boolean
            return DecodeInt(this.byte, index)
        endmethod
        
        method operator []= takes integer index, boolean value returns nothing
            set this.byte = EncodeInt(this.byte, index, value)
        endmethod
    endstruct
    
    //Author: MindWorX
    //Description:  Just a basic TertiaryOp for strings
    function StringTertiaryOp takes boolean flag, string valueA, string valueB returns string
    if flag then
        return valueA
    else
        return valueB
    endif
endfunction
endlibrary
//===========================================================================
// Trigger: WarSocMessages
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
library WarSocMessages  initializer Init
    
    function interface MessageHandler takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    
    globals
        // Settings
                messageid MSG_RELAY        //A unique message id.
        
        
        private MessageHandler array messagehandlers
        private boolean array messagehandlers_active
    endglobals
    
    struct messageid
        
        private method onDestroy takes nothing returns nothing
        endmethod
    endstruct
    
    public function RegisterHandler takes MessageHandler messagehandler, messageid msg_id returns nothing
        if(not messagehandlers_active[integer(msg_id)]) then
            set messagehandlers[integer(msg_id)]         = messagehandler
            set messagehandlers_active[integer(msg_id)]  = true
        debug else
        debug     call BJDebugMsg("|cffff0000" + SCOPE_PREFIX + "RegisterHandler attempted to reregister handle(" + I2S(msg_id) + ") multiple times!|r")
        endif
    endfunction
    
    private function relayBufferToPlayer takes integer playerId, WarSocBuffer outBuffer returns nothing
    local integer buffer = CreateBuffer()
        call BufferWriteUShort(WarSocCore.myId, buffer)
        call BufferWriteUShort(MSG_RELAY, buffer)
        call BufferWriteUShort(playerId, buffer)
        call BufferCopy(buffer, outBuffer)
        call SocSendTCPMessage(WarSocCore.clientSocket, buffer)
        call DestroyBuffer(buffer)
    endfunction
    
    public function sendBufferToPlayer takes integer playerId, integer msg_id, WarSocBuffer outBuffer returns nothing
    local integer buffer = CreateBuffer()
    local integer i = 1
        call BufferWriteUShort(WarSocCore.myId, buffer)
        call BufferWriteUShort(msg_id, buffer)
        call BufferCopy(buffer, outBuffer)
        
        if(playerId == 0 and WarSocCore.hosting) then // hosting and we send to everyone.
            loop
                exitwhen i > MAX_PLAYERS
                if (WarSocCore.socketsInUse[i] and i != WarSocCore.myId) then
                    call SocSendTCPMessage(WarSocCore.sockets[i], buffer)
                endif
                set i = i + 1
            endloop
        elseif(WarSocCore.hosting) then // hosting, and just sending to one player.
            call SocSendTCPMessage(WarSocCore.sockets[playerId], buffer)
        else // not hosting, and just sending a messages.
            if(playerId == 1) then // sending to the host.
                call SocSendTCPMessage(WarSocCore.clientSocket, buffer)
            else // sending to a client, requesting relay of the message.
                call relayBufferToPlayer(playerId, buffer)
            endif
        endif
        
        call BufferClear(outBuffer)
        call DestroyBuffer(buffer)
    endfunction
    
    public function sendBufferToAll takes integer msg_id, WarSocBuffer outBuffer returns nothing
        call sendBufferToPlayer(0, msg_id, outBuffer)
    endfunction
    
    public function sendBufferToSocket takes integer socket, integer msg_id, WarSocBuffer outBuffer returns boolean
    local integer buffer = CreateBuffer()
        call BufferWriteUShort(WarSocCore.myId, buffer)
        call BufferWriteUShort(msg_id, buffer)
        call BufferCopy(buffer, outBuffer)
        call SocSendTCPMessage(socket, buffer)
        call DestroyBuffer(buffer)
        return true
    endfunction
    
    public function RunHandler takes WarSocBuffer buffer, boolean client returns nothing
    local integer sender = BufferReadUShort(buffer)
    local integer msg_id = BufferReadUShort(buffer)
        if(messagehandlers_active[msg_id]) then
            call messagehandlers[msg_id].execute(buffer, client, sender)
        else
      debug call BJDebugMsg("|cffff0000" + SCOPE_PREFIX + "RunHandler received a bad message id(" + I2S(msg_id) + ")!|r")
        endif
    endfunction
    
    private function onRelay takes WarSocBuffer buffer, boolean client, integer sender returns nothing
    local integer playerId = BufferReadUShort(buffer)
    local integer i = WarSocPlayers.GetNextPlayer(0)
        if(playerId == 0) then
            loop
                exitwhen i==-1
                if(WarSocCore.socketsInUse[i] and i != WarSocCore.myId and i != sender) then
                    call SocSendTCPMessage(WarSocCore.sockets[i], buffer)
                endif
                set i = WarSocPlayers.GetNextPlayer(i)
            endloop
            call RunHandler(buffer, false)
        else
            call SocSendTCPMessage(WarSocCore.sockets[playerId], buffer)
        endif
    endfunction
    
    private function Init takes nothing returns nothing
        set MSG_RELAY=messageid.create()
        call WarSocMessages_RegisterHandler(MessageHandler.onRelay, MSG_RELAY)
    endfunction
endlibrary
//===========================================================================
// Trigger: WarSocPlayers
//===========================================================================
//TESH.scrollpos=-1
//TESH.alwaysfold=0
// **********************************************************
// Name: WarSocPlayers
// Type: Library
// Last updated: 06-15-09
// Event: N/A
// Description: A module to handle player ids and names, required by WarSocCore.
// **********************************************************
library WarSocPlayers
    private struct pid
        integer socket
        integer state
        
        static method create takes integer soc returns pid
         local pid p        = pid.allocate()
            set p.socket    = soc
            set p.state     = 1
            return p
        endmethod
        
        method onDestroy takes nothing returns nothing
            set this.state = 0
        endmethod
    endstruct
    
    struct WarSocPlayers
        static method Add takes integer soc returns integer
            set WarSocCore.count = WarSocCore.count + 1
            return pid.create(soc)
        endmethod
        
        static method Remove takes integer player_id returns boolean
        local pid p        = pid(player_id)
            call SocCloseSocket(p.socket)
            call p.destroy()
            set WarSocCore.count = WarSocCore.count - 1
            return true
        endmethod
        
        static method GetPlayerSocket takes integer player_id returns integer
        local pid p        = pid(player_id)
            return p.socket
        endmethod
        
        static method GetPlayerIP takes integer player_id returns string
            if (player_id == WarSocCore.myId) then
                return "localhost"
            endif
            return SocTCPIP(pid(player_id).socket)
        endmethod
        
        static method GetNextPlayer takes integer id returns integer
            set id = id + 1
            loop
                exitwhen id > MAX_PLAYERS
                if(WarSocCore.socketsInUse[id]) then
                    return id
                endif
                set id = id + 1
            endloop
            return -1
        endmethod
        
        private static method onInit takes nothing returns nothing
            call SetAllyColorFilterState(0)
            call EnableMinimapFilterButtons(false, true)
        endmethod
    endstruct
endlibrary
//===========================================================================
function InitCustomTriggers takes nothing returns nothing
    call InitTrig_Untitled_Trigger_001(  )
    call InitTrig_ARGB(  )
    call InitTrig_GetPlayerColored(  )
    call InitTrig_SimError(  )
    call InitTrig_Table(  )
    call InitTrig_TimedEventEx(  )
    call InitTrig_TimerUtils(  )
    call InitTrig_xebasic(  )
    call InitTrig_xefx(  )
    call InitTrig_FadingText(  )
    call InitTrig_FoodLib(  )
    call InitTrig_Game(  )
    call InitTrig_OnChat(  )
    call InitTrig_PlayerCam(  )
    call InitTrig_Typecasting(  )
    call InitTrig_RtCChat(  )
    call InitTrig_RtCDisplay(  )
    call InitTrig_RtCExternalIP(  )
    call InitTrig_RtCLobby(  )
    call InitTrig_RtCVector(  )
    call InitTrig_Init(  )
    call InitTrig_WarSocBuffer(  )
    call InitTrig_WarSocCore(  )
    call InitTrig_WarSocErrors(  )
    call InitTrig_WarSocFunctions(  )
    call InitTrig_WarSocMessages(  )
    call InitTrig_WarSocPlayers(  )
endfunction

//***************************************************************************
//*
//*  Players
//*
//***************************************************************************

function InitCustomPlayerSlots takes nothing returns nothing

    // Player 1
    call SetPlayerStartLocation( Player(1), 0 )
    call ForcePlayerStartLocation( Player(1), 0 )
    call SetPlayerColor( Player(1), ConvertPlayerColor(1) )
    call SetPlayerRacePreference( Player(1), RACE_PREF_HUMAN )
    call SetPlayerRaceSelectable( Player(1), false )
    call SetPlayerController( Player(1), MAP_CONTROL_USER )

endfunction

function InitCustomTeams takes nothing returns nothing
    // Force: TRIGSTR_002
    call SetPlayerTeam( Player(1), 0 )

endfunction

//***************************************************************************
//*
//*  Main Initialization
//*
//***************************************************************************

//===========================================================================
function main takes nothing returns nothing
    call SetCameraBounds( -3456.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), -3200.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM), 3456.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), 3200.0 - GetCameraMargin(CAMERA_MARGIN_TOP), -3456.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), 3200.0 - GetCameraMargin(CAMERA_MARGIN_TOP), 3456.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), -3200.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM) )
    call SetDayNightModels( "Environment\\DNC\\DNCLordaeron\\DNCLordaeronTerrain\\DNCLordaeronTerrain.mdl", "Environment\\DNC\\DNCLordaeron\\DNCLordaeronUnit\\DNCLordaeronUnit.mdl" )
    call NewSoundEnvironment( "Default" )
    call SetAmbientDaySound( "CityScapeDay" )
    call SetAmbientNightSound( "CityScapeNight" )
    call SetMapMusic( "Music", true, 0 )
    call InitBlizzard(  )
    call InitGlobals(  )
    call InitCustomTriggers(  )

endfunction

//***************************************************************************
//*
//*  Map Configuration
//*
//***************************************************************************

function config takes nothing returns nothing
    call SetMapName( "TRIGSTR_004" )
    call SetMapDescription( "TRIGSTR_015" )
    call SetPlayers( 1 )
    call SetTeams( 1 )
    call SetGamePlacement( MAP_PLACEMENT_USE_MAP_SETTINGS )

    call DefineStartLocation( 0, 0.0, -2048.0 )

    // Player setup
    call InitCustomPlayerSlots(  )
    call InitCustomTeams(  )
endfunction


