//===========================================================================
// 
// Zephyr Contest #7 by xD.Schurke
// 
//   Warcraft III map script
//   Generated by the Warcraft III World Editor
//   Date: Wed Aug 18 04:30:39 2010
//   Map Author: xD.Schurke
// 
//===========================================================================

//***************************************************************************
//*
//*  Global Variables
//*
//***************************************************************************

globals
    // Generated
    trigger                 gg_trg_Init                = null
    trigger                 gg_trg_Table               = null
    trigger                 gg_trg_TimerUtils          = null
    trigger                 gg_trg_IntuitiveDamageSystem = null
    trigger                 gg_trg_Touch_of_Nature     = null
endglobals

function InitGlobals takes nothing returns nothing
endfunction

//***************************************************************************
//*
//*  Unit Creation
//*
//***************************************************************************

//===========================================================================
function CreateUnitsForPlayer0 takes nothing returns nothing
    local player p = Player(0)
    local unit u
    local integer unitID
    local trigger t
    local real life

    set u = CreateUnit( p, 'hfoo', -144.8, 101.9, 107.241 )
    set u = CreateUnit( p, 'E000', 17.1, -64.0, 269.280 )
    call SetHeroLevel( u, 10, false )
    set life = GetUnitState( u, UNIT_STATE_LIFE )
    call SetUnitState( u, UNIT_STATE_LIFE, 0.05 * life )
    call SetUnitState( u, UNIT_STATE_MANA, 675 )
    set u = CreateUnit( p, 'hrif', 96.6, -64.0, 250.606 )
    set u = CreateUnit( p, 'hrif', 130.1, 89.6, 198.727 )
    set u = CreateUnit( p, 'hfoo', -111.8, -49.6, 305.792 )
endfunction

//===========================================================================
function CreateUnitsForPlayer1 takes nothing returns nothing
    local player p = Player(1)
    local unit u
    local integer unitID
    local trigger t
    local real life

    set u = CreateUnit( p, 'hfoo', -443.4, -1057.5, 245.969 )
    set u = CreateUnit( p, 'hrif', -531.3, -1124.6, 142.750 )
    set u = CreateUnit( p, 'hrif', -408.0, -1165.7, 3.867 )
    set u = CreateUnit( p, 'hkni', 914.7, -713.5, 69.227 )
    set u = CreateUnit( p, 'hrif', 975.4, -832.8, 153.857 )
    set u = CreateUnit( p, 'hfoo', 292.7, 813.4, 264.998 )
    set u = CreateUnit( p, 'hfoo', 379.2, 770.3, 356.847 )
    set u = CreateUnit( p, 'hrif', 234.3, 929.7, 144.255 )
    set u = CreateUnit( p, 'hmpr', 356.5, 905.3, 328.402 )
endfunction

//===========================================================================
function CreatePlayerBuildings takes nothing returns nothing
endfunction

//===========================================================================
function CreatePlayerUnits takes nothing returns nothing
    call CreateUnitsForPlayer0(  )
    call CreateUnitsForPlayer1(  )
endfunction

//===========================================================================
function CreateAllUnits takes nothing returns nothing
    call CreatePlayerBuildings(  )
    call CreatePlayerUnits(  )
endfunction

//***************************************************************************
//*
//*  Triggers
//*
//***************************************************************************

//===========================================================================
// Trigger: Init
//===========================================================================
function Trig_Init_Actions takes nothing returns nothing
    call FogEnableOff(  )
    call FogMaskEnableOff(  )
    call DisplayTimedTextToForce( GetPlayersAll(), 600.00, "TRIGSTR_033" )
endfunction

//===========================================================================
function InitTrig_Init takes nothing returns nothing
    set gg_trg_Init = CreateTrigger(  )
    call TriggerAddAction( gg_trg_Init, function Trig_Init_Actions )
endfunction

//===========================================================================
// Trigger: Table
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
library Table
//***************************************************************
//* Table object 3.0
//* ------------
//*
//*   set t=Table.create() - instanceates a new table object
//*   call t.destroy()     - destroys it
//*   t[1234567]           - Get value for key 1234567
//*                          (zero if not assigned previously)
//*   set t[12341]=32      - Assigning it.
//*   call t.flush(12341)  - Flushes the stored value, so it
//*                          doesn't use any more memory
//*   t.exists(32)         - Was key 32 assigned? Notice
//*                          that flush() unassigns values.
//*   call t.reset()       - Flushes the whole contents of the
//*                          Table.
//*
//*   call t.destroy()     - Does reset() and also recycles the id.
//*
//*   If you use HandleTable instead of Table, it is the same
//* but it uses handles as keys, the same with StringTable.
//*
//*  You can use Table on structs' onInit  if the struct is
//* placed in a library that requires Table or outside a library.
//*
//*  You can also do 2D array syntax if you want to touch
//* mission keys directly, however, since this is shared space
//* you may want to prefix your mission keys accordingly:
//*
//*  set Table["thisstring"][ 7 ] = 2
//*  set Table["thisstring"][ 5 ] = Table["thisstring"][7]
//*
//***************************************************************

//=============================================================
    globals
        private constant integer MAX_INSTANCES=8100 //400000
        //Feel free to change max instances if necessary, it will only affect allocation
        //speed which shouldn't matter that much.

    //=========================================================
        private hashtable ht
    endglobals

    private struct GTable[MAX_INSTANCES]

        method reset takes nothing returns nothing
            call FlushChildHashtable(ht, integer(this) )
        endmethod

        private method onDestroy takes nothing returns nothing
            call this.reset()
        endmethod

        //=============================================================
        // initialize it all.
        //
        private static method onInit takes nothing returns nothing
            set ht = InitHashtable()
        endmethod

    endstruct

    //Hey: Don't instanciate other people's textmacros that you are not supposed to, thanks.
    //! textmacro Table__make takes name, type, key
    struct $name$ extends GTable

        method operator [] takes $type$ key returns integer
            return LoadInteger(ht, integer(this), $key$)
        endmethod

        method operator []= takes $type$ key, integer value returns nothing
            call SaveInteger(ht,  integer(this)  ,$key$, value)
        endmethod

        method flush takes $type$ key returns nothing
            call RemoveSavedInteger(ht, integer(this), $key$)
        endmethod

        method exists takes $type$ key returns boolean
            return HaveSavedInteger( ht,  integer(this)  ,$key$)
        endmethod

        static method flush2D takes string firstkey returns nothing
            call $name$(- StringHash(firstkey)).reset()
        endmethod

        static method operator [] takes string firstkey returns $name$
            return $name$(- StringHash(firstkey) )
        endmethod

    endstruct
    //! endtextmacro

    //! runtextmacro Table__make("Table","integer","key" )
    //! runtextmacro Table__make("StringTable","string", "StringHash(key)" )
    //! runtextmacro Table__make("HandleTable","handle","GetHandleId(key)" )

endlibrary
//===========================================================================
// Trigger: TimerUtils
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
library_once TimerUtils initializer init
//*********************************************************************
//* TimerUtils (Blue flavor for 1.23b or later) 
//* ----------
//*
//*  To implement it , create a custom text trigger called TimerUtils
//* and paste the contents of this script there.
//*
//*  To copy from a map to another, copy the trigger holding this
//* library to your map.
//*
//* (requires vJass)   More scripts: htt://www.wc3campaigns.net
//*
//* For your timer needs:
//*  * Attaching
//*  * Recycling (with double-free protection)
//*
//* set t=NewTimer()      : Get a timer (alternative to CreateTimer)
//* ReleaseTimer(t)       : Relese a timer (alt to DestroyTimer)
//* SetTimerData(t,2)     : Attach value 2 to timer
//* GetTimerData(t)       : Get the timer's value.
//*                         You can assume a timer's value is 0
//*                         after NewTimer.
//*
//* Blue Flavor: Slower than the red flavor, it got a 408000 handle id
//*             limit, which means that if more than 408000 handle ids
//*             are used in your map, TimerUtils might fail, this
//*             value is quite big and it is much bigger than the 
//*             timer limit in Red flavor.
//*
//********************************************************************

    //==================================================================================================
    globals
        private hashtable hasht //I <3 blizz
    endglobals

    //It is dependent on jasshelper's recent inlining optimization in order to perform correctly.
    function SetTimerData takes timer t, integer value returns nothing
        call SaveInteger(hasht,0, GetHandleId(t), value)
    endfunction

    function GetTimerData takes timer t returns integer
        return LoadInteger(hasht, 0, GetHandleId(t))
    endfunction

    //==========================================================================================
    globals
        private timer array tT
        private integer tN = 0
        private constant integer HELD=0x28829022
        //use a totally random number here, the more improbable someone uses it, the better.
    endglobals

    //==========================================================================================
    function NewTimer takes nothing returns timer
        if (tN==0) then
            set tT[0]=CreateTimer()
        else
            set tN=tN-1
        endif
        call SetTimerData(tT[tN],0)
     return tT[tN]
    endfunction

    //==========================================================================================
    function ReleaseTimer takes timer t returns nothing
        if(t==null) then
            debug call BJDebugMsg("Warning: attempt to release a null timer")
            return
        endif
        if (tN==8191) then
            debug call BJDebugMsg("Warning: Timer stack is full, destroying timer!!")

            //stack is full, the map already has much more troubles than the chance of bug
            call DestroyTimer(t)
        else
            call PauseTimer(t)
            if(GetTimerData(t)==HELD) then
                debug call BJDebugMsg("Warning: ReleaseTimer: Double free!")
                return
            endif
            call SetTimerData(t,HELD)
            set tT[tN]=t
            set tN=tN+1
        endif    
    endfunction

    private function init takes nothing returns nothing
        set hasht = InitHashtable()
    endfunction

endlibrary//===========================================================================
// Trigger: IntuitiveDamageSystem
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
library IntuitiveDamageSystem initializer Init requires Table
//******************************************************************************
//* BY: Rising_Dusk
//*     (Intuitive) Damage Detection System 1.13
//* 
//* This library is the core for what has come to be known as the Intuitive
//* Damage Detection System, or IDDS for short. Simply by copying this library
//* into your map somewhere, you will have access to all of its features and
//* options. Below this documentation are some global variables that can be
//* edited to make the system more useful for your map, whatever it might be.
//* Please note that you should only change those globals listed under 
//* configuration constants and damage type constants.
//* 
//* An important note for the system is that all non-attack damage in your map
//* MUST BE TRIGGERED using the special function call included in this system,
//* UnitDamageTargetEx. This is how the system works to detect attacks, because
//* if the only non-triggered damage in your map originates from attacks, you
//* clearly know which damage packets are attacks. This allows users to use
//* orb abilities in their maps for whatever they want.
//* 
//*     function UnitDamageTargetEx takes unit source, unit target, real damage, ...
//*     ...attacktype attackType, integer damageType, boolean ConsiderArmor returns boolean
//* 
//* This is the function with which you will deal all triggered damage in your
//* map. The damageType argument is one of the predefined integer constants that
//* you can edit or add below. Default values for this with the system are
//* DAMAGE_TYPE_ATTACK, DAMAGE_TYPE_SPELL, and DAMAGE_TYPE_EXTRA. You can
//* trigger the system to treat triggered damage like it is an attack if you
//* want to by using DAMAGE_TYPE_ATTACK. It is very easy to make new damage
//* types in the system, just follow the instructions in the configuration
//* constants area. In addition, be sure that the constants you define do not
//* conflict with the predefined Blizzard constants. (ie. DAMAGE_TYPE_FIRE) If
//* these conflicts do exist, you will encounter multiply defined syntax errors.
//* The AttackType argument is the same as in the regular UnitDamageTarget
//* native. Also, the system allows you to consider armor when dealing damage or
//* not. Set the ConsiderArmor boolean argument to false if you want to ignore
//* armor for that damage, or true if you want to factor it in.
//* 
//*     function TriggerUnregisterDamageEvent takes trigger trg returns boolean
//*     function TriggerRegisterDamageEvent takes trigger trg, integer priority returns boolean
//* 
//* The TriggerRegisterDamageEvent function is used when initializing a damage
//* detection response trigger. By using this, it allows you to use a syntax
//* structure nigh-identical to the standard JASS2. It returns a boolean for
//* your convenience that is false if you pass it a null trigger. The system
//* also allows you to pass a positive, zero-inclusive integer to it as that
//* trigger's priority. The higher the number you pass, the later on in the
//* trigger executions it will fire. This is useful if you want shield
//* abilities, as you will want their priorities low so that they can block the
//* damage before it gets to other things. You are also allowed to unregister
//* a trigger from the system at any time if you want; this will likely never
//* have to be done for most maps.
//* 
//*     function SetDamage takes real dmg returns nothing
//*     function SetDamageType takes integer dmgtype returns boolean 
//* 
//* With this function, you can modify the damage the system interprets for its
//* triggers. This function DOES NOT ACTUALLY CHANGE THE DAMAGE BEING DEALT, it
//* is merely a tool for users to use to change the internal variables. The user
//* will need to modify the damage himself by some other means. Similarly, the
//* SetDamageType function internally changes the damage type of a given packet
//* of damage. This can be useful if you want to convert DAMAGE_TYPE_ATTACK into
//* something else or if you want dynamic damagetypes in-game.
//* 
//*     function SetTriggerPriority takes trigger trg, integer priority returns boolean
//*     function GetTriggerPriority takes trigger trg returns integer
//* 
//* These functions let you set or get a given trigger's priority at will. These
//* functions both require that the trigger being passed to it is registered to
//* the IDDS system. If you pass an unregistered trigger to GetTriggerPriority,
//* it will return -1. If you pass a similar trigger to SetTriggerPriority, it
//* will return false.
//* 
//*     function IgnoreHigherPriority takes nothing returns boolean
//* 
//* This function is one of the most important reasons for priorities to exist.
//* With it, you can tell the system to ignore higher priority triggers. This
//* is useful, for instance, if you have a triggered evasion ability and don't
//* want anything else to be done with that damage because it was dodged. Other,
//* similar damage-preventing routines will also find this function useful.
//* 
//*     function RegisterDamageType takes nothing returns integer
//* 
//* This function is useful for declaring your own DAMAGE_TYPE_ETC constants
//* external to the system. By declaring your global variable and then calling
//* this on it as follows, you can register new damage types on the fly. This
//* is very useful if you want other systems or spells to introduce new damage
//* types that are either ignored or do special things for that application.
//* 
//*     function GetTriggerDamageType takes nothing returns integer
//*     function GetTriggerDamageSource takes nothing returns unit
//*     function GetTriggerDamageTarget takes nothing returns unit
//*     function GetTriggerDamageBase takes nothing returns real
//*     function GetTriggerDamage takes nothing returns real
//* 
//* Like normal WC3 damage detection, the system has event responses for the
//* damage source, the target of the damage, the amount of damage dealt, and
//* other things. It also permits the detection of damage type, which is
//* something standard WC3 does not have. This lets you create on-attack spells
//* very easily whereas without the system it would be very difficult and
//* computationally costly. GetTriggerDamageBase returns the amount of damage
//* the unit was dealt at the beginning of a given trigger series, whereas
//* GetTriggerDamage returns whatever damage the unit has left to receive, if
//* it has been modified in any way with the SetDamage function mentioned
//* earlier.
//* 
//* Once you understand all of the aforementioned aspects of the system, you're
//* ready to put it to use. I know it can be tricky to require all spells be
//* triggered, but this is the way of many great maps anyways, so such a
//* requirement is not so unreasonable. If you have any questions regarding the
//* system, please go to [url]www.wc3c.net[/url] and send a private message to the account
//* Rising_Dusk and I will respond as soon as I can. This system may only be
//* released at [url]www.wc3c.net[/url] and its existence on any other website is against
//* the author's will.
//* 
//* Enjoy!
//* 
globals
    //* Configuration constants
    private          integer       DamageTypeCount     = 4
    
    //* These are the damagetype constant globals for ease of use
            constant integer       DAMAGE_TYPE_ATTACK  = 0
            constant integer       DAMAGE_TYPE_SPELL   = 1
            constant integer       DAMAGE_TYPE_EXTRA   = 2
            constant integer       DAMAGE_TYPE_IGNORED = 3
    
    //* To add new constants, simply follow the naming convention and increment
    //* the number accordingly. You shouldn't change or remove the first of the
    //* damage types, since it is a special case, but you can change the others
    //* however you'd like.
    
    //* These are static constants used by the system and shouldn't be changed
    private          trigger       RunTrigger          = CreateTrigger()
    private          trigger       AddTrigger          = CreateTrigger()
    private          integer       Count               = 0
    private          Table         TrigTable           = 0
    private          Table         RegiTable           = 0
    private          boolean       IgnPrior            = false
    private          integer array NewDamageType
    private          real    array NewDamage
    private          trigger array Trg
    private          integer array Priority
    
    //* Temporary variables used by the system
    private          unit          DamageSource        = null
    private          unit          DamageTarget        = null
    private          integer       DamageType          = 0
    private          integer       DamageId            = 0
    private          real          DamageBase          = 0.
    private          real          Damage              = 0.
endglobals

//******************************************************************************
//******************************************************************************

//* Returns the integer index of a given handle object (Updated for 1.24)
private function H2I takes handle h returns integer
    return GetHandleId(h)
endfunction

//* Use an insertion sort algorithm to sort the trigger stack based on priority
private function TriggerSort takes nothing returns boolean
    local integer i = 1
    local integer j = 0
    local integer p = 0
    local trigger t = null
    
    loop
        exitwhen i >= Count
        set t = Trg[i]
        set p = Priority[i]
        set j = i-1
        loop 
            exitwhen j < 0 or Priority[j] <= p
            set Priority[j+1]          = Priority[j]
            set Trg[j+1]               = Trg[j]
            set TrigTable[H2I(Trg[j])] = j+1
            set j = j - 1
        endloop
        set Priority[j+1]     = p
        set Trg[j+1]          = t
        set TrigTable[H2I(t)] = j+1
        set i = i + 1
    endloop
    
    set t = null
    return true
endfunction

//******************************************************************************
//******************************************************************************

//* The function to call when you want to end a damage's trigger series
function IgnoreHigherPriority takes nothing returns boolean
    if DamageSource != null then
        //Make sure it was called in the right place
        set IgnPrior = true
    endif
    return IgnPrior
endfunction

//* Changes the base damage for a trigger series on the fly
function SetDamage takes real dmg returns boolean
    if DamageSource != null and dmg >= 0 then
        //Make sure it was called in the right place
        set NewDamage[DamageId] = dmg
        set Damage              = dmg
        return true
    endif
    return false
endfunction

//* Changes the base damage type of the series
function SetDamageType takes integer dmgtype returns boolean
    if DamageSource != null and dmgtype >= 0 then
        //Make sure it was called in the right place
        set NewDamageType[DamageId] = dmgtype
        set DamageType              = dmgtype
        return true
    endif
    return false
endfunction

//* Returns the given trigger's priority if it's loaded to the system
function GetTriggerPriority takes trigger trg returns integer
    if RegiTable[H2I(trg)] == 0 then
        return -1
    endif
    return Priority[TrigTable[H2I(trg)]]
endfunction

//* Sets the given trigger's priority if it's loaded to the system
function SetTriggerPriority takes trigger trg, integer priority returns boolean
    if RegiTable[H2I(trg)] == 0 or priority < 0 then
        return false
    endif
    set Priority[TrigTable[H2I(trg)]] = priority
    return TriggerSort()
endfunction

//******************************************************************************
//******************************************************************************

//* The new damage function used by the system
function UnitDamageTargetEx takes unit source, unit target, real damage, attacktype attackType, integer damageType, boolean ConsiderArmor returns boolean
    local boolean b  = false
    set DamageType   = damageType
    set DamageSource = source
    if ConsiderArmor then
        set b = UnitDamageTarget(source, target, damage, false, false, attackType, DAMAGE_TYPE_NORMAL, null)
    else
        set b = UnitDamageTarget(source, target, damage, false, false, attackType, DAMAGE_TYPE_UNIVERSAL, null)
    endif
    if not b then
        set DamageType = 0
        set DamageSource = null
    endif
    return b
endfunction

//* The method by which one registers a trigger with the system
function TriggerRegisterDamageEvent takes trigger trg, integer priority returns boolean
    if trg == null or priority < 0 then
        return false
    endif
    if RegiTable[H2I(trg)] == 0 then
        set RegiTable[H2I(trg)] = 1
    endif
    set Trg[Count]          = trg
    set Priority[Count]     = priority
    set TrigTable[H2I(trg)] = Count
    set Count               = Count + 1
    return TriggerSort()
endfunction

//* The method by which one unregisters a trigger from the system
function TriggerUnregisterDamageEvent takes trigger trg returns boolean
    local integer i = 0
    if trg == null then
        return false
    endif
    set i = TrigTable[H2I(trg)]
    if trg != Trg[i] then
        return false
    endif
    set Trg[i]                 = Trg[Count]
    set Priority[i]            = Priority[Count]
    set TrigTable[H2I(Trg[i])] = i
    set RegiTable[H2I(trg)]    = 0
    set Count                  = Count - 1
    return TriggerSort()
endfunction

//* Initialization shorthand to register a new damage type externally
function RegisterDamageType takes nothing returns integer
    local integer i = DamageTypeCount
    set DamageTypeCount = DamageTypeCount + 1
    return i
endfunction

//******************************************************************************
//******************************************************************************

//* Wrappers for the system that can get inlined anyways
function GetTriggerDamageType takes nothing returns integer
    return DamageType
endfunction
function GetTriggerDamageSource takes nothing returns unit
    return DamageSource
endfunction
function GetTriggerDamageTarget takes nothing returns unit
    return DamageTarget
endfunction
function GetTriggerDamageBase takes nothing returns real
    return DamageBase
endfunction
function GetTriggerDamage takes nothing returns real
    return Damage
endfunction

//******************************************************************************
//******************************************************************************

private function RunConditions takes nothing returns boolean
    //* The conditions for what must be true for damage detection to run
    return GetEventDamage() >= 0.0001 and DamageType != DAMAGE_TYPE_IGNORED
endfunction

private function AddConditions takes nothing returns boolean
    //* The conditions for registering a unit with the damage system
    return true
endfunction

private function PreloadConditions takes unit u returns boolean
    //* The conditions for preloading a unit to the damage system
    return true
endfunction

//******************************************************************************
//******************************************************************************

globals
    private integer array IDStack
    private integer       IDC     = 0
    private integer       IDN     = 0
endglobals

private function Run takes nothing returns nothing
    local unit    u  = GetEventDamageSource()
    local unit    s  = DamageSource
    local unit    t  = GetTriggerUnit()
    local integer i  = 0
    local integer id = 0
    local integer d  = DamageType
    local real    r  = GetEventDamage()
    local real    b  = r
    
    //Allocate an id for this damage packet
    if IDN > 0 then
        set id  = IDStack[IDN]
        set IDN = IDN - 1
    else
        set id  = IDC
        set IDC = IDC + 1
    endif
    
    if DamageSource == null then
        //Damage is of type attack
        set d = DAMAGE_TYPE_ATTACK
        set s = u
    endif
    loop
        exitwhen i > Count or IgnPrior
        //Ensure all variables are correct for nesting
        set Damage            = r
        set DamageBase        = b
        set DamageTarget      = t
        set DamageSource      = s
        set DamageType        = d
        set DamageId          = id
        set NewDamage[id]     = 0.
        set NewDamageType[id] = -1
        if IsTriggerEnabled(Trg[i]) and TriggerEvaluate(Trg[i]) then
            call TriggerExecute(Trg[i])
        endif
        if NewDamage[id] > 0. then
            //Update damage if it was changed
            set r = NewDamage[id]
        endif
        if NewDamageType[id] >= 0 then
            //Update damagetype if it was changed
            set d = NewDamageType[id]
        endif
        set i = i + 1
    endloop
    set Damage        = 0.
    set DamageBase    = 0.
    set DamageTarget  = null
    set DamageSource  = null
    set DamageType    = 0
    set DamageId      = 0
    set IgnPrior      = false
    set NewDamage[id] = 0.
    
    //Return id to the stack
    set IDN          = IDN + 1
    set IDStack[IDN] = id
    
    set u = null
    set s = null
    set t = null
endfunction

private function Load takes nothing returns nothing
    call TriggerRegisterUnitEvent(RunTrigger, GetEnteringUnit(), EVENT_UNIT_DAMAGED)
endfunction

//******************************************************************************
//******************************************************************************

private function PreloadUnits takes nothing returns boolean
    if PreloadConditions(GetFilterUnit()) then
        call TriggerRegisterUnitEvent(RunTrigger, GetFilterUnit(), EVENT_UNIT_DAMAGED)
    endif
    return false
endfunction

private function Init takes nothing returns nothing
    local rect     r  = GetWorldBounds()
    local region   re = CreateRegion()
    local boolexpr b  = Condition(function PreloadUnits)
    local group    g  = CreateGroup()
    
    //* Create the tables for use with the system
    set TrigTable = Table.create()
    set RegiTable = Table.create()
    
    call TriggerAddAction(RunTrigger, function Run)
    call TriggerAddCondition(RunTrigger, Condition(function RunConditions))
    call GroupEnumUnitsInRect(g, r, b)
    
    call RegionAddRect(re, r)
    call TriggerRegisterEnterRegion(AddTrigger, re, null)
    call TriggerAddAction(AddTrigger, function Load)
    call TriggerAddCondition(AddTrigger, Condition(function AddConditions))
    
    call RemoveRect(r)
    call DestroyGroup(g)
    call DestroyBoolExpr(b)
    set re = null
    set g  = null
    set b  = null
    set r  = null
endfunction
endlibrary
//===========================================================================
// Trigger: Touch of Nature
//===========================================================================
//TESH.scrollpos=24
//TESH.alwaysfold=0
//*******************************************************************************************************************
//* Touch of Nature by xD.Schurke (Zephyr Contest #7 entry)
//* -------------------------------------------------------
//*
//* Requires:
//*          - JassHelper (Latest Version)
//*          - Table 3.0 By Vexorian
//*          - TimerUtils (Blue Flavour) by Vexorian
//*          - IntuitiveDamageSystem 1.13 by Rising_Dusk
//*          - Basis Jass-Knowledge to setup the spell
//*         
//*
//* Other Credits:
//*          - SkriK for the icon
//*
//*
//* About the spell:
//*          Touches an allied unit with the power of nature. The unit regenerates life 
//*          and takes 5% less physical damage. In addition blossoms are spawned for 
//*          5 seconds which can be consumed by anyone. Those blossoms increase the armor 
//*          by 3 and heal the unit over 7.5 seconds for 65 hitpoints.
//*          Level 1 - The touched unit regenerates 100 health points over 10 seconds.
//*          Level 2 - The touched unit regenerates 175 health points over 11 seconds.
//*          Level 3 - The touched unit regenerates 250 health points over 12 seconds.
//*
//*          Cooldown: 15 seconds
//*
//*
//*          - The spell requires some micro to have the optimal use in a battle. 
//*          - The spell is balanced for melee games, only issue is that it uses Inner-Fire buff
//*
//*
//*
//*******************************************************************************************************************
scope TouchOfNature
globals
    //************************************************************************************************
    //* You can change the following variables to fit your needs, or to copy this spell to your map 
    //************************************************************************************************
    
    //*Rawcodes*\\
    private constant    integer         DUMMY_ID                    =   'n001' //Dummy
    private constant    integer         SPELL_ID                    =   'A000' //Spell
    private constant    integer         SPELL_BUFF_ID               =   'B000' //Touch of Nature buff
    private constant    integer         DUMMY_SPELL_ID              =   'A001' //Dummy Spell (Blossoms Gift)
    private constant    integer         DUMMY_SPELL_BUFF_ID         =   'B001' //Blossoms Gift buff
    
    //*Time-related variables*\\
    private constant    real            INTERVAL                    =    0.03125 //Standard timer interval of 32 FPS
    private constant    real            DURATION_BASIS              =   10.00000 //The basis duration of the Touch of Nature buff
    private constant    real            DURATION_BASIS_INC          =    1.00000 //Level duration increase of touch of nature
    private constant    real            DURATION_FLOWER_BASIS       =    5.00000 //Duration of the blossoms (flowers)
    private constant    real            DURATION_FLOWER_BASIS_INC   =    0.00000 //Actually this variable is not needed, but if you want an increase per level, you can change this variable
    private constant    real            GROWTH_DURATION             =    2.00000 //The time in which the flower should grow
    private constant    real            BLOSSOM_DURATION            =    7.50000 //Blossoms Gift buff duration
    
    //*Spell effect variables*\\
    private constant    real            LIFE_REGENERATION           =  100.00000 //The basis life healed of Touch of nature
    private constant    real            LIFE_REGENERATION_INC       =   75.00000 //The level increase of life healed by the spell
    private constant    real            DAMAGE_REDUCE               =    5.00000 //The damage reduction of the spell in percent
    private constant    real            BLOSSOM_HEAL                =   65.00000 //The hitpoints healed by the blossom buff
    
    //*Flower growth stuff*\\
    private constant    real            GROWTH_MAX_SIZE             =    1.00000 //Maximal size of the flower
    private constant    real            GROWTH_START_SIZE           =    0.00 //The start size of the flower
    //!!DO NOT CHANGE!!\\
    private constant    real            GROWTH_VALUE                =   GROWTH_MAX_SIZE/(GROWTH_DURATION/INTERVAL) //How much the flower should grow per interval
    //!!!!!!!!!!!!!!!!!\\
    
    //*Range check variables*\\
    private constant    real            GROWTH_CHECK_RANGE          =   50.00000 //Is used to check if other flowers are grown near the spot
    private constant    real            FLOWER_CHECK_RANGE          =   50.00000 //Is used to find the unit which should be buffed    
    
    private constant    real            GROWTH_ANGLE_RADIUS         =  360.00000 //0 - this angle is used to spawn new flowsers
    
    //*Effect Strings'\\
    private constant    string          FLOWER_DEATH_EFFECT         =   "Abilities\\Spells\\NightElf\\FaerieDragonInvis\\FaerieDragon_Invis.mdl"
    private constant    string          FLOWER_PICK_UP_EFFECT       =   "Abilities\\Spells\\Human\\DispelMagic\\DispelMagicTarget.mdl"
    
    private             string  array   FLOWER_VARIATION                   //This array contains the flower model strings , for more information see setupModelStrings
    private constant    integer         VARIATION_COUNT             =    5 //If u want to add any flower model, or remove any change this variable to the count
    
    //DO NOT change anything bellow this line without any knowledge!
    //Those variables are used for group issues, so the whole spell uses just one group which is only temporaly used
    private             player          tmpP 
    private             unit            tmpU
    private             group           tmpG
    private             boolexpr        FILTER_FLOWER
    private             boolexpr        FILTER_CHECK_FLOWER
endglobals

//This function is used to setup the flower model strings
private function setupModelStrings takes nothing returns nothing
    set FLOWER_VARIATION[0]       =   "Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower0.mdl"
    set FLOWER_VARIATION[1]       =   "Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower1.mdl"
    set FLOWER_VARIATION[2]       =   "Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower2.mdl"
    set FLOWER_VARIATION[3]       =   "Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower3.mdl"
    set FLOWER_VARIATION[4]       =   "Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower4.mdl"
endfunction

//Function for getting the duration of the spell
private function getDuration takes integer lvl returns real
    return DURATION_BASIS+(DURATION_BASIS_INC*(lvl-1))
endfunction
//Function for getting the duration of the flowers
private function getFlowerDuration takes integer lvl returns real
    return DURATION_FLOWER_BASIS+(DURATION_FLOWER_BASIS_INC*(lvl-1))
endfunction
//Function for calculating the healed amount of the main spell
private function getHealMain takes integer lvl returns real
    return (LIFE_REGENERATION+(LIFE_REGENERATION_INC*(lvl-1)))/(getDuration(lvl)/INTERVAL)
endfunction
//Function for calculating the healed amount of the blossoms
private function getHealBlossom takes nothing returns real
    return BLOSSOM_HEAL/(BLOSSOM_DURATION/INTERVAL)
endfunction
//Filter function used to find a unit which can be buffed
private function GroupFilterFlower takes nothing returns boolean
    return GetUnitAbilityLevel(GetFilterUnit(),DUMMY_SPELL_BUFF_ID) == 0 and (GetUnitState(GetFilterUnit(),UNIT_STATE_LIFE)>0) and IsUnitType(GetFilterUnit(),UNIT_TYPE_GROUND) and (GetUnitTypeId(GetFilterUnit())!= DUMMY_ID) and GetFilterUnit() != tmpU
endfunction
//Filter Function used to check if other flowers are arround
private function GroupFilterFlowerCheck takes nothing returns boolean
    local real dx = GetUnitX(GetFilterUnit()) - GetUnitX(tmpU)
    local real dy = GetUnitY(GetFilterUnit()) - GetUnitY(tmpU)
    return GetUnitState(GetFilterUnit(),UNIT_STATE_LIFE) > 0 and GetUnitTypeId(GetFilterUnit())== DUMMY_ID and SquareRoot(dx * dx + dy * dy) < GROWTH_CHECK_RANGE
endfunction
//Keyword since I decided to declare the FlowerStruct after the MainStruct
private keyword FlowerStruct

//This struct is the one handeling the main part, also this struct contains the initializer method (onInit)
private struct MainStruct
    private         unit        caster      =   null 
    private         unit        target      =   null
    private         real        duration    =   0.0
    //method to check the surrounding area for other flowers
    private method checkFlowers takes nothing returns boolean
        local real x = GetUnitX(this.caster)
        local real y = GetUnitY(this.caster)
        set tmpP = GetOwningPlayer(this.target)
        set tmpU = this.target
        call GroupEnumUnitsOfPlayer(tmpG,tmpP,FILTER_CHECK_FLOWER)
        if FirstOfGroup(tmpG) != null then
            call GroupClear(tmpG)
            return false
        endif
        return true
    endmethod
    //The callback method which is called each interval, heals the target of the spell and copes the flower growth
    private static method callback takes nothing returns nothing
        local timer         tim  = GetExpiredTimer()
        local thistype      this = GetTimerData(tim)
        local real          x    = 0.0
        local real          y    = 0.0
        local real          life = GetUnitState(this.target,UNIT_STATE_LIFE)
        set this.duration    = this.duration + INTERVAL
        call SetUnitState(this.target,UNIT_STATE_LIFE,life+getHealMain(GetUnitAbilityLevel(this.caster,SPELL_ID)))
        if this.checkFlowers() then
            set x = GetUnitX(this.target) + GetRandomReal(0.0,GROWTH_CHECK_RANGE) * Cos(GetRandomReal(0.0,GROWTH_ANGLE_RADIUS) * bj_DEGTORAD)
            set y = GetUnitY(this.target) + GetRandomReal(0.0,GROWTH_CHECK_RANGE) * Sin(GetRandomReal(0.0,GROWTH_ANGLE_RADIUS) * bj_DEGTORAD)
            call FlowerStruct.create(this.caster,this.target,x,y)
        endif
        if this.duration >= getDuration(GetUnitAbilityLevel(this.caster,SPELL_ID)) or GetUnitAbilityLevel(this.target,SPELL_BUFF_ID) == 0 then
            call ReleaseTimer(tim)
            call this.destroy()
        endif
        set tim = null
    endmethod
    
    static method create takes unit caster ,unit target returns thistype
        local thistype this = thistype.allocate()
        local timer tim = NewTimer()
        set this.caster = caster
        set this.target = target
        call SetTimerData(tim,this)
        call TimerStart(tim,INTERVAL,true,function thistype.callback)
        return this
    endmethod
    
    private method onDestroy takes nothing returns nothing
        set this.caster = null
        set this.target = null
    endmethod
    //The following part is used to setup stuff like damage reduction and general struct creation on spell cast
    private static method condition takes nothing returns boolean
        if GetSpellAbilityId() == SPELL_ID then
            call thistype.create(GetTriggerUnit(),GetSpellTargetUnit())
        endif
        return false
    endmethod
    
    private static method damageCondition takes nothing returns boolean
        if GetUnitAbilityLevel(GetTriggerDamageTarget(),SPELL_BUFF_ID) > 0 and GetTriggerDamageType() == DAMAGE_TYPE_ATTACK then
            call SetUnitState(GetTriggerDamageTarget(),UNIT_STATE_LIFE,GetUnitState(GetTriggerDamageTarget(),UNIT_STATE_LIFE)+GetTriggerDamage()*DAMAGE_REDUCE)
        endif
        return false
    endmethod
    
    private static method onInit takes nothing returns nothing
        local trigger trig = CreateTrigger()
        local trigger damageTrig = CreateTrigger()
        call setupModelStrings()
        set  tmpG                =  CreateGroup()
        set  FILTER_FLOWER       =  Condition(function GroupFilterFlower)
        set  FILTER_CHECK_FLOWER =  Condition(function GroupFilterFlowerCheck)
        
        call TriggerRegisterAnyUnitEventBJ(trig,EVENT_PLAYER_UNIT_SPELL_EFFECT)
        call TriggerAddCondition(trig,Condition(function thistype.condition))
        
        call TriggerAddCondition(damageTrig,Condition(function thistype.damageCondition))        
        call TriggerRegisterDamageEvent(damageTrig,0)
        set trig = null
    endmethod
endstruct
//This is just a small struct healing the target of a blossom buff, does nothing else
private struct BlossomStruct
    private unit    target      =   null
    private real    duration    =   0.0     
    
    private static method callback takes nothing returns nothing
        local timer         tim  = GetExpiredTimer()
        local thistype      this = GetTimerData(tim)
        local real          life = GetUnitState(this.target,UNIT_STATE_LIFE)
        set this.duration    = this.duration + INTERVAL
        call SetUnitState(this.target,UNIT_STATE_LIFE,life+getHealBlossom())
        if this.duration >= BLOSSOM_DURATION or GetUnitAbilityLevel(this.target,DUMMY_SPELL_BUFF_ID) == 0 then
            call ReleaseTimer(tim)
            call this.destroy()
        endif
        set tim = null
    endmethod
    
    private method onDestroy takes nothing returns nothing
        set this.target = null
    endmethod

    static method create takes unit target returns thistype
        local thistype this = thistype.allocate()
        local timer tim = NewTimer()
        set this.target = target
        call SetTimerData(tim,this)
        call TimerStart(tim,INTERVAL,true,function thistype.callback)
        return this
    endmethod    
endstruct

//The FlowerStruct represents Flower/Blossom objects, it actually checks in the callback method for units arround which can be buffed, and then
//applies the buff to them, look a bit more into it to get a basic knowledge of what I am doing here
private struct FlowerStruct
    private unit    caster      =   null
    private unit    target      =   null
    private unit    dummy       =   null
    private effect  attachement =   null
    private real    duration    =   0.0
    private real    actualSize  =   GROWTH_START_SIZE    
    
    private method checkRange takes nothing returns boolean
        local real x = GetUnitX(this.dummy)
        local real y = GetUnitY(this.dummy)
        local unit pickedUnit = null
        set tmpU = this.target
        set tmpP = GetOwningPlayer(this.target)
        call GroupEnumUnitsInRange(tmpG,x,y,FLOWER_CHECK_RANGE,FILTER_FLOWER)
        if FirstOfGroup(tmpG) != null then
            set pickedUnit = FirstOfGroup(tmpG)
            call UnitAddAbility(this.dummy,DUMMY_SPELL_ID)
            call IssueTargetOrder(this.dummy,"innerfire",pickedUnit)
            call BlossomStruct.create(pickedUnit)
            call GroupClear(tmpG)
            return true
        endif
        call GroupClear(tmpG)
        return false
    endmethod
    
    private static method callback takes nothing returns nothing
        local timer         tim  = GetExpiredTimer()
        local thistype      this = GetTimerData(tim)
        set this.duration = this.duration + INTERVAL
        if this.duration < GROWTH_DURATION then
            set this.actualSize = this.actualSize + GROWTH_VALUE
            call SetUnitScale(this.dummy,this.actualSize,this.actualSize,this.actualSize)
        endif
        if this.checkRange() then
            call DestroyEffect(AddSpecialEffect(FLOWER_PICK_UP_EFFECT,GetUnitX(this.dummy),GetUnitY(this.dummy)))
            call ReleaseTimer(tim)
            call this.destroy()
        elseif this.duration >= getFlowerDuration(GetUnitAbilityLevel(this.caster,SPELL_ID)) then
            call DestroyEffect(AddSpecialEffect(FLOWER_DEATH_EFFECT,GetUnitX(this.dummy),GetUnitY(this.dummy)))
            call ReleaseTimer(tim)
            call this.destroy()
        endif
        set tim = null
    endmethod
    
    static method create takes unit caster, unit target, real x, real y returns thistype
        local thistype this = thistype.allocate()
        local timer tim = NewTimer()
        set this.caster = caster
        set this.target = target
        set this.dummy = CreateUnit(GetOwningPlayer(this.target),DUMMY_ID,x,y,0.0)
        call SetUnitTimeScale(this.dummy,0.0)
        call SetUnitScale(this.dummy,GROWTH_START_SIZE,GROWTH_START_SIZE,GROWTH_START_SIZE)
        call AddSpecialEffectTarget(FLOWER_VARIATION[GetRandomInt(0,VARIATION_COUNT-1)],this.dummy,"origin")
        call SetTimerData(tim,this)
        call TimerStart(tim,INTERVAL,true,function thistype.callback)
        return this
    endmethod
    
    private method onDestroy takes nothing returns nothing
        call DestroyEffect(this.attachement)
        call RemoveUnit(this.dummy)
        set this.attachement = null
        set this.dummy = null
        set this.caster = null
        set this.target = null
    endmethod
endstruct
endscope//===========================================================================
function InitCustomTriggers takes nothing returns nothing
    call InitTrig_Init(  )
    call InitTrig_Table(  )
    call InitTrig_TimerUtils(  )
    call InitTrig_IntuitiveDamageSystem(  )
    call InitTrig_Touch_of_Nature(  )
endfunction

//===========================================================================
function RunInitializationTriggers takes nothing returns nothing
    call ConditionalTriggerExecute( gg_trg_Init )
endfunction

//***************************************************************************
//*
//*  Players
//*
//***************************************************************************

function InitCustomPlayerSlots takes nothing returns nothing

    // Player 0
    call SetPlayerStartLocation( Player(0), 0 )
    call SetPlayerColor( Player(0), ConvertPlayerColor(0) )
    call SetPlayerRacePreference( Player(0), RACE_PREF_HUMAN )
    call SetPlayerRaceSelectable( Player(0), true )
    call SetPlayerController( Player(0), MAP_CONTROL_USER )

endfunction

function InitCustomTeams takes nothing returns nothing
    // Force: TRIGSTR_002
    call SetPlayerTeam( Player(0), 0 )

endfunction

//***************************************************************************
//*
//*  Main Initialization
//*
//***************************************************************************

//===========================================================================
function main takes nothing returns nothing
    call SetCameraBounds( -1280.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), -1536.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM), 1280.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), 1024.0 - GetCameraMargin(CAMERA_MARGIN_TOP), -1280.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), 1024.0 - GetCameraMargin(CAMERA_MARGIN_TOP), 1280.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), -1536.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM) )
    call SetDayNightModels( "Environment\\DNC\\DNCAshenvale\\DNCAshenvaleTerrain\\DNCAshenvaleTerrain.mdl", "Environment\\DNC\\DNCAshenvale\\DNCAshenvaleUnit\\DNCAshenvaleUnit.mdl" )
    call NewSoundEnvironment( "Default" )
    call SetAmbientDaySound( "AshenvaleDay" )
    call SetAmbientNightSound( "AshenvaleNight" )
    call SetMapMusic( "Music", true, 0 )
    call CreateAllUnits(  )
    call InitBlizzard(  )
    call InitGlobals(  )
    call InitCustomTriggers(  )
    call RunInitializationTriggers(  )

endfunction

//***************************************************************************
//*
//*  Map Configuration
//*
//***************************************************************************

function config takes nothing returns nothing
    call SetMapName( "TRIGSTR_029" )
    call SetMapDescription( "TRIGSTR_031" )
    call SetPlayers( 1 )
    call SetTeams( 1 )
    call SetGamePlacement( MAP_PLACEMENT_USE_MAP_SETTINGS )

    call DefineStartLocation( 0, 0.0, -64.0 )

    // Player setup
    call InitCustomPlayerSlots(  )
    call SetPlayerSlotAvailable( Player(0), MAP_CONTROL_USER )
    call InitGenericPlayerSlots(  )
endfunction

