globals
//globals from Table:
constant boolean LIBRARY_Table=true
        constant integer Table__MAX_INSTANCES=8100 //400000
        //Feel free to change max instances if necessary, it will only affect allocation
        //speed which shouldn't matter that much.

    //=========================================================
        hashtable Table__ht
//endglobals from Table
//globals from TimerUtils:
constant boolean LIBRARY_TimerUtils=true
        hashtable TimerUtils__hasht //I <3 blizz
        timer array TimerUtils__tT
        integer TimerUtils__tN = 0
        constant integer TimerUtils__HELD=0x28829022
        //use a totally random number here, the more improbable someone uses it, the better.
//endglobals from TimerUtils
//globals from IntuitiveDamageSystem:
constant boolean LIBRARY_IntuitiveDamageSystem=true
    //* Configuration constants
             integer       IntuitiveDamageSystem__DamageTypeCount     = 4
    
    //* These are the damagetype constant globals for ease of use
            constant integer       DAMAGE_TYPE_ATTACK  = 0
            constant integer       DAMAGE_TYPE_SPELL   = 1
            constant integer       DAMAGE_TYPE_EXTRA   = 2
            constant integer       DAMAGE_TYPE_IGNORED = 3
    
    //* To add new constants, simply follow the naming convention and increment
    //* the number accordingly. You shouldn't change or remove the first of the
    //* damage types, since it is a special case, but you can change the others
    //* however you'd like.
    
    //* These are static constants used by the system and shouldn't be changed
             trigger       IntuitiveDamageSystem__RunTrigger          = CreateTrigger()
             trigger       IntuitiveDamageSystem__AddTrigger          = CreateTrigger()
             integer       IntuitiveDamageSystem__Count               = 0
integer IntuitiveDamageSystem__TrigTable= 0
integer IntuitiveDamageSystem__RegiTable= 0
             boolean       IntuitiveDamageSystem__IgnPrior            = false
             integer array IntuitiveDamageSystem__NewDamageType
             real    array IntuitiveDamageSystem__NewDamage
             trigger array IntuitiveDamageSystem__Trg
             integer array IntuitiveDamageSystem__Priority
    
    //* Temporary variables used by the system
             unit          IntuitiveDamageSystem__DamageSource        = null
             unit          IntuitiveDamageSystem__DamageTarget        = null
             integer       IntuitiveDamageSystem__DamageType          = 0
             integer       IntuitiveDamageSystem__DamageId            = 0
             real          IntuitiveDamageSystem__DamageBase          = 0.
             real          IntuitiveDamageSystem__Damage              = 0.
    integer array IntuitiveDamageSystem__IDStack
    integer       IntuitiveDamageSystem__IDC     = 0
    integer       IntuitiveDamageSystem__IDN     = 0
//endglobals from IntuitiveDamageSystem
    // Generated
    trigger                 gg_trg_Init                = null
    trigger                 gg_trg_Table               = null
    trigger                 gg_trg_TimerUtils          = null
    trigger                 gg_trg_IntuitiveDamageSystem = null
    trigger                 gg_trg_Touch_of_Nature     = null
    //************************************************************************************************
    //* You can change the following variables to fit your needs, or to copy this spell to your map 
    //************************************************************************************************
    
    //*Rawcodes*\\
    constant    integer         TouchOfNature__DUMMY_ID                    =   'n001' //Dummy
    constant    integer         TouchOfNature__SPELL_ID                    =   'A000' //Spell
    constant    integer         TouchOfNature__SPELL_BUFF_ID               =   'B000' //Touch of Nature buff
    constant    integer         TouchOfNature__DUMMY_SPELL_ID              =   'A001' //Dummy Spell (Blossoms Gift)
    constant    integer         TouchOfNature__DUMMY_SPELL_BUFF_ID         =   'B001' //Blossoms Gift buff
    
    //*Time-related variables*\\
    constant    real            TouchOfNature__INTERVAL                    =    0.03125 //Standard timer interval of 32 FPS
    constant    real            TouchOfNature__DURATION_BASIS              =   10.00000 //The basis duration of the Touch of Nature buff
    constant    real            TouchOfNature__DURATION_BASIS_INC          =    1.00000 //Level duration increase of touch of nature
    constant    real            TouchOfNature__DURATION_FLOWER_BASIS       =    5.00000 //Duration of the blossoms (flowers)
    constant    real            TouchOfNature__DURATION_FLOWER_BASIS_INC   =    0.00000 //Actually this variable is not needed, but if you want an increase per level, you can change this variable
    constant    real            TouchOfNature__GROWTH_DURATION             =    2.00000 //The time in which the flower should grow
    constant    real            TouchOfNature__BLOSSOM_DURATION            =    7.50000 //Blossoms Gift buff duration
    
    //*Spell effect variables*\\
    constant    real            TouchOfNature__LIFE_REGENERATION           =  100.00000 //The basis life healed of Touch of nature
    constant    real            TouchOfNature__LIFE_REGENERATION_INC       =   75.00000 //The level increase of life healed by the spell
    constant    real            TouchOfNature__DAMAGE_REDUCE               =    5.00000 //The damage reduction of the spell in percent
    constant    real            TouchOfNature__BLOSSOM_HEAL                =   65.00000 //The hitpoints healed by the blossom buff
    
    //*Flower growth stuff*\\
    constant    real            TouchOfNature__GROWTH_MAX_SIZE             =    1.00000 //Maximal size of the flower
    constant    real            TouchOfNature__GROWTH_START_SIZE           =    0.00 //The start size of the flower
    //!!DO NOT CHANGE!!\\
    constant    real            TouchOfNature__GROWTH_VALUE                =   TouchOfNature__GROWTH_MAX_SIZE/(TouchOfNature__GROWTH_DURATION/TouchOfNature__INTERVAL) //How much the flower should grow per interval
    //!!!!!!!!!!!!!!!!!\\
    
    //*Range check variables*\\
    constant    real            TouchOfNature__GROWTH_CHECK_RANGE          =   50.00000 //Is used to check if other flowers are grown near the spot
    constant    real            TouchOfNature__FLOWER_CHECK_RANGE          =   50.00000 //Is used to find the unit which should be buffed    
    
    constant    real            TouchOfNature__GROWTH_ANGLE_RADIUS         =  360.00000 //0 - this angle is used to spawn new flowsers
    
    //*Effect Strings'\\
    constant    string          TouchOfNature__FLOWER_DEATH_EFFECT         =   "Abilities\\Spells\\NightElf\\FaerieDragonInvis\\FaerieDragon_Invis.mdl"
    constant    string          TouchOfNature__FLOWER_PICK_UP_EFFECT       =   "Abilities\\Spells\\Human\\DispelMagic\\DispelMagicTarget.mdl"
    
                string  array   TouchOfNature__FLOWER_VARIATION                   //This array contains the flower model strings , for more information see setupModelStrings
    constant    integer         TouchOfNature__VARIATION_COUNT             =    5 //If u want to add any flower model, or remove any change this variable to the count
    
    //DO NOT change anything bellow this line without any knowledge!
    //Those variables are used for group issues, so the whole spell uses just one group which is only temporaly used
                player          TouchOfNature__tmpP 
                unit            TouchOfNature__tmpU
                group           TouchOfNature__tmpG
                boolexpr        TouchOfNature__FILTER_FLOWER
                boolexpr        TouchOfNature__FILTER_CHECK_FLOWER

trigger l__library_init

//JASSHelper struct globals:
constant integer si__Table__GTable=1
integer si__Table__GTable_F=0 //MOOOO
integer si__Table__GTable_I=0
integer array si__Table__GTable_V
constant integer si__Table=2
constant integer si__StringTable=3
constant integer si__HandleTable=4
constant integer si__TouchOfNature__MainStruct=5
integer si__TouchOfNature__MainStruct_F=0 //MOOOO
integer si__TouchOfNature__MainStruct_I=0
integer array si__TouchOfNature__MainStruct_V
unit array s__TouchOfNature__MainStruct_caster
unit array s__TouchOfNature__MainStruct_target
real array s__TouchOfNature__MainStruct_duration
constant integer si__TouchOfNature__BlossomStruct=6
integer si__TouchOfNature__BlossomStruct_F=0 //MOOOO
integer si__TouchOfNature__BlossomStruct_I=0
integer array si__TouchOfNature__BlossomStruct_V
unit array s__TouchOfNature__BlossomStruct_target
real array s__TouchOfNature__BlossomStruct_duration
constant integer si__TouchOfNature__FlowerStruct=7
integer si__TouchOfNature__FlowerStruct_F=0 //MOOOO
integer si__TouchOfNature__FlowerStruct_I=0
integer array si__TouchOfNature__FlowerStruct_V
unit array s__TouchOfNature__FlowerStruct_caster
unit array s__TouchOfNature__FlowerStruct_target
unit array s__TouchOfNature__FlowerStruct_dummy
effect array s__TouchOfNature__FlowerStruct_attachement
real array s__TouchOfNature__FlowerStruct_duration
real array s__TouchOfNature__FlowerStruct_actualSize
integer array si__Table__GTable_type
trigger array st__Table__GTable_onDestroy
trigger st__TouchOfNature__MainStruct_onDestroy
trigger st__TouchOfNature__MainStruct_destroy
trigger st__TouchOfNature__BlossomStruct_onDestroy
trigger st__TouchOfNature__BlossomStruct_destroy
trigger st__TouchOfNature__FlowerStruct_create
trigger st__TouchOfNature__FlowerStruct_onDestroy
trigger st__TouchOfNature__FlowerStruct_destroy
unit f__arg_unit1
unit f__arg_unit2
real f__arg_real1
real f__arg_real2
integer f__arg_this
integer f__result_integer

endglobals


//Generated method caller for Table__GTable.onDestroy
function sc__Table__GTable_onDestroy takes integer this returns nothing
    set f__arg_this=this
    call TriggerEvaluate(st__Table__GTable_onDestroy[1])
endfunction

//Generated allocator of Table__GTable
function s__Table__GTable__allocate takes nothing returns integer
 local integer this=si__Table__GTable_F
    if (this!=0) then
        set si__Table__GTable_F=si__Table__GTable_V[this]
    else
        set si__Table__GTable_I=si__Table__GTable_I+1
        set this=si__Table__GTable_I
    endif
    if (this>8100) then
        return 0
    endif

    set si__Table__GTable_type[this]=1
    set si__Table__GTable_V[this]=-1
 return this
endfunction

//Generated destructor of Table__GTable
function sc__Table__GTable_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__Table__GTable_V[this]!=-1) then
        return
    endif
    set f__arg_this=this
    call TriggerEvaluate(st__Table__GTable_onDestroy[si__Table__GTable_type[this]])
    set si__Table__GTable_V[this]=si__Table__GTable_F
    set si__Table__GTable_F=this
endfunction

//Generated method caller for TouchOfNature__FlowerStruct.create
function sc__TouchOfNature__FlowerStruct_create takes unit caster,unit target,real x,real y returns integer
    set f__arg_unit1=caster
    set f__arg_unit2=target
    set f__arg_real1=x
    set f__arg_real2=y
    call TriggerEvaluate(st__TouchOfNature__FlowerStruct_create)
 return f__result_integer
endfunction

//Generated method caller for TouchOfNature__FlowerStruct.onDestroy
function sc__TouchOfNature__FlowerStruct_onDestroy takes integer this returns nothing
        call DestroyEffect(s__TouchOfNature__FlowerStruct_attachement[this])
        call RemoveUnit(s__TouchOfNature__FlowerStruct_dummy[this])
        set s__TouchOfNature__FlowerStruct_attachement[this]=null
        set s__TouchOfNature__FlowerStruct_dummy[this]=null
        set s__TouchOfNature__FlowerStruct_caster[this]=null
        set s__TouchOfNature__FlowerStruct_target[this]=null
endfunction

//Generated allocator of TouchOfNature__FlowerStruct
function s__TouchOfNature__FlowerStruct__allocate takes nothing returns integer
 local integer this=si__TouchOfNature__FlowerStruct_F
    if (this!=0) then
        set si__TouchOfNature__FlowerStruct_F=si__TouchOfNature__FlowerStruct_V[this]
    else
        set si__TouchOfNature__FlowerStruct_I=si__TouchOfNature__FlowerStruct_I+1
        set this=si__TouchOfNature__FlowerStruct_I
    endif
    if (this>8190) then
        return 0
    endif

   set s__TouchOfNature__FlowerStruct_caster[this]=   null
   set s__TouchOfNature__FlowerStruct_target[this]=   null
   set s__TouchOfNature__FlowerStruct_dummy[this]=   null
   set s__TouchOfNature__FlowerStruct_attachement[this]=   null
   set s__TouchOfNature__FlowerStruct_duration[this]=   0.0
   set s__TouchOfNature__FlowerStruct_actualSize[this]=   TouchOfNature__GROWTH_START_SIZE
    set si__TouchOfNature__FlowerStruct_V[this]=-1
 return this
endfunction

//Generated destructor of TouchOfNature__FlowerStruct
function sc__TouchOfNature__FlowerStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__FlowerStruct_V[this]!=-1) then
        return
    endif
    set f__arg_this=this
    call TriggerEvaluate(st__TouchOfNature__FlowerStruct_onDestroy)
    set si__TouchOfNature__FlowerStruct_V[this]=si__TouchOfNature__FlowerStruct_F
    set si__TouchOfNature__FlowerStruct_F=this
endfunction

//Generated method caller for TouchOfNature__BlossomStruct.onDestroy
function sc__TouchOfNature__BlossomStruct_onDestroy takes integer this returns nothing
        set s__TouchOfNature__BlossomStruct_target[this]=null
endfunction

//Generated allocator of TouchOfNature__BlossomStruct
function s__TouchOfNature__BlossomStruct__allocate takes nothing returns integer
 local integer this=si__TouchOfNature__BlossomStruct_F
    if (this!=0) then
        set si__TouchOfNature__BlossomStruct_F=si__TouchOfNature__BlossomStruct_V[this]
    else
        set si__TouchOfNature__BlossomStruct_I=si__TouchOfNature__BlossomStruct_I+1
        set this=si__TouchOfNature__BlossomStruct_I
    endif
    if (this>8190) then
        return 0
    endif

   set s__TouchOfNature__BlossomStruct_target[this]=   null
   set s__TouchOfNature__BlossomStruct_duration[this]=   0.0
    set si__TouchOfNature__BlossomStruct_V[this]=-1
 return this
endfunction

//Generated destructor of TouchOfNature__BlossomStruct
function sc__TouchOfNature__BlossomStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__BlossomStruct_V[this]!=-1) then
        return
    endif
    set f__arg_this=this
    call TriggerEvaluate(st__TouchOfNature__BlossomStruct_onDestroy)
    set si__TouchOfNature__BlossomStruct_V[this]=si__TouchOfNature__BlossomStruct_F
    set si__TouchOfNature__BlossomStruct_F=this
endfunction

//Generated method caller for TouchOfNature__MainStruct.onDestroy
function sc__TouchOfNature__MainStruct_onDestroy takes integer this returns nothing
        set s__TouchOfNature__MainStruct_caster[this]=null
        set s__TouchOfNature__MainStruct_target[this]=null
endfunction

//Generated allocator of TouchOfNature__MainStruct
function s__TouchOfNature__MainStruct__allocate takes nothing returns integer
 local integer this=si__TouchOfNature__MainStruct_F
    if (this!=0) then
        set si__TouchOfNature__MainStruct_F=si__TouchOfNature__MainStruct_V[this]
    else
        set si__TouchOfNature__MainStruct_I=si__TouchOfNature__MainStruct_I+1
        set this=si__TouchOfNature__MainStruct_I
    endif
    if (this>8190) then
        return 0
    endif

   set s__TouchOfNature__MainStruct_caster[this]=   null
   set s__TouchOfNature__MainStruct_target[this]=   null
   set s__TouchOfNature__MainStruct_duration[this]=   0.0
    set si__TouchOfNature__MainStruct_V[this]=-1
 return this
endfunction

//Generated destructor of TouchOfNature__MainStruct
function sc__TouchOfNature__MainStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__MainStruct_V[this]!=-1) then
        return
    endif
    set f__arg_this=this
    call TriggerEvaluate(st__TouchOfNature__MainStruct_onDestroy)
    set si__TouchOfNature__MainStruct_V[this]=si__TouchOfNature__MainStruct_F
    set si__TouchOfNature__MainStruct_F=this
endfunction

//Generated allocator of HandleTable
function s__HandleTable__allocate takes nothing returns integer
 local integer this=s__Table__GTable__allocate()
 local integer kthis
    if(this==0) then
        return 0
    endif
    set si__Table__GTable_type[this]=4
    set kthis=this

 return this
endfunction


//Generated allocator of StringTable
function s__StringTable__allocate takes nothing returns integer
 local integer this=s__Table__GTable__allocate()
 local integer kthis
    if(this==0) then
        return 0
    endif
    set si__Table__GTable_type[this]=3
    set kthis=this

 return this
endfunction


//Generated allocator of Table
function s__Table__allocate takes nothing returns integer
 local integer this=s__Table__GTable__allocate()
 local integer kthis
    if(this==0) then
        return 0
    endif
    set si__Table__GTable_type[this]=2
    set kthis=this

 return this
endfunction


//library Table:
//***************************************************************
//* Table object 3.0
//* ------------
//*
//*   set t=Table.create() - instanceates a new table object
//*   call t.destroy()     - destroys it
//*   t[1234567]           - Get value for key 1234567
//*                          (zero if not assigned previously)
//*   set t[12341]=32      - Assigning it.
//*   call t.flush(12341)  - Flushes the stored value, so it
//*                          doesn't use any more memory
//*   t.exists(32)         - Was key 32 assigned? Notice
//*                          that flush() unassigns values.
//*   call t.reset()       - Flushes the whole contents of the
//*                          Table.
//*
//*   call t.destroy()     - Does reset() and also recycles the id.
//*
//*   If you use HandleTable instead of Table, it is the same
//* but it uses handles as keys, the same with StringTable.
//*
//*  You can use Table on structs' onInit  if the struct is
//* placed in a library that requires Table or outside a library.
//*
//*  You can also do 2D array syntax if you want to touch
//* mission keys directly, however, since this is shared space
//* you may want to prefix your mission keys accordingly:
//*
//*  set Table["thisstring"][ 7 ] = 2
//*  set Table["thisstring"][ 5 ] = Table["thisstring"][7]
//*
//***************************************************************

//=============================================================


        function s__Table__GTable_reset takes integer this returns nothing
            call FlushChildHashtable(Table__ht, (this))
        endfunction

        function s__Table__GTable_onDestroy takes integer this returns nothing
            call FlushChildHashtable(Table__ht, ((this))) // INLINED!!
        endfunction

        //=============================================================
        // initialize it all.
        //
        function s__Table__GTable_onInit takes nothing returns nothing
            set Table__ht=InitHashtable()
        endfunction


    //Hey: Don't instanciate other people's textmacros that you are not supposed to, thanks.

//textmacro instance: Table__make("Table","integer","key" )

        function s__Table__getindex takes integer this,integer key returns integer
            return LoadInteger(Table__ht, (this), key)
        endfunction

        function s__Table__setindex takes integer this,integer key,integer value returns nothing
            call SaveInteger(Table__ht, (this), key, value)
        endfunction

        function s__Table_flush takes integer this,integer key returns nothing
            call RemoveSavedInteger(Table__ht, (this), key)
        endfunction

        function s__Table_exists takes integer this,integer key returns boolean
            return HaveSavedInteger(Table__ht, (this), key)
        endfunction

        function s__Table_flush2D takes string firstkey returns nothing
            call FlushChildHashtable(Table__ht, (((- StringHash(firstkey))))) // INLINED!!
        endfunction

        function s__Table__staticgetindex takes string firstkey returns integer
            return (- StringHash(firstkey))
        endfunction

//end of: Table__make("Table","integer","key" )
//textmacro instance: Table__make("StringTable","string", "StringHash(key)" )

        function s__StringTable__getindex takes integer this,string key returns integer
            return LoadInteger(Table__ht, (this), StringHash(key))
        endfunction

        function s__StringTable__setindex takes integer this,string key,integer value returns nothing
            call SaveInteger(Table__ht, (this), StringHash(key), value)
        endfunction

        function s__StringTable_flush takes integer this,string key returns nothing
            call RemoveSavedInteger(Table__ht, (this), StringHash(key))
        endfunction

        function s__StringTable_exists takes integer this,string key returns boolean
            return HaveSavedInteger(Table__ht, (this), StringHash(key))
        endfunction

        function s__StringTable_flush2D takes string firstkey returns nothing
            call FlushChildHashtable(Table__ht, (((- StringHash(firstkey))))) // INLINED!!
        endfunction

        function s__StringTable__staticgetindex takes string firstkey returns integer
            return (- StringHash(firstkey))
        endfunction

//end of: Table__make("StringTable","string", "StringHash(key)" )
//textmacro instance: Table__make("HandleTable","handle","GetHandleId(key)" )

        function s__HandleTable__getindex takes integer this,handle key returns integer
            return LoadInteger(Table__ht, (this), GetHandleId(key))
        endfunction

        function s__HandleTable__setindex takes integer this,handle key,integer value returns nothing
            call SaveInteger(Table__ht, (this), GetHandleId(key), value)
        endfunction

        function s__HandleTable_flush takes integer this,handle key returns nothing
            call RemoveSavedInteger(Table__ht, (this), GetHandleId(key))
        endfunction

        function s__HandleTable_exists takes integer this,handle key returns boolean
            return HaveSavedInteger(Table__ht, (this), GetHandleId(key))
        endfunction

        function s__HandleTable_flush2D takes string firstkey returns nothing
            call FlushChildHashtable(Table__ht, (((- StringHash(firstkey))))) // INLINED!!
        endfunction

        function s__HandleTable__staticgetindex takes string firstkey returns integer
            return (- StringHash(firstkey))
        endfunction

//end of: Table__make("HandleTable","handle","GetHandleId(key)" )


//library Table ends
//library TimerUtils:
//*********************************************************************
//* TimerUtils (Blue flavor for 1.23b or later) 
//* ----------
//*
//*  To implement it , create a custom text trigger called TimerUtils
//* and paste the contents of this script there.
//*
//*  To copy from a map to another, copy the trigger holding this
//* library to your map.
//*
//* (requires vJass)   More scripts: htt://www.wc3campaigns.net
//*
//* For your timer needs:
//*  * Attaching
//*  * Recycling (with double-free protection)
//*
//* set t=NewTimer()      : Get a timer (alternative to CreateTimer)
//* ReleaseTimer(t)       : Relese a timer (alt to DestroyTimer)
//* SetTimerData(t,2)     : Attach value 2 to timer
//* GetTimerData(t)       : Get the timer's value.
//*                         You can assume a timer's value is 0
//*                         after NewTimer.
//*
//* Blue Flavor: Slower than the red flavor, it got a 408000 handle id
//*             limit, which means that if more than 408000 handle ids
//*             are used in your map, TimerUtils might fail, this
//*             value is quite big and it is much bigger than the 
//*             timer limit in Red flavor.
//*
//********************************************************************

    //==================================================================================================

    //It is dependent on jasshelper's recent inlining optimization in order to perform correctly.
    function SetTimerData takes timer t,integer value returns nothing
        call SaveInteger(TimerUtils__hasht, 0, GetHandleId(t), value)
    endfunction

    function GetTimerData takes timer t returns integer
        return LoadInteger(TimerUtils__hasht, 0, GetHandleId(t))
    endfunction

    //==========================================================================================

    //==========================================================================================
    function NewTimer takes nothing returns timer
        if ( TimerUtils__tN == 0 ) then
            set TimerUtils__tT[0]=CreateTimer()
        else
            set TimerUtils__tN=TimerUtils__tN - 1
        endif
        call SaveInteger(TimerUtils__hasht, 0, GetHandleId((TimerUtils__tT[TimerUtils__tN] )), ( 0)) // INLINED!!
     return TimerUtils__tT[TimerUtils__tN]
    endfunction

    //==========================================================================================
    function ReleaseTimer takes timer t returns nothing
        if ( t == null ) then
            return
        endif
        if ( TimerUtils__tN == 8191 ) then
            //stack is full, the map already has much more troubles than the chance of bug
            call DestroyTimer(t)
        else
            call PauseTimer(t)
            if ( (LoadInteger(TimerUtils__hasht, 0, GetHandleId((t)))) == TimerUtils__HELD ) then // INLINED!!
                return
            endif
            call SaveInteger(TimerUtils__hasht, 0, GetHandleId((t )), ( TimerUtils__HELD)) // INLINED!!
            set TimerUtils__tT[TimerUtils__tN]=t
            set TimerUtils__tN=TimerUtils__tN + 1
        endif
    endfunction

    function TimerUtils__init takes nothing returns nothing
        set TimerUtils__hasht=InitHashtable()
    endfunction


//library TimerUtils ends
//library IntuitiveDamageSystem:
//******************************************************************************
//* BY: Rising_Dusk
//*     (Intuitive) Damage Detection System 1.13
//* 
//* This library is the core for what has come to be known as the Intuitive
//* Damage Detection System, or IDDS for short. Simply by copying this library
//* into your map somewhere, you will have access to all of its features and
//* options. Below this documentation are some global variables that can be
//* edited to make the system more useful for your map, whatever it might be.
//* Please note that you should only change those globals listed under 
//* configuration constants and damage type constants.
//* 
//* An important note for the system is that all non-attack damage in your map
//* MUST BE TRIGGERED using the special function call included in this system,
//* UnitDamageTargetEx. This is how the system works to detect attacks, because
//* if the only non-triggered damage in your map originates from attacks, you
//* clearly know which damage packets are attacks. This allows users to use
//* orb abilities in their maps for whatever they want.
//* 
//*     function UnitDamageTargetEx takes unit source, unit target, real damage, ...
//*     ...attacktype attackType, integer damageType, boolean ConsiderArmor returns boolean
//* 
//* This is the function with which you will deal all triggered damage in your
//* map. The damageType argument is one of the predefined integer constants that
//* you can edit or add below. Default values for this with the system are
//* DAMAGE_TYPE_ATTACK, DAMAGE_TYPE_SPELL, and DAMAGE_TYPE_EXTRA. You can
//* trigger the system to treat triggered damage like it is an attack if you
//* want to by using DAMAGE_TYPE_ATTACK. It is very easy to make new damage
//* types in the system, just follow the instructions in the configuration
//* constants area. In addition, be sure that the constants you define do not
//* conflict with the predefined Blizzard constants. (ie. DAMAGE_TYPE_FIRE) If
//* these conflicts do exist, you will encounter multiply defined syntax errors.
//* The AttackType argument is the same as in the regular UnitDamageTarget
//* native. Also, the system allows you to consider armor when dealing damage or
//* not. Set the ConsiderArmor boolean argument to false if you want to ignore
//* armor for that damage, or true if you want to factor it in.
//* 
//*     function TriggerUnregisterDamageEvent takes trigger trg returns boolean
//*     function TriggerRegisterDamageEvent takes trigger trg, integer priority returns boolean
//* 
//* The TriggerRegisterDamageEvent function is used when initializing a damage
//* detection response trigger. By using this, it allows you to use a syntax
//* structure nigh-identical to the standard JASS2. It returns a boolean for
//* your convenience that is false if you pass it a null trigger. The system
//* also allows you to pass a positive, zero-inclusive integer to it as that
//* trigger's priority. The higher the number you pass, the later on in the
//* trigger executions it will fire. This is useful if you want shield
//* abilities, as you will want their priorities low so that they can block the
//* damage before it gets to other things. You are also allowed to unregister
//* a trigger from the system at any time if you want; this will likely never
//* have to be done for most maps.
//* 
//*     function SetDamage takes real dmg returns nothing
//*     function SetDamageType takes integer dmgtype returns boolean 
//* 
//* With this function, you can modify the damage the system interprets for its
//* triggers. This function DOES NOT ACTUALLY CHANGE THE DAMAGE BEING DEALT, it
//* is merely a tool for users to use to change the internal variables. The user
//* will need to modify the damage himself by some other means. Similarly, the
//* SetDamageType function internally changes the damage type of a given packet
//* of damage. This can be useful if you want to convert DAMAGE_TYPE_ATTACK into
//* something else or if you want dynamic damagetypes in-game.
//* 
//*     function SetTriggerPriority takes trigger trg, integer priority returns boolean
//*     function GetTriggerPriority takes trigger trg returns integer
//* 
//* These functions let you set or get a given trigger's priority at will. These
//* functions both require that the trigger being passed to it is registered to
//* the IDDS system. If you pass an unregistered trigger to GetTriggerPriority,
//* it will return -1. If you pass a similar trigger to SetTriggerPriority, it
//* will return false.
//* 
//*     function IgnoreHigherPriority takes nothing returns boolean
//* 
//* This function is one of the most important reasons for priorities to exist.
//* With it, you can tell the system to ignore higher priority triggers. This
//* is useful, for instance, if you have a triggered evasion ability and don't
//* want anything else to be done with that damage because it was dodged. Other,
//* similar damage-preventing routines will also find this function useful.
//* 
//*     function RegisterDamageType takes nothing returns integer
//* 
//* This function is useful for declaring your own DAMAGE_TYPE_ETC constants
//* external to the system. By declaring your global variable and then calling
//* this on it as follows, you can register new damage types on the fly. This
//* is very useful if you want other systems or spells to introduce new damage
//* types that are either ignored or do special things for that application.
//* 
//*     function GetTriggerDamageType takes nothing returns integer
//*     function GetTriggerDamageSource takes nothing returns unit
//*     function GetTriggerDamageTarget takes nothing returns unit
//*     function GetTriggerDamageBase takes nothing returns real
//*     function GetTriggerDamage takes nothing returns real
//* 
//* Like normal WC3 damage detection, the system has event responses for the
//* damage source, the target of the damage, the amount of damage dealt, and
//* other things. It also permits the detection of damage type, which is
//* something standard WC3 does not have. This lets you create on-attack spells
//* very easily whereas without the system it would be very difficult and
//* computationally costly. GetTriggerDamageBase returns the amount of damage
//* the unit was dealt at the beginning of a given trigger series, whereas
//* GetTriggerDamage returns whatever damage the unit has left to receive, if
//* it has been modified in any way with the SetDamage function mentioned
//* earlier.
//* 
//* Once you understand all of the aforementioned aspects of the system, you're
//* ready to put it to use. I know it can be tricky to require all spells be
//* triggered, but this is the way of many great maps anyways, so such a
//* requirement is not so unreasonable. If you have any questions regarding the
//* system, please go to [url]www.wc3c.net[/url] and send a private message to the account
//* Rising_Dusk and I will respond as soon as I can. This system may only be
//* released at [url]www.wc3c.net[/url] and its existence on any other website is against
//* the author's will.
//* 
//* Enjoy!
//* 

//******************************************************************************
//******************************************************************************

//* Returns the integer index of a given handle object (Updated for 1.24)
function IntuitiveDamageSystem__H2I takes handle h returns integer
    return GetHandleId(h)
endfunction

//* Use an insertion sort algorithm to sort the trigger stack based on priority
function IntuitiveDamageSystem__TriggerSort takes nothing returns boolean
    local integer i= 1
    local integer j= 0
    local integer p= 0
    local trigger t= null
    
    loop
        exitwhen i >= IntuitiveDamageSystem__Count
        set t=IntuitiveDamageSystem__Trg[i]
        set p=IntuitiveDamageSystem__Priority[i]
        set j=i - 1
        loop
            exitwhen j < 0 or IntuitiveDamageSystem__Priority[j] <= p
            set IntuitiveDamageSystem__Priority[j + 1]=IntuitiveDamageSystem__Priority[j]
            set IntuitiveDamageSystem__Trg[j + 1]=IntuitiveDamageSystem__Trg[j]
            call SaveInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((IntuitiveDamageSystem__Trg[j])))), ( j + 1)) // INLINED!!
            set j=j - 1
        endloop
        set IntuitiveDamageSystem__Priority[j + 1]=p
        set IntuitiveDamageSystem__Trg[j + 1]=t
        call SaveInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((t)))), ( j + 1)) // INLINED!!
        set i=i + 1
    endloop
    
    set t=null
    return true
endfunction

//******************************************************************************
//******************************************************************************

//* The function to call when you want to end a damage's trigger series
function IgnoreHigherPriority takes nothing returns boolean
    if IntuitiveDamageSystem__DamageSource != null then
        //Make sure it was called in the right place
        set IntuitiveDamageSystem__IgnPrior=true
    endif
    return IntuitiveDamageSystem__IgnPrior
endfunction

//* Changes the base damage for a trigger series on the fly
function SetDamage takes real dmg returns boolean
    if IntuitiveDamageSystem__DamageSource != null and dmg >= 0 then
        //Make sure it was called in the right place
        set IntuitiveDamageSystem__NewDamage[IntuitiveDamageSystem__DamageId]=dmg
        set IntuitiveDamageSystem__Damage=dmg
        return true
    endif
    return false
endfunction

//* Changes the base damage type of the series
function SetDamageType takes integer dmgtype returns boolean
    if IntuitiveDamageSystem__DamageSource != null and dmgtype >= 0 then
        //Make sure it was called in the right place
        set IntuitiveDamageSystem__NewDamageType[IntuitiveDamageSystem__DamageId]=dmgtype
        set IntuitiveDamageSystem__DamageType=dmgtype
        return true
    endif
    return false
endfunction

//* Returns the given trigger's priority if it's loaded to the system
function GetTriggerPriority takes trigger trg returns integer
    if (LoadInteger(Table__ht, ((IntuitiveDamageSystem__RegiTable)), ((GetHandleId((trg)))))) == 0 then // INLINED!!
        return - 1
    endif
    return IntuitiveDamageSystem__Priority[(LoadInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((trg))))))] // INLINED!!
endfunction

//* Sets the given trigger's priority if it's loaded to the system
function SetTriggerPriority takes trigger trg,integer priority returns boolean
    if (LoadInteger(Table__ht, ((IntuitiveDamageSystem__RegiTable)), ((GetHandleId((trg)))))) == 0 or priority < 0 then // INLINED!!
        return false
    endif
    set IntuitiveDamageSystem__Priority[(LoadInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((trg))))))]=priority // INLINED!!
    return IntuitiveDamageSystem__TriggerSort()
endfunction

//******************************************************************************
//******************************************************************************

//* The new damage function used by the system
function UnitDamageTargetEx takes unit source,unit target,real damage,attacktype attackType,integer damageType,boolean ConsiderArmor returns boolean
    local boolean b= false
    set IntuitiveDamageSystem__DamageType=damageType
    set IntuitiveDamageSystem__DamageSource=source
    if ConsiderArmor then
        set b=UnitDamageTarget(source, target, damage, false, false, attackType, DAMAGE_TYPE_NORMAL, null)
    else
        set b=UnitDamageTarget(source, target, damage, false, false, attackType, DAMAGE_TYPE_UNIVERSAL, null)
    endif
    if not b then
        set IntuitiveDamageSystem__DamageType=0
        set IntuitiveDamageSystem__DamageSource=null
    endif
    return b
endfunction

//* The method by which one registers a trigger with the system
function TriggerRegisterDamageEvent takes trigger trg,integer priority returns boolean
    if trg == null or priority < 0 then
        return false
    endif
    if (LoadInteger(Table__ht, ((IntuitiveDamageSystem__RegiTable)), ((GetHandleId((trg)))))) == 0 then // INLINED!!
        call SaveInteger(Table__ht, ((IntuitiveDamageSystem__RegiTable)), ((GetHandleId((trg)))), ( 1)) // INLINED!!
    endif
    set IntuitiveDamageSystem__Trg[IntuitiveDamageSystem__Count]=trg
    set IntuitiveDamageSystem__Priority[IntuitiveDamageSystem__Count]=priority
    call SaveInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((trg)))), ( IntuitiveDamageSystem__Count)) // INLINED!!
    set IntuitiveDamageSystem__Count=IntuitiveDamageSystem__Count + 1
    return IntuitiveDamageSystem__TriggerSort()
endfunction

//* The method by which one unregisters a trigger from the system
function TriggerUnregisterDamageEvent takes trigger trg returns boolean
    local integer i= 0
    if trg == null then
        return false
    endif
    set i=(LoadInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((trg)))))) // INLINED!!
    if trg != IntuitiveDamageSystem__Trg[i] then
        return false
    endif
    set IntuitiveDamageSystem__Trg[i]=IntuitiveDamageSystem__Trg[IntuitiveDamageSystem__Count]
    set IntuitiveDamageSystem__Priority[i]=IntuitiveDamageSystem__Priority[IntuitiveDamageSystem__Count]
    call SaveInteger(Table__ht, ((IntuitiveDamageSystem__TrigTable)), ((GetHandleId((IntuitiveDamageSystem__Trg[i])))), ( i)) // INLINED!!
    call SaveInteger(Table__ht, ((IntuitiveDamageSystem__RegiTable)), ((GetHandleId((trg)))), ( 0)) // INLINED!!
    set IntuitiveDamageSystem__Count=IntuitiveDamageSystem__Count - 1
    return IntuitiveDamageSystem__TriggerSort()
endfunction

//* Initialization shorthand to register a new damage type externally
function RegisterDamageType takes nothing returns integer
    local integer i= IntuitiveDamageSystem__DamageTypeCount
    set IntuitiveDamageSystem__DamageTypeCount=IntuitiveDamageSystem__DamageTypeCount + 1
    return i
endfunction

//******************************************************************************
//******************************************************************************

//* Wrappers for the system that can get inlined anyways
function GetTriggerDamageType takes nothing returns integer
    return IntuitiveDamageSystem__DamageType
endfunction
function GetTriggerDamageSource takes nothing returns unit
    return IntuitiveDamageSystem__DamageSource
endfunction
function GetTriggerDamageTarget takes nothing returns unit
    return IntuitiveDamageSystem__DamageTarget
endfunction
function GetTriggerDamageBase takes nothing returns real
    return IntuitiveDamageSystem__DamageBase
endfunction
function GetTriggerDamage takes nothing returns real
    return IntuitiveDamageSystem__Damage
endfunction

//******************************************************************************
//******************************************************************************

function IntuitiveDamageSystem__RunConditions takes nothing returns boolean
    //* The conditions for what must be true for damage detection to run
    return GetEventDamage() >= 0.0001 and IntuitiveDamageSystem__DamageType != DAMAGE_TYPE_IGNORED
endfunction

function IntuitiveDamageSystem__AddConditions takes nothing returns boolean
    //* The conditions for registering a unit with the damage system
    return true
endfunction

function IntuitiveDamageSystem__PreloadConditions takes unit u returns boolean
    //* The conditions for preloading a unit to the damage system
    return true
endfunction

//******************************************************************************
//******************************************************************************


function IntuitiveDamageSystem__Run takes nothing returns nothing
    local unit u= GetEventDamageSource()
    local unit s= IntuitiveDamageSystem__DamageSource
    local unit t= GetTriggerUnit()
    local integer i= 0
    local integer id= 0
    local integer d= IntuitiveDamageSystem__DamageType
    local real r= GetEventDamage()
    local real b= r
    
    //Allocate an id for this damage packet
    if IntuitiveDamageSystem__IDN > 0 then
        set id=IntuitiveDamageSystem__IDStack[IntuitiveDamageSystem__IDN]
        set IntuitiveDamageSystem__IDN=IntuitiveDamageSystem__IDN - 1
    else
        set id=IntuitiveDamageSystem__IDC
        set IntuitiveDamageSystem__IDC=IntuitiveDamageSystem__IDC + 1
    endif
    
    if IntuitiveDamageSystem__DamageSource == null then
        //Damage is of type attack
        set d=DAMAGE_TYPE_ATTACK
        set s=u
    endif
    loop
        exitwhen i > IntuitiveDamageSystem__Count or IntuitiveDamageSystem__IgnPrior
        //Ensure all variables are correct for nesting
        set IntuitiveDamageSystem__Damage=r
        set IntuitiveDamageSystem__DamageBase=b
        set IntuitiveDamageSystem__DamageTarget=t
        set IntuitiveDamageSystem__DamageSource=s
        set IntuitiveDamageSystem__DamageType=d
        set IntuitiveDamageSystem__DamageId=id
        set IntuitiveDamageSystem__NewDamage[id]=0.
        set IntuitiveDamageSystem__NewDamageType[id]=- 1
        if IsTriggerEnabled(IntuitiveDamageSystem__Trg[i]) and TriggerEvaluate(IntuitiveDamageSystem__Trg[i]) then
            call TriggerExecute(IntuitiveDamageSystem__Trg[i])
        endif
        if IntuitiveDamageSystem__NewDamage[id] > 0. then
            //Update damage if it was changed
            set r=IntuitiveDamageSystem__NewDamage[id]
        endif
        if IntuitiveDamageSystem__NewDamageType[id] >= 0 then
            //Update damagetype if it was changed
            set d=IntuitiveDamageSystem__NewDamageType[id]
        endif
        set i=i + 1
    endloop
    set IntuitiveDamageSystem__Damage=0.
    set IntuitiveDamageSystem__DamageBase=0.
    set IntuitiveDamageSystem__DamageTarget=null
    set IntuitiveDamageSystem__DamageSource=null
    set IntuitiveDamageSystem__DamageType=0
    set IntuitiveDamageSystem__DamageId=0
    set IntuitiveDamageSystem__IgnPrior=false
    set IntuitiveDamageSystem__NewDamage[id]=0.
    
    //Return id to the stack
    set IntuitiveDamageSystem__IDN=IntuitiveDamageSystem__IDN + 1
    set IntuitiveDamageSystem__IDStack[IntuitiveDamageSystem__IDN]=id
    
    set u=null
    set s=null
    set t=null
endfunction

function IntuitiveDamageSystem__Load takes nothing returns nothing
    call TriggerRegisterUnitEvent(IntuitiveDamageSystem__RunTrigger, GetEnteringUnit(), EVENT_UNIT_DAMAGED)
endfunction

//******************************************************************************
//******************************************************************************

function IntuitiveDamageSystem__PreloadUnits takes nothing returns boolean
    if IntuitiveDamageSystem__PreloadConditions(GetFilterUnit()) then
        call TriggerRegisterUnitEvent(IntuitiveDamageSystem__RunTrigger, GetFilterUnit(), EVENT_UNIT_DAMAGED)
    endif
    return false
endfunction

function IntuitiveDamageSystem__Init takes nothing returns nothing
    local rect r= GetWorldBounds()
    local region re= CreateRegion()
    local boolexpr b= Condition(function IntuitiveDamageSystem__PreloadUnits)
    local group g= CreateGroup()
    
    //* Create the tables for use with the system
    set IntuitiveDamageSystem__TrigTable=s__Table__allocate()
    set IntuitiveDamageSystem__RegiTable=s__Table__allocate()
    
    call TriggerAddAction(IntuitiveDamageSystem__RunTrigger, function IntuitiveDamageSystem__Run)
    call TriggerAddCondition(IntuitiveDamageSystem__RunTrigger, Condition(function IntuitiveDamageSystem__RunConditions))
    call GroupEnumUnitsInRect(g, r, b)
    
    call RegionAddRect(re, r)
    call TriggerRegisterEnterRegion(IntuitiveDamageSystem__AddTrigger, re, null)
    call TriggerAddAction(IntuitiveDamageSystem__AddTrigger, function IntuitiveDamageSystem__Load)
    call TriggerAddCondition(IntuitiveDamageSystem__AddTrigger, Condition(function IntuitiveDamageSystem__AddConditions))
    
    call RemoveRect(r)
    call DestroyGroup(g)
    call DestroyBoolExpr(b)
    set re=null
    set g=null
    set b=null
    set r=null
endfunction

//library IntuitiveDamageSystem ends
//===========================================================================
// 
// Zephyr Contest #7 by xD.Schurke
// 
//   Warcraft III map script
//   Generated by the Warcraft III World Editor
//   Date: Wed Aug 18 04:30:39 2010
//   Map Author: xD.Schurke
// 
//===========================================================================

//***************************************************************************
//*
//*  Global Variables
//*
//***************************************************************************


function InitGlobals takes nothing returns nothing
endfunction

//***************************************************************************
//*
//*  Unit Creation
//*
//***************************************************************************

//===========================================================================
function CreateUnitsForPlayer0 takes nothing returns nothing
    local player p= Player(0)
    local unit u
    local integer unitID
    local trigger t
    local real life

    set u=CreateUnit(p, 'hfoo', - 144.8, 101.9, 107.241)
    set u=CreateUnit(p, 'E000', 17.1, - 64.0, 269.280)
    call SetHeroLevel(u, 10, false)
    set life=GetUnitState(u, UNIT_STATE_LIFE)
    call SetUnitState(u, UNIT_STATE_LIFE, 0.05 * life)
    call SetUnitState(u, UNIT_STATE_MANA, 675)
    set u=CreateUnit(p, 'hrif', 96.6, - 64.0, 250.606)
    set u=CreateUnit(p, 'hrif', 130.1, 89.6, 198.727)
    set u=CreateUnit(p, 'hfoo', - 111.8, - 49.6, 305.792)
endfunction

//===========================================================================
function CreateUnitsForPlayer1 takes nothing returns nothing
    local player p= Player(1)
    local unit u
    local integer unitID
    local trigger t
    local real life

    set u=CreateUnit(p, 'hfoo', - 443.4, - 1057.5, 245.969)
    set u=CreateUnit(p, 'hrif', - 531.3, - 1124.6, 142.750)
    set u=CreateUnit(p, 'hrif', - 408.0, - 1165.7, 3.867)
    set u=CreateUnit(p, 'hkni', 914.7, - 713.5, 69.227)
    set u=CreateUnit(p, 'hrif', 975.4, - 832.8, 153.857)
    set u=CreateUnit(p, 'hfoo', 292.7, 813.4, 264.998)
    set u=CreateUnit(p, 'hfoo', 379.2, 770.3, 356.847)
    set u=CreateUnit(p, 'hrif', 234.3, 929.7, 144.255)
    set u=CreateUnit(p, 'hmpr', 356.5, 905.3, 328.402)
endfunction

//===========================================================================
function CreatePlayerBuildings takes nothing returns nothing
endfunction

//===========================================================================
function CreatePlayerUnits takes nothing returns nothing
    call CreateUnitsForPlayer0()
    call CreateUnitsForPlayer1()
endfunction

//===========================================================================
function CreateAllUnits takes nothing returns nothing
    call CreatePlayerBuildings()
    call CreatePlayerUnits()
endfunction

//***************************************************************************
//*
//*  Triggers
//*
//***************************************************************************

//===========================================================================
// Trigger: Init
//===========================================================================
function Trig_Init_Actions takes nothing returns nothing
    call FogEnableOff()
    call FogMaskEnableOff()
    call DisplayTimedTextToForce(GetPlayersAll(), 600.00, "TRIGSTR_033")
endfunction

//===========================================================================
function InitTrig_Init takes nothing returns nothing
    set gg_trg_Init=CreateTrigger()
    call TriggerAddAction(gg_trg_Init, function Trig_Init_Actions)
endfunction

//===========================================================================
// Trigger: Table
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
//===========================================================================
// Trigger: TimerUtils
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
// Trigger: IntuitiveDamageSystem
//===========================================================================
//TESH.scrollpos=0
//TESH.alwaysfold=0
//===========================================================================
// Trigger: Touch of Nature
//===========================================================================
//TESH.scrollpos=24
//TESH.alwaysfold=0
//*******************************************************************************************************************
//* Touch of Nature by xD.Schurke (Zephyr Contest #7 entry)
//* -------------------------------------------------------
//*
//* Requires:
//*          - JassHelper (Latest Version)
//*          - Table 3.0 By Vexorian
//*          - TimerUtils (Blue Flavour) by Vexorian
//*          - IntuitiveDamageSystem 1.13 by Rising_Dusk
//*          - Basis Jass-Knowledge to setup the spell
//*         
//*
//* Other Credits:
//*          - SkriK for the icon
//*
//*
//* About the spell:
//*          Touches an allied unit with the power of nature. The unit regenerates life 
//*          and takes 5% less physical damage. In addition blossoms are spawned for 
//*          5 seconds which can be consumed by anyone. Those blossoms increase the armor 
//*          by 3 and heal the unit over 7.5 seconds for 65 hitpoints.
//*          Level 1 - The touched unit regenerates 100 health points over 10 seconds.
//*          Level 2 - The touched unit regenerates 175 health points over 11 seconds.
//*          Level 3 - The touched unit regenerates 250 health points over 12 seconds.
//*
//*          Cooldown: 15 seconds
//*
//*
//*          - The spell requires some micro to have the optimal use in a battle. 
//*          - The spell is balanced for melee games, only issue is that it uses Inner-Fire buff
//*
//*
//*
//*******************************************************************************************************************
// scope TouchOfNature begins

//This function is used to setup the flower model strings
function TouchOfNature__setupModelStrings takes nothing returns nothing
    set TouchOfNature__FLOWER_VARIATION[0]="Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower0.mdl"
    set TouchOfNature__FLOWER_VARIATION[1]="Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower1.mdl"
    set TouchOfNature__FLOWER_VARIATION[2]="Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower2.mdl"
    set TouchOfNature__FLOWER_VARIATION[3]="Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower3.mdl"
    set TouchOfNature__FLOWER_VARIATION[4]="Doodads\\Ruins\\Plants\\Ruins_Flower\\Ruins_Flower4.mdl"
endfunction

//Function for getting the duration of the spell
function TouchOfNature__getDuration takes integer lvl returns real
    return TouchOfNature__DURATION_BASIS + ( TouchOfNature__DURATION_BASIS_INC * ( lvl - 1 ) )
endfunction
//Function for getting the duration of the flowers
function TouchOfNature__getFlowerDuration takes integer lvl returns real
    return TouchOfNature__DURATION_FLOWER_BASIS + ( TouchOfNature__DURATION_FLOWER_BASIS_INC * ( lvl - 1 ) )
endfunction
//Function for calculating the healed amount of the main spell
function TouchOfNature__getHealMain takes integer lvl returns real
    return ( TouchOfNature__LIFE_REGENERATION + ( TouchOfNature__LIFE_REGENERATION_INC * ( lvl - 1 ) ) ) / ( (TouchOfNature__DURATION_BASIS + ( TouchOfNature__DURATION_BASIS_INC * ( (lvl) - 1 ) )) / TouchOfNature__INTERVAL ) // INLINED!!
endfunction
//Function for calculating the healed amount of the blossoms
function TouchOfNature__getHealBlossom takes nothing returns real
    return TouchOfNature__BLOSSOM_HEAL / ( TouchOfNature__BLOSSOM_DURATION / TouchOfNature__INTERVAL )
endfunction
//Filter function used to find a unit which can be buffed
function TouchOfNature__GroupFilterFlower takes nothing returns boolean
    return GetUnitAbilityLevel(GetFilterUnit(), TouchOfNature__DUMMY_SPELL_BUFF_ID) == 0 and ( GetUnitState(GetFilterUnit(), UNIT_STATE_LIFE) > 0 ) and IsUnitType(GetFilterUnit(), UNIT_TYPE_GROUND) and ( GetUnitTypeId(GetFilterUnit()) != TouchOfNature__DUMMY_ID ) and GetFilterUnit() != TouchOfNature__tmpU
endfunction
//Filter Function used to check if other flowers are arround
function TouchOfNature__GroupFilterFlowerCheck takes nothing returns boolean
    local real dx= GetUnitX(GetFilterUnit()) - GetUnitX(TouchOfNature__tmpU)
    local real dy= GetUnitY(GetFilterUnit()) - GetUnitY(TouchOfNature__tmpU)
    return GetUnitState(GetFilterUnit(), UNIT_STATE_LIFE) > 0 and GetUnitTypeId(GetFilterUnit()) == TouchOfNature__DUMMY_ID and SquareRoot(dx * dx + dy * dy) < TouchOfNature__GROWTH_CHECK_RANGE
endfunction
//Keyword since I decided to declare the FlowerStruct after the MainStruct

//This struct is the one handeling the main part, also this struct contains the initializer method (onInit)
    //method to check the surrounding area for other flowers
    function s__TouchOfNature__MainStruct_checkFlowers takes integer this returns boolean
        local real x= GetUnitX(s__TouchOfNature__MainStruct_caster[this])
        local real y= GetUnitY(s__TouchOfNature__MainStruct_caster[this])
        set TouchOfNature__tmpP=GetOwningPlayer(s__TouchOfNature__MainStruct_target[this])
        set TouchOfNature__tmpU=s__TouchOfNature__MainStruct_target[this]
        call GroupEnumUnitsOfPlayer(TouchOfNature__tmpG, TouchOfNature__tmpP, TouchOfNature__FILTER_CHECK_FLOWER)
        if FirstOfGroup(TouchOfNature__tmpG) != null then
            call GroupClear(TouchOfNature__tmpG)
            return false
        endif
        return true
    endfunction
    //The callback method which is called each interval, heals the target of the spell and copes the flower growth
    function s__TouchOfNature__MainStruct_callback takes nothing returns nothing
        local timer tim= GetExpiredTimer()
        local integer this= (LoadInteger(TimerUtils__hasht, 0, GetHandleId((tim)))) // INLINED!!
        local real x= 0.0
        local real y= 0.0
        local real life= GetUnitState(s__TouchOfNature__MainStruct_target[this], UNIT_STATE_LIFE)
        set s__TouchOfNature__MainStruct_duration[this]=s__TouchOfNature__MainStruct_duration[this] + TouchOfNature__INTERVAL
        call SetUnitState(s__TouchOfNature__MainStruct_target[this], UNIT_STATE_LIFE, life + TouchOfNature__getHealMain(GetUnitAbilityLevel(s__TouchOfNature__MainStruct_caster[this], TouchOfNature__SPELL_ID)))
        if s__TouchOfNature__MainStruct_checkFlowers(this) then
            set x=GetUnitX(s__TouchOfNature__MainStruct_target[this]) + GetRandomReal(0.0, TouchOfNature__GROWTH_CHECK_RANGE) * Cos(GetRandomReal(0.0, TouchOfNature__GROWTH_ANGLE_RADIUS) * bj_DEGTORAD)
            set y=GetUnitY(s__TouchOfNature__MainStruct_target[this]) + GetRandomReal(0.0, TouchOfNature__GROWTH_CHECK_RANGE) * Sin(GetRandomReal(0.0, TouchOfNature__GROWTH_ANGLE_RADIUS) * bj_DEGTORAD)
            call sc__TouchOfNature__FlowerStruct_create(s__TouchOfNature__MainStruct_caster[this] , s__TouchOfNature__MainStruct_target[this] , x , y)
        endif
        if s__TouchOfNature__MainStruct_duration[this] >= (TouchOfNature__DURATION_BASIS + ( TouchOfNature__DURATION_BASIS_INC * ( (GetUnitAbilityLevel(s__TouchOfNature__MainStruct_caster[this], TouchOfNature__SPELL_ID)) - 1 ) )) or GetUnitAbilityLevel(s__TouchOfNature__MainStruct_target[this], TouchOfNature__SPELL_BUFF_ID) == 0 then // INLINED!!
            call ReleaseTimer(tim)
            call sc__TouchOfNature__MainStruct_deallocate(this)
        endif
        set tim=null
    endfunction
    
    function s__TouchOfNature__MainStruct_create takes unit caster,unit target returns integer
        local integer this= s__TouchOfNature__MainStruct__allocate()
        local timer tim= NewTimer()
        set s__TouchOfNature__MainStruct_caster[this]=caster
        set s__TouchOfNature__MainStruct_target[this]=target
        call SaveInteger(TimerUtils__hasht, 0, GetHandleId((tim )), ( this)) // INLINED!!
        call TimerStart(tim, TouchOfNature__INTERVAL, true, function s__TouchOfNature__MainStruct_callback)
        return this
    endfunction
    
    function s__TouchOfNature__MainStruct_onDestroy takes integer this returns nothing
        set s__TouchOfNature__MainStruct_caster[this]=null
        set s__TouchOfNature__MainStruct_target[this]=null
    endfunction

//Generated destructor of TouchOfNature__MainStruct
function s__TouchOfNature__MainStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__MainStruct_V[this]!=-1) then
        return
    endif
    call s__TouchOfNature__MainStruct_onDestroy(this)
    set si__TouchOfNature__MainStruct_V[this]=si__TouchOfNature__MainStruct_F
    set si__TouchOfNature__MainStruct_F=this
endfunction
    //The following part is used to setup stuff like damage reduction and general struct creation on spell cast
    function s__TouchOfNature__MainStruct_condition takes nothing returns boolean
        if GetSpellAbilityId() == TouchOfNature__SPELL_ID then
            call s__TouchOfNature__MainStruct_create(GetTriggerUnit() , GetSpellTargetUnit())
        endif
        return false
    endfunction
    
    function s__TouchOfNature__MainStruct_damageCondition takes nothing returns boolean
        if GetUnitAbilityLevel((IntuitiveDamageSystem__DamageTarget), TouchOfNature__SPELL_BUFF_ID) > 0 and (IntuitiveDamageSystem__DamageType) == DAMAGE_TYPE_ATTACK then // INLINED!!
            call SetUnitState((IntuitiveDamageSystem__DamageTarget), UNIT_STATE_LIFE, GetUnitState((IntuitiveDamageSystem__DamageTarget), UNIT_STATE_LIFE) + (IntuitiveDamageSystem__Damage) * TouchOfNature__DAMAGE_REDUCE) // INLINED!!
        endif
        return false
    endfunction
    
    function s__TouchOfNature__MainStruct_onInit takes nothing returns nothing
        local trigger trig= CreateTrigger()
        local trigger damageTrig= CreateTrigger()
        call TouchOfNature__setupModelStrings()
        set TouchOfNature__tmpG=CreateGroup()
        set TouchOfNature__FILTER_FLOWER=Condition(function TouchOfNature__GroupFilterFlower)
        set TouchOfNature__FILTER_CHECK_FLOWER=Condition(function TouchOfNature__GroupFilterFlowerCheck)
        
        call TriggerRegisterAnyUnitEventBJ(trig, EVENT_PLAYER_UNIT_SPELL_EFFECT)
        call TriggerAddCondition(trig, Condition(function s__TouchOfNature__MainStruct_condition))
        
        call TriggerAddCondition(damageTrig, Condition(function s__TouchOfNature__MainStruct_damageCondition))
        call TriggerRegisterDamageEvent(damageTrig , 0)
        set trig=null
    endfunction
//This is just a small struct healing the target of a blossom buff, does nothing else
    
    function s__TouchOfNature__BlossomStruct_callback takes nothing returns nothing
        local timer tim= GetExpiredTimer()
        local integer this= (LoadInteger(TimerUtils__hasht, 0, GetHandleId((tim)))) // INLINED!!
        local real life= GetUnitState(s__TouchOfNature__BlossomStruct_target[this], UNIT_STATE_LIFE)
        set s__TouchOfNature__BlossomStruct_duration[this]=s__TouchOfNature__BlossomStruct_duration[this] + TouchOfNature__INTERVAL
        call SetUnitState(s__TouchOfNature__BlossomStruct_target[this], UNIT_STATE_LIFE, life + (TouchOfNature__BLOSSOM_HEAL / ( TouchOfNature__BLOSSOM_DURATION / TouchOfNature__INTERVAL ))) // INLINED!!
        if s__TouchOfNature__BlossomStruct_duration[this] >= TouchOfNature__BLOSSOM_DURATION or GetUnitAbilityLevel(s__TouchOfNature__BlossomStruct_target[this], TouchOfNature__DUMMY_SPELL_BUFF_ID) == 0 then
            call ReleaseTimer(tim)
            call sc__TouchOfNature__BlossomStruct_deallocate(this)
        endif
        set tim=null
    endfunction
    
    function s__TouchOfNature__BlossomStruct_onDestroy takes integer this returns nothing
        set s__TouchOfNature__BlossomStruct_target[this]=null
    endfunction

//Generated destructor of TouchOfNature__BlossomStruct
function s__TouchOfNature__BlossomStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__BlossomStruct_V[this]!=-1) then
        return
    endif
    set s__TouchOfNature__BlossomStruct_target[(this)]=null // INLINED!!
    set si__TouchOfNature__BlossomStruct_V[this]=si__TouchOfNature__BlossomStruct_F
    set si__TouchOfNature__BlossomStruct_F=this
endfunction

    function s__TouchOfNature__BlossomStruct_create takes unit target returns integer
        local integer this= s__TouchOfNature__BlossomStruct__allocate()
        local timer tim= NewTimer()
        set s__TouchOfNature__BlossomStruct_target[this]=target
        call SaveInteger(TimerUtils__hasht, 0, GetHandleId((tim )), ( this)) // INLINED!!
        call TimerStart(tim, TouchOfNature__INTERVAL, true, function s__TouchOfNature__BlossomStruct_callback)
        return this
    endfunction    

//The FlowerStruct represents Flower/Blossom objects, it actually checks in the callback method for units arround which can be buffed, and then
//applies the buff to them, look a bit more into it to get a basic knowledge of what I am doing here
    
    function s__TouchOfNature__FlowerStruct_checkRange takes integer this returns boolean
        local real x= GetUnitX(s__TouchOfNature__FlowerStruct_dummy[this])
        local real y= GetUnitY(s__TouchOfNature__FlowerStruct_dummy[this])
        local unit pickedUnit= null
        set TouchOfNature__tmpU=s__TouchOfNature__FlowerStruct_target[this]
        set TouchOfNature__tmpP=GetOwningPlayer(s__TouchOfNature__FlowerStruct_target[this])
        call GroupEnumUnitsInRange(TouchOfNature__tmpG, x, y, TouchOfNature__FLOWER_CHECK_RANGE, TouchOfNature__FILTER_FLOWER)
        if FirstOfGroup(TouchOfNature__tmpG) != null then
            set pickedUnit=FirstOfGroup(TouchOfNature__tmpG)
            call UnitAddAbility(s__TouchOfNature__FlowerStruct_dummy[this], TouchOfNature__DUMMY_SPELL_ID)
            call IssueTargetOrder(s__TouchOfNature__FlowerStruct_dummy[this], "innerfire", pickedUnit)
            call s__TouchOfNature__BlossomStruct_create(pickedUnit)
            call GroupClear(TouchOfNature__tmpG)
            return true
        endif
        call GroupClear(TouchOfNature__tmpG)
        return false
    endfunction
    
    function s__TouchOfNature__FlowerStruct_callback takes nothing returns nothing
        local timer tim= GetExpiredTimer()
        local integer this= (LoadInteger(TimerUtils__hasht, 0, GetHandleId((tim)))) // INLINED!!
        set s__TouchOfNature__FlowerStruct_duration[this]=s__TouchOfNature__FlowerStruct_duration[this] + TouchOfNature__INTERVAL
        if s__TouchOfNature__FlowerStruct_duration[this] < TouchOfNature__GROWTH_DURATION then
            set s__TouchOfNature__FlowerStruct_actualSize[this]=s__TouchOfNature__FlowerStruct_actualSize[this] + TouchOfNature__GROWTH_VALUE
            call SetUnitScale(s__TouchOfNature__FlowerStruct_dummy[this], s__TouchOfNature__FlowerStruct_actualSize[this], s__TouchOfNature__FlowerStruct_actualSize[this], s__TouchOfNature__FlowerStruct_actualSize[this])
        endif
        if s__TouchOfNature__FlowerStruct_checkRange(this) then
            call DestroyEffect(AddSpecialEffect(TouchOfNature__FLOWER_PICK_UP_EFFECT, GetUnitX(s__TouchOfNature__FlowerStruct_dummy[this]), GetUnitY(s__TouchOfNature__FlowerStruct_dummy[this])))
            call ReleaseTimer(tim)
            call sc__TouchOfNature__FlowerStruct_deallocate(this)
        elseif s__TouchOfNature__FlowerStruct_duration[this] >= (TouchOfNature__DURATION_FLOWER_BASIS + ( TouchOfNature__DURATION_FLOWER_BASIS_INC * ( (GetUnitAbilityLevel(s__TouchOfNature__FlowerStruct_caster[this], TouchOfNature__SPELL_ID)) - 1 ) )) then // INLINED!!
            call DestroyEffect(AddSpecialEffect(TouchOfNature__FLOWER_DEATH_EFFECT, GetUnitX(s__TouchOfNature__FlowerStruct_dummy[this]), GetUnitY(s__TouchOfNature__FlowerStruct_dummy[this])))
            call ReleaseTimer(tim)
            call sc__TouchOfNature__FlowerStruct_deallocate(this)
        endif
        set tim=null
    endfunction
    
    function s__TouchOfNature__FlowerStruct_create takes unit caster,unit target,real x,real y returns integer
        local integer this= s__TouchOfNature__FlowerStruct__allocate()
        local timer tim= NewTimer()
        set s__TouchOfNature__FlowerStruct_caster[this]=caster
        set s__TouchOfNature__FlowerStruct_target[this]=target
        set s__TouchOfNature__FlowerStruct_dummy[this]=CreateUnit(GetOwningPlayer(s__TouchOfNature__FlowerStruct_target[this]), TouchOfNature__DUMMY_ID, x, y, 0.0)
        call SetUnitTimeScale(s__TouchOfNature__FlowerStruct_dummy[this], 0.0)
        call SetUnitScale(s__TouchOfNature__FlowerStruct_dummy[this], TouchOfNature__GROWTH_START_SIZE, TouchOfNature__GROWTH_START_SIZE, TouchOfNature__GROWTH_START_SIZE)
        call AddSpecialEffectTarget(TouchOfNature__FLOWER_VARIATION[GetRandomInt(0, TouchOfNature__VARIATION_COUNT - 1)], s__TouchOfNature__FlowerStruct_dummy[this], "origin")
        call SaveInteger(TimerUtils__hasht, 0, GetHandleId((tim )), ( this)) // INLINED!!
        call TimerStart(tim, TouchOfNature__INTERVAL, true, function s__TouchOfNature__FlowerStruct_callback)
        return this
    endfunction
    
    function s__TouchOfNature__FlowerStruct_onDestroy takes integer this returns nothing
        call DestroyEffect(s__TouchOfNature__FlowerStruct_attachement[this])
        call RemoveUnit(s__TouchOfNature__FlowerStruct_dummy[this])
        set s__TouchOfNature__FlowerStruct_attachement[this]=null
        set s__TouchOfNature__FlowerStruct_dummy[this]=null
        set s__TouchOfNature__FlowerStruct_caster[this]=null
        set s__TouchOfNature__FlowerStruct_target[this]=null
    endfunction

//Generated destructor of TouchOfNature__FlowerStruct
function s__TouchOfNature__FlowerStruct_deallocate takes integer this returns nothing
    if this==null then
        return
    elseif (si__TouchOfNature__FlowerStruct_V[this]!=-1) then
        return
    endif
    call s__TouchOfNature__FlowerStruct_onDestroy(this)
    set si__TouchOfNature__FlowerStruct_V[this]=si__TouchOfNature__FlowerStruct_F
    set si__TouchOfNature__FlowerStruct_F=this
endfunction
// scope TouchOfNature ends
function InitCustomTriggers takes nothing returns nothing
    call InitTrig_Init()
    //Function not found: call InitTrig_Table()
    //Function not found: call InitTrig_TimerUtils()
    //Function not found: call InitTrig_IntuitiveDamageSystem()
    //Function not found: call InitTrig_Touch_of_Nature()
endfunction

//===========================================================================
function RunInitializationTriggers takes nothing returns nothing
    call ConditionalTriggerExecute(gg_trg_Init)
endfunction

//***************************************************************************
//*
//*  Players
//*
//***************************************************************************

function InitCustomPlayerSlots takes nothing returns nothing

    // Player 0
    call SetPlayerStartLocation(Player(0), 0)
    call SetPlayerColor(Player(0), ConvertPlayerColor(0))
    call SetPlayerRacePreference(Player(0), RACE_PREF_HUMAN)
    call SetPlayerRaceSelectable(Player(0), true)
    call SetPlayerController(Player(0), MAP_CONTROL_USER)

endfunction

function InitCustomTeams takes nothing returns nothing
    // Force: TRIGSTR_002
    call SetPlayerTeam(Player(0), 0)

endfunction

//***************************************************************************
//*
//*  Main Initialization
//*
//***************************************************************************

//===========================================================================
function main takes nothing returns nothing
    call SetCameraBounds(- 1280.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), - 1536.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM), 1280.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), 1024.0 - GetCameraMargin(CAMERA_MARGIN_TOP), - 1280.0 + GetCameraMargin(CAMERA_MARGIN_LEFT), 1024.0 - GetCameraMargin(CAMERA_MARGIN_TOP), 1280.0 - GetCameraMargin(CAMERA_MARGIN_RIGHT), - 1536.0 + GetCameraMargin(CAMERA_MARGIN_BOTTOM))
    call SetDayNightModels("Environment\\DNC\\DNCAshenvale\\DNCAshenvaleTerrain\\DNCAshenvaleTerrain.mdl", "Environment\\DNC\\DNCAshenvale\\DNCAshenvaleUnit\\DNCAshenvaleUnit.mdl")
    call NewSoundEnvironment("Default")
    call SetAmbientDaySound("AshenvaleDay")
    call SetAmbientNightSound("AshenvaleNight")
    call SetMapMusic("Music", true, 0)
    call CreateAllUnits()
    call InitBlizzard()

call ExecuteFunc("jasshelper__initstructs22358078")
call ExecuteFunc("TimerUtils__init")
call ExecuteFunc("IntuitiveDamageSystem__Init")

    call InitGlobals()
    call InitTrig_Init() // INLINED!!
    call ConditionalTriggerExecute(gg_trg_Init) // INLINED!!

endfunction

//***************************************************************************
//*
//*  Map Configuration
//*
//***************************************************************************

function config takes nothing returns nothing
    call SetMapName("TRIGSTR_029")
    call SetMapDescription("TRIGSTR_031")
    call SetPlayers(1)
    call SetTeams(1)
    call SetGamePlacement(MAP_PLACEMENT_USE_MAP_SETTINGS)

    call DefineStartLocation(0, 0.0, - 64.0)

    // Player setup
    call InitCustomPlayerSlots()
    call SetPlayerSlotAvailable(Player(0), MAP_CONTROL_USER)
    call InitGenericPlayerSlots()
endfunction




//Struct method generated initializers/callers:
function sa__Table__GTable_onDestroy takes nothing returns boolean
local integer this=f__arg_this
            call FlushChildHashtable(Table__ht, ((this))) // INLINED!!
   return true
endfunction
function sa__TouchOfNature__FlowerStruct_create takes nothing returns boolean
    set f__result_integer=s__TouchOfNature__FlowerStruct_create(f__arg_unit1,f__arg_unit2,f__arg_real1,f__arg_real2)
   return true
endfunction
function sa__TouchOfNature__FlowerStruct_onDestroy takes nothing returns boolean
local integer this=f__arg_this
        call DestroyEffect(s__TouchOfNature__FlowerStruct_attachement[this])
        call RemoveUnit(s__TouchOfNature__FlowerStruct_dummy[this])
        set s__TouchOfNature__FlowerStruct_attachement[this]=null
        set s__TouchOfNature__FlowerStruct_dummy[this]=null
        set s__TouchOfNature__FlowerStruct_caster[this]=null
        set s__TouchOfNature__FlowerStruct_target[this]=null
   return true
endfunction
function sa__TouchOfNature__BlossomStruct_onDestroy takes nothing returns boolean
local integer this=f__arg_this
        set s__TouchOfNature__BlossomStruct_target[this]=null
   return true
endfunction
function sa__TouchOfNature__MainStruct_onDestroy takes nothing returns boolean
local integer this=f__arg_this
        set s__TouchOfNature__MainStruct_caster[this]=null
        set s__TouchOfNature__MainStruct_target[this]=null
   return true
endfunction

function jasshelper__initstructs22358078 takes nothing returns nothing
    set st__Table__GTable_onDestroy[1]=CreateTrigger()
    set st__Table__GTable_onDestroy[2]=st__Table__GTable_onDestroy[1]
    set st__Table__GTable_onDestroy[3]=st__Table__GTable_onDestroy[1]
    set st__Table__GTable_onDestroy[4]=st__Table__GTable_onDestroy[1]
    call TriggerAddCondition(st__Table__GTable_onDestroy[1],Condition( function sa__Table__GTable_onDestroy))
    set st__TouchOfNature__FlowerStruct_create=CreateTrigger()
    call TriggerAddCondition(st__TouchOfNature__FlowerStruct_create,Condition( function sa__TouchOfNature__FlowerStruct_create))
    set st__TouchOfNature__FlowerStruct_onDestroy=CreateTrigger()
    call TriggerAddCondition(st__TouchOfNature__FlowerStruct_onDestroy,Condition( function sa__TouchOfNature__FlowerStruct_onDestroy))
    set st__TouchOfNature__BlossomStruct_onDestroy=CreateTrigger()
    call TriggerAddCondition(st__TouchOfNature__BlossomStruct_onDestroy,Condition( function sa__TouchOfNature__BlossomStruct_onDestroy))
    set st__TouchOfNature__MainStruct_onDestroy=CreateTrigger()
    call TriggerAddCondition(st__TouchOfNature__MainStruct_onDestroy,Condition( function sa__TouchOfNature__MainStruct_onDestroy))








    call ExecuteFunc("s__Table__GTable_onInit")
    call ExecuteFunc("s__TouchOfNature__MainStruct_onInit")
endfunction

