/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class Reader {
    private static String fise = System.getProperty("file.separator");
    private static String crlf = System.getProperty("line.separator");
    private static ArrayList<String> SLKS = new ArrayList();
    private static ArrayList<String> WANTS = new ArrayList();
    private static ArrayList<String> INVALID = new ArrayList();
    private static Hashtable<String, String> FIELDTYPES = new Hashtable();
    private static Hashtable<String, String> FIELDNAMES = new Hashtable();
    private static Hashtable<String, String> TRIGSTRS = new Hashtable();
    private static Hashtable<String, String> METADATA = new Hashtable();
    private static Hashtable<String, Boolean> UNITS = new Hashtable();
    private static Hashtable<String, String> FIELDDEFAULTINFO = new Hashtable();
    private static Hashtable<String, String> FIELDNUMS = new Hashtable();
    private static String path;

    public static native void addFileToMPQ(String var0, String var1);

    public static void loadTRIGSTRS(String wts) throws IOException {
        File fi = new File(wts);
        FileReader fr = new FileReader(fi);
        BufferedReader br = new BufferedReader(fr);
        br.skip(3L);
        int status = 0;
        int id = 0;
        String data = null;
        while (br.ready()) {
            String line = br.readLine();
            if (status == 0) {
                if (!line.startsWith("STRING ")) continue;
                id = Integer.parseInt(line.substring(7));
                status = 1;
                continue;
            }
            if (status == 1) {
                if (!line.equals("{")) continue;
                status = 2;
                continue;
            }
            if (line.equals("}")) {
                TRIGSTRS.put("TRIGSTR_" + (id < 10 ? "0" : "") + (id < 100 ? "0" : "") + id, data);
                status = 0;
                continue;
            }
            if (status == 2) {
                data = line;
                status = 3;
                continue;
            }
            data = String.valueOf(data) + crlf + line;
        }
        fr.close();
        br.close();
    }

    public static void loadMetaData() throws IOException {
        File fi = new File(String.valueOf(path) + fise + "data" + fise + "UnitMetaData.slk");
        FileReader fr = new FileReader(fi);
        BufferedReader br = new BufferedReader(fr);
        while (br.ready()) {
            String fieldID;
            String line = br.readLine();
            if (line.startsWith("E")) break;
            if (!line.startsWith("C;X1;") || !FIELDNAMES.containsKey(fieldID = line.substring(line.indexOf("K") + 2, line.length() - 1))) continue;
            INVALID.remove(fieldID);
            line = br.readLine();
            String name = line.substring(7, line.length() - 1);
            line = br.readLine();
            String SLK = line.substring(7, line.length() - 1);
            METADATA.put("F:" + SLK + ":" + name, fieldID);
            if (!SLKS.contains(SLK)) {
                SLKS.add(SLK);
            }
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            line = br.readLine();
            String type = line.substring(7, line.length() - 1);
            if (type.equals("int")) {
                FIELDTYPES.put(fieldID, "integer");
                continue;
            }
            if (type.equals("bool")) {
                FIELDTYPES.put(fieldID, "boolean");
                continue;
            }
            if (type.endsWith("real")) {
                FIELDTYPES.put(fieldID, "real");
                continue;
            }
            FIELDTYPES.put(fieldID, "string");
        }
        fr.close();
        br.close();
    }

    public static void loadSLK(String SLKNAME) throws IOException {
        File fi = new File(String.valueOf(path) + fise + "data" + fise + SLKNAME + ".slk");
        FileReader fr = new FileReader(fi);
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        while (!line.startsWith("B")) {
            line = br.readLine();
        }
        line = line.substring(3);
        int Xmax = Integer.parseInt(line.substring(0, line.indexOf(59)));
        line = line.substring(line.indexOf(59) + 2);
        int Ymax = Integer.parseInt(line.substring(0, line.indexOf(59)));
        String[][] Table = new String[Ymax][Xmax];
        line = br.readLine();
        int x = 0;
        int y = 0;
        while (!line.equals("E")) {
            if (line.startsWith("C")) {
                line = line.substring(3);
                x = Integer.parseInt(line.substring(0, line.indexOf(59))) - 1;
                if ((line = line.substring(line.indexOf(59) + 1)).startsWith("Y")) {
                    y = Integer.parseInt(line.substring(1, line.indexOf(59))) - 1;
                    line = line.substring(line.indexOf(59) + 1);
                }
                if (line.startsWith("K")) {
                    if ((line = line.substring(1)).startsWith("\"")) {
                        Table[y][x] = line.replace("\\", "\\\\");
                        if (y == 0 || x == 0) {
                            Table[y][x] = line.substring(1, line.length() - 1);
                        }
                    } else {
                        Table[y][x] = line;
                    }
                    if (Table[y][x].equals("-")) {
                        Table[y][x] = "0";
                    }
                }
            }
            line = br.readLine();
        }
        String[] LoadVals = new String[Xmax];
        int i = 1;
        while (i < Xmax) {
            String val = METADATA.get("F:" + SLKNAME + ":" + (Table[0][i] != null ? Table[0][i].toLowerCase() : ""));
            if (val != null) {
                LoadVals[i] = val;
            }
            ++i;
        }
        boolean validated = false;
        int i2 = 1;
        while (i2 < Ymax) {
            int j = 0;
            while (j < Xmax) {
                if (j == 0) {
                    validated = UNITS.containsKey(Table[i2][j]);
                } else if (validated && LoadVals[j] != null) {
                    FIELDDEFAULTINFO.put(String.valueOf(Table[i2][0]) + ":" + LoadVals[j], Table[i2][j]);
                }
                ++j;
            }
            ++i2;
        }
        br.close();
        fr.close();
    }

    public static void loadProfile() throws IOException {
        File[] contents;
        File profile = new File(String.valueOf(path) + fise + "data" + fise + "profile");
        File[] fileArray = contents = profile.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            String line;
            File fi = fileArray[n2];
            BufferedReader br = new BufferedReader(new FileReader(fi));
            boolean inBlock = false;
            String name = null;
            while ((line = br.readLine()) != null) {
                int ind;
                String ls;
                if ((line = Reader.removeLeadingWhitespace(line)).startsWith("//") || line.indexOf("=") < 1) continue;
                if (line.startsWith("[")) {
                    name = line.substring(1, Math.min(line.length(), 5));
                    inBlock = UNITS.containsKey(name);
                    continue;
                }
                if (!inBlock || (ls = METADATA.get("F:Profile:" + line.substring(0, ind = line.indexOf("=")))) == null) continue;
                FIELDDEFAULTINFO.put(String.valueOf(name) + ":" + ls, "\"" + line.substring(ind + 1).replace("\\", "\\\\") + "\"");
            }
            br.close();
            ++n2;
        }
    }

    public static void readBytes(MarkedInputStream fis, byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            byte b = (byte)fis.read();
            if (b == 13) {
                if ((byte)fis.read() == 10) {
                    bytes[i] = 10;
                } else {
                    bytes[i] = 13;
                    fis.mark();
                }
            } else {
                bytes[i] = b;
            }
            ++i;
        }
    }

    public static void skipBytes(MarkedInputStream fis, int size) throws IOException {
        int i = 0;
        while (i < size) {
            byte b = (byte)fis.read();
            if (b == 13 && fis.read() != 10) {
                ++i;
            }
            ++i;
        }
    }

    public static int decodeInt(byte[] bytes) {
        int val = 0;
        int i = 0;
        while (i < 4) {
            val |= (bytes[i] & 0xFF) << i * 8;
            ++i;
        }
        return val;
    }

    public static String[] splitWhitespace(String in) {
        char[] chars = in.toCharArray();
        String[] out = new String[chars.length / 2];
        boolean jump = false;
        StringBuilder build = new StringBuilder();
        int ind = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                if (!jump) {
                    out[ind] = build.toString();
                    build = new StringBuilder();
                    ++ind;
                }
                jump = true;
            } else {
                jump = false;
                build.append(c);
            }
            ++n2;
        }
        String b = build.toString();
        String[] result = new String[ind + (b.isEmpty() ? 0 : 1)];
        int i = 0;
        while (i < ind) {
            result[i] = out[i];
            ++i;
        }
        if (!b.isEmpty()) {
            result[ind] = build.toString();
        }
        return result;
    }

    public static String removeLeadingWhitespace(String in) {
        char[] chs = in.toCharArray();
        int i = 0;
        while (i < chs.length && Character.isWhitespace(chs[i])) {
            ++i;
        }
        char[] out = new char[chs.length - i];
        int j = 0;
        while (i < chs.length) {
            out[j] = chs[i];
            ++j;
            ++i;
        }
        return new String(out);
    }

    public static StringBuilder doWork(String w3u, String wts) {
        StringBuilder out = new StringBuilder();
        try {
            String val;
            File fi = new File(w3u);
            MarkedInputStream fis = new MarkedInputStream(fi);
            Reader.mapRawcodesToNames();
            Reader.loadTRIGSTRS(wts);
            Reader.loadMetaData();
            for (String s : INVALID) {
                WANTS.remove(s);
            }
            fis.skip(4L);
            byte[] bytes = new byte[4];
            ArrayList<Node> nodes = new ArrayList<Node>();
            int cat = 0;
            while (cat < 2) {
                Reader.readBytes(fis, bytes);
                int len = Reader.decodeInt(bytes);
                int i = 0;
                while (i < len) {
                    Node n = new Node();
                    Reader.readBytes(fis, bytes);
                    nodes.add(n);
                    n.parent = new String(bytes);
                    Reader.readBytes(fis, bytes);
                    n.name = cat == 0 ? n.parent : new String(bytes);
                    UNITS.put(n.parent, true);
                    Reader.readBytes(fis, bytes);
                    int nvals = Reader.decodeInt(bytes);
                    boolean cut = false;
                    int v = 0;
                    while (v < nvals) {
                        if (cut) {
                            fis.skip(4L);
                        } else {
                            cut = true;
                        }
                        Reader.readBytes(fis, bytes);
                        String name = new String(bytes);
                        Reader.readBytes(fis, bytes);
                        int type = Reader.decodeInt(bytes);
                        if (type < 3) {
                            Reader.readBytes(fis, bytes);
                            int val2 = Reader.decodeInt(bytes);
                            if (type == 0) {
                                n.fields.put(name, Integer.toString(val2));
                            } else {
                                n.fields.put(name, Float.toString(Float.intBitsToFloat(val2)));
                            }
                        } else if (type == 4) {
                            n.fields.put(name, fis.read() == 1 ? "true" : "false");
                            fis.skip(3L);
                        } else {
                            char ch;
                            StringBuilder charseq = new StringBuilder();
                            while ((ch = (char)fis.read()) != '\u0000') {
                                charseq.append(ch);
                            }
                            val = charseq.toString();
                            if (val.startsWith("TRIGSTR_")) {
                                val = TRIGSTRS.get(val);
                            }
                            n.fields.put(name, "\"" + val.replace("\\", "\\\\") + "\"");
                        }
                        ++v;
                    }
                    fis.skip(4L);
                    ++i;
                }
                ++cat;
            }
            for (String SLK : SLKS) {
                if (!SLK.equals("Profile")) {
                    Reader.loadSLK(SLK);
                    continue;
                }
                Reader.loadProfile();
            }
            String[] wantedFields = WANTS.toArray(new String[WANTS.size()]);
            String[] wantedFieldTypes = new String[wantedFields.length];
            String[] wantedFieldNums = new String[wantedFields.length];
            String[] wantedFieldNameAbbreviations = new String[wantedFields.length];
            int i = 0;
            while (i < wantedFields.length) {
                String currentField = wantedFields[i];
                wantedFieldTypes[i] = FIELDTYPES.get(currentField);
                wantedFieldNums[i] = FIELDNUMS.get(currentField);
                out.append("function GetUnitType").append(FIELDNAMES.get(currentField));
                out.append(" takes integer id returns ").append(wantedFieldTypes[i]);
                out.append(crlf).append("return Load");
                wantedFieldNameAbbreviations[i] = wantedFieldTypes[i].equals("string") ? "Str" : (wantedFieldTypes[i].equals("integer") ? "Integer" : (wantedFieldTypes[i].equals("real") ? "Real" : "Boolean"));
                out.append(wantedFieldNameAbbreviations[i]).append("(info,id,");
                out.append(wantedFieldNums[i]);
                out.append(")").append(crlf).append("endfunction").append(crlf);
                ++i;
            }
            int nl = nodes.size();
            int c = 0;
            int num = 0;
            out.append("private function Init0 takes nothing returns nothing").append(crlf);
            int i2 = 0;
            while (i2 < nl) {
                Node n = (Node)nodes.get(i2);
                int j = 0;
                while (j < wantedFields.length) {
                    ++c;
                    String currentField = wantedFields[j];
                    val = n.fields.get(currentField);
                    out.append("call Save").append(wantedFieldNameAbbreviations[j]);
                    out.append("(info,'").append(n.name).append("',");
                    out.append(wantedFieldNums[j]).append(",");
                    if (val != null) {
                        out.append(val);
                    } else {
                        out.append(FIELDDEFAULTINFO.get(String.valueOf(n.parent) + ":" + currentField));
                    }
                    out.append(")").append(crlf);
                    if (c % 10000 == 0) {
                        out.append("endfunction").append(crlf).append("private function Info");
                        out.append(Integer.toString(++num));
                        out.append(" takes nothing returns nothing").append(crlf);
                    }
                    ++j;
                }
                ++i2;
            }
            out.append("endfunction").append(crlf);
            out.append("function InitExportedUnitData takes nothing returns nothing").append(crlf);
            out.append("if alreadyRan then").append(crlf);
            out.append("return").append(crlf);
            out.append("endif").append(crlf);
            out.append("set alreadyRan = true").append(crlf);
            while (num >= 0) {
                out.append("call ExecuteFunc(SCOPE_PRIVATE+\"Init").append(Integer.toString(num--));
                out.append("\")").append(crlf);
            }
            out.append("endfunction").append(crlf);
            fis.close();
        }
        catch (Exception ex) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            ex.printStackTrace(printWriter);
            JOptionPane.showMessageDialog(null, "Error in Object Data Exporter:\n" + result.toString());
            ex.printStackTrace();
        }
        return out;
    }

    public static void main(String[] args) {
        try {
            String ln;
            path = args[0];
            File script = new File(args[2]);
            BufferedReader br = new BufferedReader(new FileReader(script));
            StringBuilder out = new StringBuilder();
            StringBuilder mark = null;
            boolean found = false;
            boolean loadexists = false;
            boolean noinit = false;
            int fieldval = 0;
            while ((ln = br.readLine()) != null) {
                String[] words;
                if (ln.isEmpty()) continue;
                String rls = Reader.removeLeadingWhitespace(ln);
                if (!found && rls.startsWith("endglobals")) {
                    out.append(ln).append(crlf);
                    mark = out;
                    out = new StringBuilder();
                    found = true;
                    continue;
                }
                if (rls.startsWith("//!")) {
                    words = Reader.splitWhitespace(rls);
                    if (words.length > 1 && words[1].toLowerCase().equals("loadunitdata")) {
                        loadexists = true;
                        boolean thisnoinit = false;
                        if (words.length > 2 && words[2].toLowerCase().equals("-noinit")) {
                            noinit = true;
                            thisnoinit = true;
                        }
                        if (words.length <= 2 && (words.length <= 3 || !thisnoinit)) continue;
                        int i = thisnoinit ? 3 : 2;
                        while (i < words.length) {
                            if (!FIELDNUMS.containsKey(words[i])) {
                                WANTS.add(words[i]);
                                INVALID.add(words[i]);
                                FIELDNUMS.put(words[i], Integer.toString(fieldval++));
                            }
                            ++i;
                        }
                        continue;
                    }
                    out.append(ln).append(crlf);
                    continue;
                }
                if (rls.startsWith("library")) {
                    words = Reader.splitWhitespace(ln);
                    boolean hasReq = false;
                    boolean isReq = false;
                    int i = 0;
                    while (i < words.length) {
                        if (hasReq) {
                            if (words[i].equals("ExportedUnitData,") || words[i].equals("ExportedUnitData")) {
                                isReq = true;
                            }
                        } else if (words[i].equals("requires") || words[i].equals("uses") || words[i].equals("needs")) {
                            hasReq = true;
                        }
                        ++i;
                    }
                    out.append(ln);
                    if (!hasReq) {
                        out.append(" requires ExportedUnitData");
                    } else if (!isReq) {
                        out.append(',').append("ExportedUnitData");
                    }
                    out.append(crlf);
                    continue;
                }
                out.append(ln).append(crlf);
            }
            br.close();
            if (loadexists) {
                mark.append("library ExportedUnitData");
                if (!noinit) {
                    mark.append(" initializer InitExportedUnitData");
                }
                mark.append(crlf);
                mark.append("globals").append(crlf);
                mark.append("private hashtable info = InitHashtable()").append(crlf);
                mark.append("private boolean alreadyRan = false").append(crlf);
                mark.append("constant boolean UNIT_DATA_NOINIT = " + (noinit ? "true" : "false")).append(crlf);
                mark.append("endglobals").append(crlf);
                mark.append((CharSequence)Reader.doWork(args[3], args[4]));
                mark.append("endlibrary").append(crlf);
                BufferedWriter bw = new BufferedWriter(new FileWriter(script));
                bw.write(mark.toString());
                bw.write(out.toString());
                bw.close();
                System.load(String.valueOf(new File("").getAbsolutePath()) + fise + path + fise + "ODE.dll");
                Reader.addFileToMPQ(args[1], args[2]);
            }
        }
        catch (Exception ex) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            ex.printStackTrace(printWriter);
            JOptionPane.showMessageDialog(null, "Error in Object Data Exporter:\n" + result.toString());
            ex.printStackTrace();
        }
    }

    public static void mapRawcodesToNames() {
        FIELDNAMES.put("udaa", "DefaultActiveAbility");
        FIELDNAMES.put("uhab", "HeroAbilities");
        FIELDNAMES.put("uabi", "Abilities");
        FIELDNAMES.put("utcc", "AllowCustomTeamColor");
        FIELDNAMES.put("uble", "BlendTime");
        FIELDNAMES.put("ucbs", "CastBackswing");
        FIELDNAMES.put("ucpt", "CastPoint");
        FIELDNAMES.put("urun", "RunSpeed");
        FIELDNAMES.put("uwal", "WalkSpeed");
        FIELDNAMES.put("ubpx", "ButtonPositionX");
        FIELDNAMES.put("ubpy", "ButtonPositionY");
        FIELDNAMES.put("udtm", "DeathTime");
        FIELDNAMES.put("uept", "ElevationSamplePoints");
        FIELDNAMES.put("uerd", "ElevationSampleRadius");
        FIELDNAMES.put("ufrd", "FogOfWarSampleRadius");
        FIELDNAMES.put("uubs", "GroundTexture");
        FIELDNAMES.put("ushr", "HasWaterShadow");
        FIELDNAMES.put("uico", "Icon");
        FIELDNAMES.put("ussi", "ScoreScreenIcon");
        FIELDNAMES.put("umxp", "MaxPitch");
        FIELDNAMES.put("umxr", "MaxRoll");
        FIELDNAMES.put("umdl", "Model");
        FIELDNAMES.put("uver", "ModelExtraVersions");
        FIELDNAMES.put("uocc", "OcculderHeight");
        FIELDNAMES.put("uori", "OrientationInterpolation");
        FIELDNAMES.put("uisz", "SwimProjectileImpactZ");
        FIELDNAMES.put("uimz", "ProjectileImpactZ");
        FIELDNAMES.put("ulpx", "ProjectileLaunchX");
        FIELDNAMES.put("ulsz", "SwimProjectileLaunchZ");
        FIELDNAMES.put("ulpz", "ProjectileLaunchZ");
        FIELDNAMES.put("uprw", "PropulsionWindow");
        FIELDNAMES.put("uani", "RequiredAnimationNames");
        FIELDNAMES.put("uaap", "RequiredAnimationAttachments");
        FIELDNAMES.put("ualp", "RequiredAnimationLinkNames");
        FIELDNAMES.put("ubpr", "RequiredBoneNames");
        FIELDNAMES.put("uscb", "ScaleProjectiles");
        FIELDNAMES.put("usca", "Scale");
        FIELDNAMES.put("uslz", "SelectionZ");
        FIELDNAMES.put("usew", "SelectionOnWater");
        FIELDNAMES.put("ussc", "SelectionScale");
        FIELDNAMES.put("ushu", "ShadowImage");
        FIELDNAMES.put("ushx", "ShadowImageCenterX");
        FIELDNAMES.put("ushy", "ShadowImageCenterY");
        FIELDNAMES.put("ushh", "ShadowImageHeight");
        FIELDNAMES.put("ushw", "ShadowImageWidth");
        FIELDNAMES.put("ushb", "ShadowTexture");
        FIELDNAMES.put("uspa", "SpecialArt");
        FIELDNAMES.put("utaa", "TargetArt");
        FIELDNAMES.put("utco", "TeamColor");
        FIELDNAMES.put("uclr", "RedTint");
        FIELDNAMES.put("uclg", "GreenTint");
        FIELDNAMES.put("uclb", "BlueTint");
        FIELDNAMES.put("ulos", "UseExtendedLineOfSight");
        FIELDNAMES.put("uacq", "AcquisitionRange");
        FIELDNAMES.put("uarm", "ArmorType");
        FIELDNAMES.put("ubs1", "BackswingPoint1");
        FIELDNAMES.put("udp1", "DamagePoint1");
        FIELDNAMES.put("ua1f", "AreaOfEffectFull1");
        FIELDNAMES.put("ua1h", "AreaOfEffectMedium1");
        FIELDNAMES.put("ua1q", "AreaOfEffectSmall1");
        FIELDNAMES.put("ua1p", "AreaOfEffectTargets1");
        FIELDNAMES.put("ua1t", "AttackType1");
        FIELDNAMES.put("ua1c", "Cooldown1");
        FIELDNAMES.put("ua1b", "DamageBase1");
        FIELDNAMES.put("uhd1", "DamageFactorMedium1");
        FIELDNAMES.put("uqd1", "DamageFactorSmall1");
        FIELDNAMES.put("udl1", "DamageLossFactor1");
        FIELDNAMES.put("ua1d", "DamageNumberOfDice1");
        FIELDNAMES.put("ua1s", "DamageSidesPerDie1");
        FIELDNAMES.put("usd1", "DamageSpillDistance1");
        FIELDNAMES.put("usr1", "DamageSpillRadius1");
        FIELDNAMES.put("udu1", "DamageUpgradeAmount1");
        FIELDNAMES.put("utc1", "MaximumTargets1");
        FIELDNAMES.put("uma1", "ProjectileArc1");
        FIELDNAMES.put("ua1m", "ProjectileArt1");
        FIELDNAMES.put("umh1", "ProjectileHoming1");
        FIELDNAMES.put("ua1z", "ProjectileSpeed1");
        FIELDNAMES.put("ua1r", "Range1");
        FIELDNAMES.put("urb1", "RangeMotionBuffer1");
        FIELDNAMES.put("uwu1", "ShowUI1");
        FIELDNAMES.put("ua1g", "TargetsAllowed1");
        FIELDNAMES.put("ucs1", "WeaponSound1");
        FIELDNAMES.put("ua1w", "WeaponType1");
        FIELDNAMES.put("ubs2", "BackswingPoint2");
        FIELDNAMES.put("udp2", "DamagePoint2");
        FIELDNAMES.put("ua2f", "AreaOfEffectFull2");
        FIELDNAMES.put("ua2h", "AreaOfEffectMedium2");
        FIELDNAMES.put("ua2q", "AreaOfEffectSmall2");
        FIELDNAMES.put("ua2p", "AreaOfEffectTargets2");
        FIELDNAMES.put("ua2t", "AttackType2");
        FIELDNAMES.put("ua2c", "Cooldown2");
        FIELDNAMES.put("ua2b", "DamageBase2");
        FIELDNAMES.put("uhd2", "DamageFactorMedium2");
        FIELDNAMES.put("uqd2", "DamageFactorSmall2");
        FIELDNAMES.put("udl2", "DamageLossFactor2");
        FIELDNAMES.put("ua2d", "DamageNumberOfDice2");
        FIELDNAMES.put("ua2s", "DamageSidesPerDie2");
        FIELDNAMES.put("usd2", "DamageSpillDistance2");
        FIELDNAMES.put("usr2", "DamageSpillRadius2");
        FIELDNAMES.put("udu2", "DamageUpgradeAmount2");
        FIELDNAMES.put("utc2", "MaximumTargets2");
        FIELDNAMES.put("uma2", "ProjectileArc2");
        FIELDNAMES.put("ua2m", "ProjectileArt2");
        FIELDNAMES.put("umh2", "ProjectileHoming2");
        FIELDNAMES.put("ua2z", "ProjectileSpeed2");
        FIELDNAMES.put("ua2r", "Range2");
        FIELDNAMES.put("urb2", "RangeMotionBuffer2");
        FIELDNAMES.put("uwu2", "ShowUI2");
        FIELDNAMES.put("ua2g", "TargetsAllowed2");
        FIELDNAMES.put("ucs2", "WeaponSound2");
        FIELDNAMES.put("ua2w", "WeaponType2");
        FIELDNAMES.put("uaen", "AttacksEnabled");
        FIELDNAMES.put("udea", "DeathType");
        FIELDNAMES.put("udef", "DefenseBase");
        FIELDNAMES.put("udty", "DefenseType");
        FIELDNAMES.put("udup", "DefenseUpgradeBonus");
        FIELDNAMES.put("uamn", "MinimumAttackRange");
        FIELDNAMES.put("utar", "TargetedAs");
        FIELDNAMES.put("udro", "DropItemsOnDeath");
        FIELDNAMES.put("ucam", "CategoryCampaign");
        FIELDNAMES.put("uspe", "CategorySpecial");
        FIELDNAMES.put("uhos", "DisplayAsNeutralHostile");
        FIELDNAMES.put("utss", "HasTilesetSpecificData");
        FIELDNAMES.put("uine", "PlaceableInEditor");
        FIELDNAMES.put("util", "Tilesets");
        FIELDNAMES.put("uuch", "UseClickHelper");
        FIELDNAMES.put("urpo", "GroupSeparationEnabled");
        FIELDNAMES.put("urpg", "GroupSeparationGroupNumber");
        FIELDNAMES.put("urpp", "GroupSeparationParameter");
        FIELDNAMES.put("urpr", "GroupSeparationPriority");
        FIELDNAMES.put("umvh", "FlyHeight");
        FIELDNAMES.put("umvf", "MinimumHeight");
        FIELDNAMES.put("umvs", "SpeedBase");
        FIELDNAMES.put("umas", "SpeedMaximum");
        FIELDNAMES.put("umis", "SpeedMinimum");
        FIELDNAMES.put("umvr", "TurnRate");
        FIELDNAMES.put("umvt", "MoveType");
        FIELDNAMES.put("uabr", "AIPlacementRadius");
        FIELDNAMES.put("uabt", "AIPlacementType");
        FIELDNAMES.put("ucol", "CollisionSize");
        FIELDNAMES.put("upat", "PathingMap");
        FIELDNAMES.put("upar", "PlacementPreventedBy");
        FIELDNAMES.put("upap", "PlacementRequires");
        FIELDNAMES.put("upaw", "PlacementRequiresWaterRadius");
        FIELDNAMES.put("ubsl", "BuildSound");
        FIELDNAMES.put("ulfi", "SoundLoopFadeInRate");
        FIELDNAMES.put("ulfo", "SoundLoopFadeOutRate");
        FIELDNAMES.put("umsl", "MoveSound");
        FIELDNAMES.put("ursl", "RandomSound");
        FIELDNAMES.put("usnd", "SoundSet");
        FIELDNAMES.put("uagp", "AgilityPerLevel");
        FIELDNAMES.put("ubld", "BuildTime");
        FIELDNAMES.put("uibo", "CanBeBuiltOn");
        FIELDNAMES.put("ucbo", "CanBuildOn");
        FIELDNAMES.put("ufle", "CanFlee");
        FIELDNAMES.put("ufoo", "FoodCost");
        FIELDNAMES.put("ufma", "FoodProduced");
        FIELDNAMES.put("ufor", "FormationRank");
        FIELDNAMES.put("ubba", "GoldBountyBase");
        FIELDNAMES.put("ubdi", "GoldBountyNumberOfDice");
        FIELDNAMES.put("ubsi", "GoldBountySidesPerDie");
        FIELDNAMES.put("ugol", "GoldCost");
        FIELDNAMES.put("uhhd", "HideHeroDeathMessage");
        FIELDNAMES.put("uhhb", "HideHeroInterfaceIcon");
        FIELDNAMES.put("uhhm", "HideHeroMinimapDisplay");
        FIELDNAMES.put("uhom", "HideMinimapDisplay");
        FIELDNAMES.put("uhpm", "HitPointsMaximum");
        FIELDNAMES.put("uhpr", "HitPointsRegeneration");
        FIELDNAMES.put("uhrt", "HitPointsRegenerationType");
        FIELDNAMES.put("uinp", "IntelligencePerLevel");
        FIELDNAMES.put("ubdg", "IsABuilding");
        FIELDNAMES.put("ulev", "Level");
        FIELDNAMES.put("ulba", "LumberBountyBase");
        FIELDNAMES.put("ulbd", "LumberBountyNumberOfDice");
        FIELDNAMES.put("ulbs", "LumberBountySidesPerDie");
        FIELDNAMES.put("ulum", "LumberCost");
        FIELDNAMES.put("umpi", "ManaInitialAmount");
        FIELDNAMES.put("umpm", "ManaMaximum");
        FIELDNAMES.put("umpr", "ManaRegeneration");
        FIELDNAMES.put("unbm", "ShowNeutralBuildingIcon");
        FIELDNAMES.put("unbr", "ValidAsRandomNeutralBuilding");
        FIELDNAMES.put("upoi", "PointValue");
        FIELDNAMES.put("upra", "PrimaryAttribute");
        FIELDNAMES.put("upri", "Priority");
        FIELDNAMES.put("urac", "Race");
        FIELDNAMES.put("ugor", "RepairGoldCost");
        FIELDNAMES.put("ulur", "RepairLumberCost");
        FIELDNAMES.put("urtm", "RepairTime");
        FIELDNAMES.put("usid", "SightRadiusDay");
        FIELDNAMES.put("usin", "SightRadiusNight");
        FIELDNAMES.put("usle", "Sleeps");
        FIELDNAMES.put("uagi", "StartingAgility");
        FIELDNAMES.put("uint", "StartingIntelligence");
        FIELDNAMES.put("ustr", "StartingStrength");
        FIELDNAMES.put("usma", "StockMaximum");
        FIELDNAMES.put("usrg", "StockReplenishInterval");
        FIELDNAMES.put("usst", "StockStartDelay");
        FIELDNAMES.put("ustp", "StrengthPerLevel");
        FIELDNAMES.put("ucar", "TransportedSize");
        FIELDNAMES.put("utyp", "UnitClassification");
        FIELDNAMES.put("udep", "DependencyEquivalents");
        FIELDNAMES.put("urva", "HeroRevivalLocations");
        FIELDNAMES.put("umki", "ItemsMade");
        FIELDNAMES.put("usei", "ItemsSold");
        FIELDNAMES.put("ureq", "Requirements");
        FIELDNAMES.put("urqa", "RequirementsLevels");
        FIELDNAMES.put("urq1", "RequirementsTier2");
        FIELDNAMES.put("urq2", "RequirementsTier3");
        FIELDNAMES.put("urq3", "RequirementsTier4");
        FIELDNAMES.put("urq4", "RequirementsTier5");
        FIELDNAMES.put("urq5", "RequirementsTier6");
        FIELDNAMES.put("urq6", "RequirementsTier7");
        FIELDNAMES.put("urq7", "RequirementsTier8");
        FIELDNAMES.put("urq8", "RequirementsTier9");
        FIELDNAMES.put("urqc", "RequirementsTiersUsed");
        FIELDNAMES.put("ubui", "StructuresBuilt");
        FIELDNAMES.put("ures", "ResearchesAvailable");
        FIELDNAMES.put("urev", "RevivesDeadHeroes");
        FIELDNAMES.put("useu", "UnitsSold");
        FIELDNAMES.put("utra", "UnitsTrained");
        FIELDNAMES.put("uupt", "UpgradesTo");
        FIELDNAMES.put("upgr", "UpgradesUsed");
        FIELDNAMES.put("ides", "Description");
        FIELDNAMES.put("uhot", "Hotkey");
        FIELDNAMES.put("unam", "Name");
        FIELDNAMES.put("unsf", "NameEditorSuffix");
        FIELDNAMES.put("upro", "ProperNames");
        FIELDNAMES.put("upru", "ProperNamesUsed");
        FIELDNAMES.put("uawt", "AwakenTooltip");
        FIELDNAMES.put("utip", "Tooltip");
        FIELDNAMES.put("utub", "Ubertip");
        FIELDNAMES.put("utpr", "ReviveTooltip");
    }
}

